/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.tools;

import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.ml.common.ToolMetadata;
import org.opensearch.ml.common.transport.tools.MLToolGetRequest;
import org.opensearch.ml.common.transport.tools.MLToolGetResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetToolTransportAction
extends HandledTransportAction<ActionRequest, MLToolGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetToolTransportAction.class);

    @Inject
    public GetToolTransportAction(TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/opensearch/ml/tools/get", transportService, actionFilters, MLToolGetRequest::new);
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLToolGetResponse> listener) {
        MLToolGetRequest mlToolGetRequest = MLToolGetRequest.fromActionRequest((ActionRequest)request);
        String toolName = mlToolGetRequest.getToolName();
        try {
            List toolsList = mlToolGetRequest.getToolMetadataList();
            ToolMetadata theTool = toolsList.stream().filter(tool -> tool.getName().equals(toolName)).findFirst().orElseThrow(() -> new OpenSearchStatusException("Failed to find tool information with the provided tool name: " + toolName, RestStatus.NOT_FOUND, new Object[0]));
            listener.onResponse((Object)MLToolGetResponse.builder().toolMetadata(theTool).build());
        }
        catch (Exception e) {
            log.error("Failed to get tool", (Throwable)e);
            listener.onFailure(e);
        }
    }
}

