/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.helper;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.memorycontainer.MemoryStorageConfig;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.client.Client;

public class MemoryContainerHelper {
    @Generated
    private static final Logger log = LogManager.getLogger(MemoryContainerHelper.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public MemoryContainerHelper(Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
    }

    public void getMemoryContainer(String memoryContainerId, ActionListener<MLMemoryContainer> listener) {
        this.getMemoryContainer(memoryContainerId, null, listener);
    }

    public void getMemoryContainer(String memoryContainerId, String tenantId, ActionListener<MLMemoryContainer> listener) {
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest.Builder requestBuilder = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-memory-container")).id(memoryContainerId)).fetchSourceContext(fetchSourceContext);
        if (tenantId != null) {
            requestBuilder.tenantId(tenantId);
        }
        GetDataObjectRequest getDataObjectRequest = requestBuilder.build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                block13: {
                    if (throwable != null) {
                        Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        if (ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                            wrappedListener.onFailure((Exception)new OpenSearchStatusException("Memory container not found", RestStatus.NOT_FOUND, new Object[0]));
                        } else {
                            wrappedListener.onFailure(cause);
                        }
                    } else {
                        try {
                            if (r.getResponse() != null && r.getResponse().isExists()) {
                                try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, r.getResponse().getSourceAsString());){
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    MLMemoryContainer container = MLMemoryContainer.parse((XContentParser)parser);
                                    wrappedListener.onResponse((Object)container);
                                    break block13;
                                }
                            }
                            wrappedListener.onFailure((Exception)new OpenSearchStatusException("Memory container not found", RestStatus.NOT_FOUND, new Object[0]));
                        }
                        catch (Exception e) {
                            wrappedListener.onFailure(e);
                        }
                    }
                }
            });
        }
    }

    public boolean checkMemoryContainerAccess(User user, MLMemoryContainer mlMemoryContainer) {
        if (user == null) {
            return true;
        }
        if (user.getRoles() != null && user.getRoles().contains("all_access")) {
            return true;
        }
        User owner = mlMemoryContainer.getOwner();
        if (owner != null && owner.getName() != null && owner.getName().equals(user.getName())) {
            return true;
        }
        if (owner != null && owner.getBackendRoles() != null && user.getBackendRoles() != null) {
            return owner.getBackendRoles().stream().anyMatch(role -> user.getBackendRoles().contains(role));
        }
        return false;
    }

    public String getMemoryIndexName(MLMemoryContainer container) {
        MemoryStorageConfig config = container.getMemoryStorageConfig();
        if (config != null && config.getMemoryIndexName() != null) {
            return config.getMemoryIndexName();
        }
        return null;
    }

    public boolean validateMemoryIndexExists(MLMemoryContainer container, String actionName, ActionListener<?> listener) {
        String indexName = this.getMemoryIndexName(container);
        if (indexName == null || indexName.isEmpty()) {
            listener.onFailure((Exception)new OpenSearchStatusException("Memory container does not have a memory index configured for " + actionName, RestStatus.BAD_REQUEST, new Object[0]));
            return false;
        }
        return true;
    }
}

