/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.searchrelevance.stats.events.EventStatName;
import org.opensearch.searchrelevance.stats.info.InfoStatName;

public class SearchRelevanceStatsInput
implements ToXContentObject,
Writeable {
    public static final String NODE_IDS_FIELD = "node_ids";
    public static final String EVENT_STAT_NAMES_FIELD = "event_stats";
    public static final String STATE_STAT_NAMES_FIELD = "state_stats";
    private List<String> nodeIds;
    private EnumSet<EventStatName> eventStatNames;
    private EnumSet<InfoStatName> infoStatNames;
    private boolean includeMetadata;
    private boolean flatten;
    private boolean includeIndividualNodes;
    private boolean includeAllNodes;
    private boolean includeInfo;

    public SearchRelevanceStatsInput(List<String> nodeIds, EnumSet<EventStatName> eventStatNames, EnumSet<InfoStatName> infoStatNames, boolean includeMetadata, boolean flatten, boolean includeIndividualNodes, boolean includeAllNodes, boolean includeInfo) {
        this.nodeIds = nodeIds;
        this.eventStatNames = eventStatNames;
        this.infoStatNames = infoStatNames;
        this.includeMetadata = includeMetadata;
        this.flatten = flatten;
        this.includeIndividualNodes = includeIndividualNodes;
        this.includeAllNodes = includeAllNodes;
        this.includeInfo = includeInfo;
    }

    public SearchRelevanceStatsInput() {
        this.nodeIds = new ArrayList<String>();
        this.eventStatNames = EnumSet.noneOf(EventStatName.class);
        this.infoStatNames = EnumSet.noneOf(InfoStatName.class);
        this.includeMetadata = false;
        this.flatten = false;
        this.includeIndividualNodes = true;
        this.includeAllNodes = true;
        this.includeInfo = true;
    }

    public SearchRelevanceStatsInput(StreamInput input) throws IOException {
        this.nodeIds = input.readOptionalStringList();
        this.eventStatNames = input.readOptionalEnumSet(EventStatName.class);
        this.infoStatNames = input.readOptionalEnumSet(InfoStatName.class);
        this.includeMetadata = input.readBoolean();
        this.flatten = input.readBoolean();
        this.includeIndividualNodes = input.readBoolean();
        this.includeAllNodes = input.readBoolean();
        this.includeInfo = input.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalStringCollection(this.nodeIds);
        out.writeOptionalEnumSet(this.eventStatNames);
        out.writeOptionalEnumSet(this.infoStatNames);
        out.writeBoolean(this.includeMetadata);
        out.writeBoolean(this.flatten);
        out.writeBoolean(this.includeIndividualNodes);
        out.writeBoolean(this.includeAllNodes);
        out.writeBoolean(this.includeInfo);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.nodeIds != null) {
            builder.field(NODE_IDS_FIELD, this.nodeIds);
        }
        if (this.eventStatNames != null) {
            builder.field(EVENT_STAT_NAMES_FIELD, this.eventStatNames);
        }
        if (this.infoStatNames != null) {
            builder.field(STATE_STAT_NAMES_FIELD, this.infoStatNames);
        }
        builder.field("include_metadata", this.includeMetadata);
        builder.field("flat_stat_paths", this.flatten);
        builder.field("include_individual_nodes", this.includeIndividualNodes);
        builder.field("include_all_nodes", this.includeAllNodes);
        builder.field("include_info", this.includeInfo);
        builder.endObject();
        return builder;
    }

    public boolean isIncludeEvents() {
        return this.isIncludeAllNodes() || this.isIncludeIndividualNodes();
    }

    @Generated
    public static SearchRelevanceStatsInputBuilder builder() {
        return new SearchRelevanceStatsInputBuilder();
    }

    @Generated
    public List<String> getNodeIds() {
        return this.nodeIds;
    }

    @Generated
    public EnumSet<EventStatName> getEventStatNames() {
        return this.eventStatNames;
    }

    @Generated
    public EnumSet<InfoStatName> getInfoStatNames() {
        return this.infoStatNames;
    }

    @Generated
    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }

    @Generated
    public boolean isFlatten() {
        return this.flatten;
    }

    @Generated
    public boolean isIncludeIndividualNodes() {
        return this.includeIndividualNodes;
    }

    @Generated
    public boolean isIncludeAllNodes() {
        return this.includeAllNodes;
    }

    @Generated
    public boolean isIncludeInfo() {
        return this.includeInfo;
    }

    @Generated
    public void setIncludeMetadata(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    @Generated
    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    @Generated
    public void setIncludeIndividualNodes(boolean includeIndividualNodes) {
        this.includeIndividualNodes = includeIndividualNodes;
    }

    @Generated
    public void setIncludeAllNodes(boolean includeAllNodes) {
        this.includeAllNodes = includeAllNodes;
    }

    @Generated
    public void setIncludeInfo(boolean includeInfo) {
        this.includeInfo = includeInfo;
    }

    @Generated
    public static class SearchRelevanceStatsInputBuilder {
        @Generated
        private List<String> nodeIds;
        @Generated
        private EnumSet<EventStatName> eventStatNames;
        @Generated
        private EnumSet<InfoStatName> infoStatNames;
        @Generated
        private boolean includeMetadata;
        @Generated
        private boolean flatten;
        @Generated
        private boolean includeIndividualNodes;
        @Generated
        private boolean includeAllNodes;
        @Generated
        private boolean includeInfo;

        @Generated
        SearchRelevanceStatsInputBuilder() {
        }

        @Generated
        public SearchRelevanceStatsInputBuilder nodeIds(List<String> nodeIds) {
            this.nodeIds = nodeIds;
            return this;
        }

        @Generated
        public SearchRelevanceStatsInputBuilder eventStatNames(EnumSet<EventStatName> eventStatNames) {
            this.eventStatNames = eventStatNames;
            return this;
        }

        @Generated
        public SearchRelevanceStatsInputBuilder infoStatNames(EnumSet<InfoStatName> infoStatNames) {
            this.infoStatNames = infoStatNames;
            return this;
        }

        @Generated
        public SearchRelevanceStatsInputBuilder includeMetadata(boolean includeMetadata) {
            this.includeMetadata = includeMetadata;
            return this;
        }

        @Generated
        public SearchRelevanceStatsInputBuilder flatten(boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        @Generated
        public SearchRelevanceStatsInputBuilder includeIndividualNodes(boolean includeIndividualNodes) {
            this.includeIndividualNodes = includeIndividualNodes;
            return this;
        }

        @Generated
        public SearchRelevanceStatsInputBuilder includeAllNodes(boolean includeAllNodes) {
            this.includeAllNodes = includeAllNodes;
            return this;
        }

        @Generated
        public SearchRelevanceStatsInputBuilder includeInfo(boolean includeInfo) {
            this.includeInfo = includeInfo;
            return this;
        }

        @Generated
        public SearchRelevanceStatsInput build() {
            return new SearchRelevanceStatsInput(this.nodeIds, this.eventStatNames, this.infoStatNames, this.includeMetadata, this.flatten, this.includeIndividualNodes, this.includeAllNodes, this.includeInfo);
        }

        @Generated
        public String toString() {
            return "SearchRelevanceStatsInput.SearchRelevanceStatsInputBuilder(nodeIds=" + String.valueOf(this.nodeIds) + ", eventStatNames=" + String.valueOf(this.eventStatNames) + ", infoStatNames=" + String.valueOf(this.infoStatNames) + ", includeMetadata=" + this.includeMetadata + ", flatten=" + this.flatten + ", includeIndividualNodes=" + this.includeIndividualNodes + ", includeAllNodes=" + this.includeAllNodes + ", includeInfo=" + this.includeInfo + ")";
        }
    }
}

