/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugins;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.store.Directory;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.store.IndexStoreListener;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.indices.recovery.RecoveryState;
import org.opensearch.threadpool.ThreadPool;

@PublicApi(since="1.0.0")
public interface IndexStorePlugin {
    public Map<String, DirectoryFactory> getDirectoryFactories();

    default public Map<String, CompositeDirectoryFactory> getCompositeDirectoryFactories() {
        return Collections.emptyMap();
    }

    default public Map<String, RecoveryStateFactory> getRecoveryStateFactories() {
        return Collections.emptyMap();
    }

    default public Optional<IndexStoreListener> getIndexStoreListener() {
        return Optional.empty();
    }

    @FunctionalInterface
    @PublicApi(since="1.0.0")
    public static interface RecoveryStateFactory {
        public RecoveryState newRecoveryState(ShardRouting var1, DiscoveryNode var2, @Nullable DiscoveryNode var3);
    }

    @FunctionalInterface
    @ExperimentalApi
    public static interface CompositeDirectoryFactory {
        public Directory newDirectory(IndexSettings var1, ShardPath var2, DirectoryFactory var3, Directory var4, FileCache var5, ThreadPool var6) throws IOException;
    }

    @FunctionalInterface
    @PublicApi(since="1.0.0")
    public static interface DirectoryFactory {
        public Directory newDirectory(IndexSettings var1, ShardPath var2) throws IOException;
    }
}

