/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.opensearch.common.Explicit;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MapXContentParser;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.AbstractPointGeometryFieldMapper;
import org.opensearch.index.mapper.ArraySourceValueFetcher;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.TypeParsers;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.search.lookup.SearchLookup;

public abstract class AbstractGeometryFieldMapper<Parsed, Processed>
extends FieldMapper {
    protected Explicit<Boolean> ignoreMalformed;
    protected Explicit<Boolean> ignoreZValue;

    protected AbstractGeometryFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.ignoreZValue = ignoreZValue;
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        AbstractGeometryFieldMapper gsfm = (AbstractGeometryFieldMapper)other;
        if (gsfm.ignoreMalformed.explicit()) {
            this.ignoreMalformed = gsfm.ignoreMalformed;
        }
        if (gsfm.ignoreZValue.explicit()) {
            this.ignoreZValue = gsfm.ignoreZValue;
        }
    }

    @Override
    public AbstractGeometryFieldType<Parsed, Processed> fieldType() {
        return (AbstractGeometryFieldType)this.mappedFieldType;
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    protected abstract void addStoredFields(ParseContext var1, Processed var2);

    protected abstract void addDocValuesFields(String var1, Processed var2, List<IndexableField> var3, ParseContext var4);

    protected abstract void addMultiFields(ParseContext var1, Processed var2) throws IOException;

    @Override
    public void parse(ParseContext context) throws IOException {
        MappedFieldType mappedFieldType = this.fieldType();
        Indexer geometryIndexer = ((AbstractGeometryFieldType)mappedFieldType).geometryIndexer();
        Parser geometryParser = ((AbstractGeometryFieldType)mappedFieldType).geometryParser();
        try {
            Object shape = context.parseExternalValue(geometryIndexer.processedClass());
            if (shape == null) {
                Object geometry = geometryParser.parse(context.parser());
                if (geometry == null) {
                    return;
                }
                shape = geometryIndexer.prepareForIndexing(geometry);
            }
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            if (mappedFieldType.isSearchable() || mappedFieldType.hasDocValues()) {
                fields.addAll(geometryIndexer.indexShape(context, shape));
            }
            ArrayList<IndexableField> indexedFields = new ArrayList<IndexableField>();
            if (mappedFieldType.isSearchable()) {
                indexedFields.addAll(fields);
            }
            if (this.fieldType.stored()) {
                this.addStoredFields(context, shape);
            }
            if (this.fieldType().hasDocValues()) {
                this.addDocValuesFields(mappedFieldType.name(), shape, fields, context);
            } else if (this.fieldType.stored() || this.fieldType().isSearchable()) {
                this.createFieldNamesField(context);
            }
            for (IndexableField field : indexedFields) {
                context.doc().add(field);
            }
            this.addMultiFields(context, shape);
        }
        catch (Exception e) {
            if (!((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                throw new MapperParsingException("failed to parse field [{}] of type [{}]", e, this.fieldType().name(), this.fieldType().typeName());
            }
            context.addIgnoredField(mappedFieldType.name());
        }
    }

    @Override
    public void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field(Names.IGNORE_MALFORMED.getPreferredName(), (Boolean)this.ignoreMalformed.value());
        }
        if (includeDefaults || this.ignoreZValue.explicit()) {
            builder.field(Names.IGNORE_Z_VALUE.getPreferredName(), (Boolean)this.ignoreZValue.value());
        }
    }

    @Override
    protected Explicit<Boolean> ignoreMalformed() {
        return this.ignoreMalformed;
    }

    public Explicit<Boolean> ignoreZValue() {
        return this.ignoreZValue;
    }

    public static abstract class AbstractGeometryFieldType<Parsed, Processed>
    extends MappedFieldType {
        protected Indexer<Parsed, Processed> geometryIndexer;
        protected Parser<Parsed> geometryParser;
        protected final boolean parsesArrayValue;

        protected AbstractGeometryFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, boolean parsesArrayValue, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.parsesArrayValue = parsesArrayValue;
        }

        public void setGeometryIndexer(Indexer<Parsed, Processed> geometryIndexer) {
            this.geometryIndexer = geometryIndexer;
        }

        protected Indexer<Parsed, Processed> geometryIndexer() {
            return this.geometryIndexer;
        }

        public void setGeometryParser(Parser<Parsed> geometryParser) {
            this.geometryParser = geometryParser;
        }

        protected Parser<Parsed> geometryParser() {
            return this.geometryParser;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Geometry fields do not support exact searching, use dedicated geometry queries instead: [" + this.name() + "]", new Object[0]);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            String geoFormat = format != null ? format : "geojson";
            final Function<Object, Object> valueParser = value -> this.geometryParser.parseAndFormatObject(value, geoFormat);
            if (this.parsesArrayValue) {
                return new ArraySourceValueFetcher(this, this.name(), context){

                    @Override
                    protected Object parseSourceValue(Object value) {
                        return valueParser.apply(value);
                    }
                };
            }
            return new SourceValueFetcher(this, this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    return valueParser.apply(value);
                }
            };
        }
    }

    public static interface Indexer<Parsed, Processed> {
        public Processed prepareForIndexing(Parsed var1);

        public Class<Processed> processedClass();

        public List<IndexableField> indexShape(ParseContext var1, Processed var2);
    }

    public static abstract class Parser<Parsed> {
        public abstract Parsed parse(XContentParser var1) throws IOException, ParseException;

        public abstract Object format(Parsed var1, String var2);

        public Object parseAndFormatObject(Object value, String format) {
            Parsed geometry;
            try (MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, Collections.singletonMap("dummy_field", value), MediaTypeRegistry.JSON);){
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                geometry = this.parse((XContentParser)parser);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            return this.format(geometry, format);
        }
    }

    public static class Names {
        public static final ParseField IGNORE_MALFORMED = new ParseField("ignore_malformed", new String[0]);
        public static final ParseField IGNORE_Z_VALUE = new ParseField("ignore_z_value", new String[0]);
    }

    public static abstract class TypeParser<T extends Builder>
    implements Mapper.TypeParser {
        protected abstract T newBuilder(String var1, Map<String, Object> var2);

        public T parse(String name, Map<String, Object> node, Map<String, Object> params, Mapper.TypeParser.ParserContext parserContext) {
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (Names.IGNORE_MALFORMED.match(propName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                    params.put(Names.IGNORE_MALFORMED.getPreferredName(), XContentMapValues.nodeBooleanValue(propNode, name + ".ignore_malformed"));
                    iterator.remove();
                    continue;
                }
                if (!Names.IGNORE_Z_VALUE.getPreferredName().equals(propName)) continue;
                params.put(AbstractPointGeometryFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName(), XContentMapValues.nodeBooleanValue(propNode, name + "." + Names.IGNORE_Z_VALUE.getPreferredName()));
                iterator.remove();
            }
            T builder = this.newBuilder(name, params);
            if (params.containsKey(AbstractPointGeometryFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName())) {
                ((Builder)builder).ignoreZValue((Boolean)params.get(AbstractPointGeometryFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName()));
            }
            if (params.containsKey(Names.IGNORE_MALFORMED.getPreferredName())) {
                ((Builder)builder).ignoreMalformed((Boolean)params.get(Names.IGNORE_MALFORMED.getPreferredName()));
            }
            return builder;
        }

        public T parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            T builder = this.parse(name, node, new HashMap<String, Object>(), parserContext);
            TypeParsers.parseField(builder, name, node, parserContext);
            return builder;
        }
    }

    public static abstract class Builder<T extends Builder<T, FT>, FT extends AbstractGeometryFieldType>
    extends FieldMapper.Builder<T> {
        protected Boolean ignoreMalformed;
        protected Boolean ignoreZValue;
        protected boolean indexed = true;

        public Builder(String name, FieldType fieldType) {
            super(name, fieldType);
        }

        public Builder(String name, FieldType fieldType, boolean ignoreMalformed, boolean ignoreZValue) {
            super(name, fieldType);
            this.ignoreMalformed = ignoreMalformed;
            this.ignoreZValue = ignoreZValue;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return this;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit((Object)this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit((Object)FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public Explicit<Boolean> ignoreMalformed() {
            if (this.ignoreMalformed != null) {
                return new Explicit((Object)this.ignoreMalformed, true);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        protected Explicit<Boolean> ignoreZValue(Mapper.BuilderContext context) {
            if (this.ignoreZValue != null) {
                return new Explicit((Object)this.ignoreZValue, true);
            }
            return Defaults.IGNORE_Z_VALUE;
        }

        public Explicit<Boolean> ignoreZValue() {
            if (this.ignoreZValue != null) {
                return new Explicit((Object)this.ignoreZValue, true);
            }
            return Defaults.IGNORE_Z_VALUE;
        }

        public Builder ignoreZValue(boolean ignoreZValue) {
            this.ignoreZValue = ignoreZValue;
            return this;
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit((Object)false, false);
        public static final Explicit<Boolean> IGNORE_Z_VALUE = new Explicit((Object)true, false);
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

