/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.AsciiAction;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReceiveAsciiAction
extends AsciiAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private String receivedAsciiString;

    public ReceiveAsciiAction() {
    }

    public ReceiveAsciiAction(String asciiText, String encoding) {
        super(asciiText, encoding);
        this.receivedAsciiString = null;
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext tlsContext = state.getTlsContext();
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        try {
            LOGGER.debug("Receiving ASCII message...");
            byte[] fetchData = tlsContext.getTransportHandler().fetchData();
            this.receivedAsciiString = new String(fetchData, this.getEncoding());
            LOGGER.info("Received: " + this.receivedAsciiString);
            this.setExecuted(true);
        }
        catch (IOException E) {
            LOGGER.debug((Object)E);
            this.setExecuted(false);
        }
    }

    public String getReceivedAsciiString() {
        return this.receivedAsciiString;
    }

    @Override
    public void reset() {
        this.setExecuted(null);
    }

    @Override
    public boolean executedAsPlanned() {
        return Objects.equals(this.receivedAsciiString, this.getAsciiText());
    }
}

