/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.grouping.core;

import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.NodeException;
import com.projectlibre1.grouping.core.NodeVisitor;
import com.projectlibre1.grouping.core.transform.filtering.NodeFilter;
import com.projectlibre1.grouping.core.transform.filtering.NotVoidFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class NodeList
extends ArrayList {
    private Node getNode() throws NodeException {
        if (this.size() == 0) {
            throw new NodeException("Empty NodeList");
        }
        return (Node)this.get(0);
    }

    public Class getType() throws NodeException {
        return this.getNode().getClass();
    }

    public boolean isVirtual() {
        return true;
    }

    public void setVirtual(boolean bl) {
    }

    public static void accept(NodeVisitor nodeVisitor, Iterator iterator) {
        while (iterator.hasNext()) {
            ((Node)iterator.next()).accept(nodeVisitor);
        }
    }

    public void accept(NodeVisitor nodeVisitor) {
        NodeList.accept(nodeVisitor, this.iterator());
    }

    public Object getImpl() {
        return null;
    }

    public static List nodeListToImplList(Collection collection) {
        return NodeList.nodeListToImplList(collection, NotVoidFilter.getInstance());
    }

    public static List nodeListToImplList(Collection collection, NodeFilter nodeFilter) {
        if (collection == null) {
            return new ArrayList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        for (Node node : collection) {
            if (node.isVirtual() || nodeFilter != null && !nodeFilter.evaluate(node)) continue;
            arrayList.add(node.getImpl());
        }
        return arrayList;
    }
}

