/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * max(ivec2(-5, -2), -5) => ivec2(-5, -2)
 * max(ivec2(-1, 0), -5) => ivec2(-1, 0)
 * max(ivec2(1, 2), -5) => ivec2(1, 2)
 * max(ivec2(5, -5), -5) => ivec2(5, -5)
 * max(ivec2(-5, -2), -2) => ivec2(-2, -2)
 * max(ivec2(-1, 0), -2) => ivec2(-1, 0)
 * max(ivec2(1, 2), -2) => ivec2(1, 2)
 * max(ivec2(5, -5), -2) => ivec2(5, -2)
 * max(ivec2(-5, -2), -1) => ivec2(-1, -1)
 * max(ivec2(-1, 0), -1) => ivec2(-1, 0)
 * max(ivec2(1, 2), -1) => ivec2(1, 2)
 * max(ivec2(5, -5), -1) => ivec2(5, -1)
 * max(ivec2(-5, -2), 0) => ivec2(0, 0)
 * max(ivec2(-1, 0), 0) => ivec2(0, 0)
 * max(ivec2(1, 2), 0) => ivec2(1, 2)
 * max(ivec2(5, -5), 0) => ivec2(5, 0)
 * max(ivec2(-5, -2), 1) => ivec2(1, 1)
 * max(ivec2(-1, 0), 1) => ivec2(1, 1)
 * max(ivec2(1, 2), 1) => ivec2(1, 2)
 * max(ivec2(5, -5), 1) => ivec2(5, 1)
 * max(ivec2(-5, -2), 2) => ivec2(2, 2)
 * max(ivec2(-1, 0), 2) => ivec2(2, 2)
 * max(ivec2(1, 2), 2) => ivec2(2, 2)
 * max(ivec2(5, -5), 2) => ivec2(5, 2)
 * max(ivec2(-5, -2), 5) => ivec2(5, 5)
 * max(ivec2(-1, 0), 5) => ivec2(5, 5)
 * max(ivec2(1, 2), 5) => ivec2(5, 5)
 * max(ivec2(5, -5), 5) => ivec2(5, 5)
 */
#version 130

void main()
{
  float[all(equal(max(ivec2(-5, -2), -5), ivec2(-5, -2))) ? 1 : -1] array0;
  float[all(equal(max(ivec2(-1, 0), -5), ivec2(-1, 0))) ? 1 : -1] array1;
  float[all(equal(max(ivec2(1, 2), -5), ivec2(1, 2))) ? 1 : -1] array2;
  float[all(equal(max(ivec2(5, -5), -5), ivec2(5, -5))) ? 1 : -1] array3;
  float[all(equal(max(ivec2(-5, -2), -2), ivec2(-2, -2))) ? 1 : -1] array4;
  float[all(equal(max(ivec2(-1, 0), -2), ivec2(-1, 0))) ? 1 : -1] array5;
  float[all(equal(max(ivec2(1, 2), -2), ivec2(1, 2))) ? 1 : -1] array6;
  float[all(equal(max(ivec2(5, -5), -2), ivec2(5, -2))) ? 1 : -1] array7;
  float[all(equal(max(ivec2(-5, -2), -1), ivec2(-1, -1))) ? 1 : -1] array8;
  float[all(equal(max(ivec2(-1, 0), -1), ivec2(-1, 0))) ? 1 : -1] array9;
  float[all(equal(max(ivec2(1, 2), -1), ivec2(1, 2))) ? 1 : -1] array10;
  float[all(equal(max(ivec2(5, -5), -1), ivec2(5, -1))) ? 1 : -1] array11;
  float[all(equal(max(ivec2(-5, -2), 0), ivec2(0, 0))) ? 1 : -1] array12;
  float[all(equal(max(ivec2(-1, 0), 0), ivec2(0, 0))) ? 1 : -1] array13;
  float[all(equal(max(ivec2(1, 2), 0), ivec2(1, 2))) ? 1 : -1] array14;
  float[all(equal(max(ivec2(5, -5), 0), ivec2(5, 0))) ? 1 : -1] array15;
  float[all(equal(max(ivec2(-5, -2), 1), ivec2(1, 1))) ? 1 : -1] array16;
  float[all(equal(max(ivec2(-1, 0), 1), ivec2(1, 1))) ? 1 : -1] array17;
  float[all(equal(max(ivec2(1, 2), 1), ivec2(1, 2))) ? 1 : -1] array18;
  float[all(equal(max(ivec2(5, -5), 1), ivec2(5, 1))) ? 1 : -1] array19;
  float[all(equal(max(ivec2(-5, -2), 2), ivec2(2, 2))) ? 1 : -1] array20;
  float[all(equal(max(ivec2(-1, 0), 2), ivec2(2, 2))) ? 1 : -1] array21;
  float[all(equal(max(ivec2(1, 2), 2), ivec2(2, 2))) ? 1 : -1] array22;
  float[all(equal(max(ivec2(5, -5), 2), ivec2(5, 2))) ? 1 : -1] array23;
  float[all(equal(max(ivec2(-5, -2), 5), ivec2(5, 5))) ? 1 : -1] array24;
  float[all(equal(max(ivec2(-1, 0), 5), ivec2(5, 5))) ? 1 : -1] array25;
  float[all(equal(max(ivec2(1, 2), 5), ivec2(5, 5))) ? 1 : -1] array26;
  float[all(equal(max(ivec2(5, -5), 5), ivec2(5, 5))) ? 1 : -1] array27;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length() + array27.length());
}
