/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.impl.DispatchHandler;
import com.microsoft.azure.eventhubs.impl.ReactorDispatcher;
import com.microsoft.azure.eventhubs.impl.ReactorHandler;
import java.io.IOException;
import java.time.Duration;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.reactor.Reactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionHandler
extends BaseHandler {
    protected static final Logger TRACE_LOGGER = LoggerFactory.getLogger(SessionHandler.class);
    private final String entityName;
    private final Consumer<Session> onRemoteSessionOpen;
    private final BiConsumer<ErrorCondition, Exception> onRemoteSessionOpenError;
    private final Duration openTimeout;
    private final String connectionId;
    private boolean sessionCreated = false;
    private boolean sessionOpenErrorDispatched = false;

    public SessionHandler(String entityName, Consumer<Session> onRemoteSessionOpen, BiConsumer<ErrorCondition, Exception> onRemoteSessionOpenError, Duration openTimeout, String connectionId) {
        this.entityName = entityName;
        this.onRemoteSessionOpenError = onRemoteSessionOpenError;
        this.onRemoteSessionOpen = onRemoteSessionOpen;
        this.openTimeout = openTimeout;
        this.connectionId = connectionId;
    }

    public void onSessionLocalOpen(Event e) {
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onSessionLocalOpen connectionId[%s], entityName[%s], condition[%s]", this.connectionId, this.entityName, e.getSession().getCondition() == null ? "none" : e.getSession().getCondition().toString()));
        }
        if (this.onRemoteSessionOpenError != null) {
            ReactorHandler reactorHandler = null;
            Reactor reactor = e.getReactor();
            Iterator reactorEventHandlers = reactor.getHandler().children();
            while (reactorEventHandlers.hasNext()) {
                Handler currentHandler = (Handler)reactorEventHandlers.next();
                if (!(currentHandler instanceof ReactorHandler)) continue;
                reactorHandler = (ReactorHandler)currentHandler;
                break;
            }
            if (reactorHandler == null) {
                this.onRemoteSessionOpenError.accept(null, new EventHubException(false, String.format("OnSessionLocalOpen entityName[%s], reactorHandler: NULL POINTER exception.", this.entityName)));
                e.getSession().close();
                return;
            }
            ReactorDispatcher reactorDispatcher = reactorHandler.getReactorDispatcher();
            Session session = e.getSession();
            try {
                reactorDispatcher.invoke((int)this.openTimeout.toMillis(), new SessionTimeoutHandler(this.entityName, this.connectionId));
            }
            catch (IOException ioException) {
                if (TRACE_LOGGER.isWarnEnabled()) {
                    TRACE_LOGGER.warn(String.format(Locale.US, "onSessionLocalOpen connectionId[%s], entityName[%s], reactorDispatcherError[%s]", this.connectionId, this.entityName, ioException.getMessage()));
                }
                session.close();
                this.onRemoteSessionOpenError.accept(null, new EventHubException(false, String.format(Locale.US, "onSessionLocalOpen connectionId[%s], entityName[%s], underlying IO of reactorDispatcher faulted with error: %s", this.connectionId, this.entityName, ioException.getMessage()), ioException));
            }
        }
    }

    public void onSessionRemoteOpen(Event e) {
        Session session;
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onSessionRemoteOpen connectionId[%s], entityName[%s], sessionIncCapacity[%s], sessionOutgoingWindow[%s]", this.connectionId, this.entityName, e.getSession().getIncomingCapacity(), e.getSession().getOutgoingWindow()));
        }
        if ((session = e.getSession()) != null && session.getLocalState() == EndpointState.UNINITIALIZED) {
            session.open();
        }
        this.sessionCreated = true;
        if (this.onRemoteSessionOpen != null) {
            this.onRemoteSessionOpen.accept(session);
        }
    }

    public void onSessionLocalClose(Event e) {
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onSessionLocalClose connectionId[%s], entityName[%s], condition[%s]", this.entityName, this.connectionId, e.getSession().getCondition() == null ? "none" : e.getSession().getCondition().toString()));
        }
    }

    public void onSessionRemoteClose(Event e) {
        Session session;
        ErrorCondition condition;
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onSessionRemoteClose connectionId[%s], entityName[%s], condition[%s]", this.entityName, this.connectionId, e.getSession().getRemoteCondition() == null ? "none" : e.getSession().getRemoteCondition().toString()));
        }
        ErrorCondition errorCondition = condition = (session = e.getSession()) != null ? session.getRemoteCondition() : null;
        if (session != null && session.getLocalState() != EndpointState.CLOSED) {
            if (TRACE_LOGGER.isInfoEnabled()) {
                TRACE_LOGGER.info(String.format(Locale.US, "onSessionRemoteClose closing a local session for connectionId[%s], entityName[%s], condition[%s], description[%s]", this.connectionId, this.entityName, condition != null ? condition.getCondition() : "n/a", condition != null ? condition.getDescription() : "n/a"));
            }
            session.setCondition(session.getRemoteCondition());
            session.close();
        }
        this.sessionOpenErrorDispatched = true;
        if (!this.sessionCreated && this.onRemoteSessionOpenError != null) {
            this.onRemoteSessionOpenError.accept(condition, null);
        }
    }

    public void onSessionFinal(Event e) {
        if (TRACE_LOGGER.isInfoEnabled()) {
            Session session = e.getSession();
            ErrorCondition condition = session != null ? session.getCondition() : null;
            TRACE_LOGGER.info(String.format(Locale.US, "onSessionFinal connectionId[%s], entityName[%s], condition[%s], description[%s]", this.connectionId, this.entityName, condition != null ? condition.getCondition() : "n/a", condition != null ? condition.getDescription() : "n/a"));
        }
    }

    private class SessionTimeoutHandler
    extends DispatchHandler {
        private final String entityName;
        private final String connectionId;

        SessionTimeoutHandler(String entityName, String connectionId) {
            this.entityName = entityName;
            this.connectionId = connectionId;
        }

        @Override
        public void onEvent() {
            if (!SessionHandler.this.sessionCreated && !SessionHandler.this.sessionOpenErrorDispatched && TRACE_LOGGER.isWarnEnabled()) {
                TRACE_LOGGER.warn(String.format(Locale.US, "SessionTimeoutHandler.onEvent - connectionId[%s], entityName[%s], session open timed out.", this.connectionId, this.entityName));
            }
        }
    }
}

