/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnparsedText
extends UnparsedTextFunction {
    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        StringValue hrefVal = (StringValue)this.argument[0].evaluateItem(context);
        String encoding = this.getNumberOfArguments() == 2 ? this.argument[1].evaluateItem(context).getStringValue() : null;
        return this.evalUnparsedText(hrefVal, encoding, context);
    }

    @Override
    public ZeroOrOne<StringValue> call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue hrefVal = (StringValue)arguments[0].head();
        String encoding = this.getNumberOfArguments() == 2 ? arguments[1].head().getStringValue() : null;
        return new ZeroOrOne<StringValue>(this.evalUnparsedText(hrefVal, encoding, context));
    }

    public StringValue evalUnparsedText(StringValue hrefVal, String encoding, XPathContext context) throws XPathException {
        StringValue result;
        try {
            if (hrefVal == null) {
                return null;
            }
            String href = hrefVal.getStringValue();
            CharSequence content = this.readFile(href, this.expressionBaseURI, encoding, context);
            result = new StringValue(content);
        }
        catch (XPathException err) {
            err.maybeSetErrorCode(UnparsedText.getErrorCodePrefix(context) + "1170");
            throw err;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        FastStringBuffer sb1 = new FastStringBuffer(256);
        FastStringBuffer sb2 = new FastStringBuffer(256);
        File file = new File(args[0]);
        FileInputStream is = new FileInputStream(file);
        while (true) {
            int b;
            if ((b = ((InputStream)is).read()) < 0) break;
            sb1.append(Integer.toHexString(b) + " ");
            sb2.append((char)b + " ");
            if (sb1.length() <= 80) continue;
            System.out.println(sb1.toString());
            System.out.println(sb2.toString());
            sb1 = new FastStringBuffer(256);
            sb2 = new FastStringBuffer(256);
        }
        System.out.println(sb1.toString());
        System.out.println(sb2.toString());
        ((InputStream)is).close();
    }
}

