/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;

public final class Permissions {
    public static ResourcePermission permission(ResourceServer server, Resource resource, Scope scope) {
        return new ResourcePermission(resource, new ArrayList<Scope>(Arrays.asList(scope)), server);
    }

    public static void all(ResourceServer resourceServer, Identity identity, AuthorizationProvider authorization, AuthorizationRequest request, Consumer<ResourcePermission> evaluator) {
        List<PermissionTicket> tickets;
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        AuthorizationRequest.Metadata metadata = request.getMetadata();
        AtomicLong limit = metadata != null && metadata.getLimit() != null ? new AtomicLong(metadata.getLimit().intValue()) : new AtomicLong(Long.MAX_VALUE);
        resourceStore.findByOwner(resourceServer, resourceServer.getClientId(), resource -> {
            if (limit.decrementAndGet() >= 0L) {
                evaluator.accept(Permissions.createResourcePermissions(resource, resourceServer, resource.getScopes(), authorization, request));
            }
        });
        if (!Objects.equals(resourceServer.getClientId(), identity.getId())) {
            resourceStore.findByOwner(resourceServer, identity.getId(), resource -> {
                if (limit.decrementAndGet() >= 0L) {
                    evaluator.accept(Permissions.createResourcePermissions(resource, resourceServer, resource.getScopes(), authorization, request));
                }
            });
        }
        if (!(tickets = storeFactory.getPermissionTicketStore().findGranted(resourceServer, identity.getId())).isEmpty()) {
            HashMap<String, ResourcePermission> userManagedPermissions = new HashMap<String, ResourcePermission>();
            for (PermissionTicket ticket : tickets) {
                if (limit.get() < 0L) break;
                ResourcePermission permission = userManagedPermissions.computeIfAbsent(ticket.getResource().getId(), s -> {
                    limit.decrementAndGet();
                    ResourcePermission resourcePermission = new ResourcePermission(ticket.getResource(), new ArrayList<Scope>(), resourceServer, request.getClaims());
                    resourcePermission.setGranted(true);
                    return resourcePermission;
                });
                permission.addScope(ticket.getScope());
            }
            for (ResourcePermission permission : userManagedPermissions.values()) {
                evaluator.accept(permission);
            }
        }
    }

    public static ResourcePermission createResourcePermissions(Resource resource, ResourceServer resourceServer, Collection<Scope> requestedScopes, AuthorizationProvider authorization, AuthorizationRequest request) {
        Set<Scope> scopes = Permissions.resolveScopes(resource, resourceServer, requestedScopes, authorization);
        return new ResourcePermission(resource, scopes, resourceServer, request.getClaims());
    }

    public static ResourcePermission createResourcePermissions(String resourceType, Resource resource, ResourceServer resourceServer, Collection<Scope> requestedScopes, AuthorizationProvider authorization, AuthorizationRequest request) {
        Set<Scope> scopes = Permissions.resolveScopes(resource, resourceServer, requestedScopes, authorization);
        return new ResourcePermission(resourceType, resource, scopes, resourceServer, request.getClaims());
    }

    public static Set<Scope> resolveScopes(Resource resource, ResourceServer resourceServer, Collection<Scope> requestedScopes, AuthorizationProvider authorization) {
        if (requestedScopes.isEmpty()) {
            return Permissions.populateTypedScopes(resource, resourceServer, authorization);
        }
        return Permissions.populateTypedScopes(resource, resourceServer, resource.getScopes(), authorization).stream().filter(scope -> requestedScopes.contains(scope)).collect(Collectors.toSet());
    }

    private static Set<Scope> populateTypedScopes(Resource resource, ResourceServer resourceServer, AuthorizationProvider authorization) {
        return Permissions.populateTypedScopes(resource, resourceServer, resource.getScopes(), authorization);
    }

    private static Set<Scope> populateTypedScopes(Resource resource, ResourceServer resourceServer, List<Scope> defaultScopes, AuthorizationProvider authorization) {
        String type = resource.getType();
        if (type == null || resource.getOwner().equals(resourceServer.getId())) {
            return new LinkedHashSet<Scope>(defaultScopes);
        }
        LinkedHashSet<Scope> scopes = new LinkedHashSet<Scope>(defaultScopes);
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        resourceStore.findByType(resourceServer, type, resource1 -> {
            for (Scope typeScope : resource1.getScopes()) {
                if (scopes.contains(typeScope)) continue;
                scopes.add(typeScope);
            }
        });
        return scopes;
    }
}

