/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.InsnNode;
import org.jetbrains.annotations.NotNull;

public class FilledNewArrayNode
extends InsnNode {
    private final ArgType elemType;

    public FilledNewArrayNode(@NotNull ArgType elemType, int size) {
        super(InsnType.FILLED_NEW_ARRAY, size);
        this.elemType = elemType;
    }

    public ArgType getElemType() {
        return this.elemType;
    }

    public ArgType getArrayType() {
        return ArgType.array(this.elemType);
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilledNewArrayNode) || !super.isSame(obj)) {
            return false;
        }
        FilledNewArrayNode other = (FilledNewArrayNode)obj;
        return this.elemType == other.elemType;
    }

    @Override
    public InsnNode copy() {
        return this.copyCommonParams(new FilledNewArrayNode(this.elemType, this.getArgsCount()));
    }

    @Override
    public String toString() {
        return super.toString() + " elemType: " + this.elemType;
    }
}

