/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.actions.ImportProfilerResultAction;
import com.intellij.profiler.fileTypes.AbstractSnapshotFileType;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HprofFileType
extends AbstractSnapshotFileType {
    public static final HprofFileType INSTANCE = new HprofFileType();
    public static final String EXTENSION = "hprof";

    private HprofFileType() {
    }

    @NonNls
    @NotNull
    public String getName() {
        return "HPROF";
    }

    @NlsContexts.Label
    @NotNull
    public String getDescription() {
        String string = UltimateProfilerBundleKt.profilerMessage("filetype.hprof.dump.description", new Object[0]);
        if (string == null) {
            HprofFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = UltimateProfilerBundleKt.profilerMessage("filetype.hprof.dump.display.name", new Object[0]);
        if (string == null) {
            HprofFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getDefaultExtension() {
        return EXTENSION;
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Hprof;
    }

    public boolean openFileInAssociatedApplication(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            HprofFileType.$$$reportNull$$$0(2);
        }
        if (!this.checkBinaryHeader("JAVA PROFILE", file)) {
            return false;
        }
        ImportProfilerResultAction.Companion.importProfilerDumpAsAssociated(project, file.toNioPath().toFile());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profiler/ultimate/hprof/impl/HprofFileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profiler/ultimate/hprof/impl/HprofFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "openFileInAssociatedApplication";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

