/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.pos;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.pos.PositionAdjustments;
import org.jetbrains.letsPlot.core.plot.base.pos.StackablePos;
import org.jetbrains.letsPlot.core.plot.base.pos.StackingMode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/pos/FillPos;", "Lorg/jetbrains/letsPlot/core/plot/base/pos/StackablePos;", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "vjust", "", "stackingMode", "Lorg/jetbrains/letsPlot/core/plot/base/pos/StackingMode;", "(Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;Ljava/lang/Double;Lorg/jetbrains/letsPlot/core/plot/base/pos/StackingMode;)V", "myOffsetByIndex", "", "", "Lorg/jetbrains/letsPlot/core/plot/base/pos/StackablePos$StackOffset;", "handlesGroups", "", "translate", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "v", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "Companion", "plot-base"})
public final class FillPos
extends StackablePos {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Integer, StackablePos.StackOffset> myOffsetByIndex;
    private static final double DEF_VJUST = 1.0;

    public FillPos(@NotNull Aesthetics aes2, @Nullable Double vjust, @NotNull StackingMode stackingMode) {
        Intrinsics.checkNotNullParameter((Object)aes2, (String)"aes");
        Intrinsics.checkNotNullParameter((Object)((Object)stackingMode), (String)"stackingMode");
        Double d = vjust;
        this.myOffsetByIndex = this.mapIndexToOffset$plot_base(aes2, d != null ? d : 1.0, stackingMode);
    }

    @Override
    @NotNull
    public DoubleVector translate(@NotNull DoubleVector v, @NotNull DataPointAesthetics p, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        double stackHeight = ((StackablePos.StackOffset)MapsKt.getValue(this.myOffsetByIndex, (Object)p.index())).getMax();
        double scale = stackHeight == 0.0 ? 1.0 : 1.0 / stackHeight;
        return new DoubleVector(v.getX(), scale * (v.getY() + ((StackablePos.StackOffset)MapsKt.getValue(this.myOffsetByIndex, (Object)p.index())).getValue()));
    }

    @Override
    public boolean handlesGroups() {
        return PositionAdjustments.Meta.FILL.handlesGroups();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/pos/FillPos$Companion;", "", "()V", "DEF_VJUST", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

