/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers.diagnostics;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.diagnostics.AbstractTestDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.ActualDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.factories.DebugInfoDiagnosticFactory1;
import org.jetbrains.kotlin.checkers.utils.CheckerTestUtil;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.AbstractDiagnosticWithParametersRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParameters1Renderer;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 %2\u00020\u0001:\u0002$%B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0016J\u001a\u0010 \u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\u001d2\b\b\u0002\u0010\"\u001a\u00020\u001dJ\b\u0010#\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\f\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic;", "Lorg/jetbrains/kotlin/checkers/diagnostics/AbstractTestDiagnostic;", "name", "", "platform", "parameters", "", "inference", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;)V", "getName", "()Ljava/lang/String;", "getPlatform", "getParameters", "()Ljava/util/List;", "inferenceCompatibility", "getInferenceCompatibility", "()Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "setInferenceCompatibility", "(Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;)V", "description", "getDescription", "compareTo", "", "other", "enhanceInferenceCompatibility", "", "equals", "", "", "hashCode", "asString", "withNewInference", "renderParameters", "toString", "InferenceCompatibility", "Companion", "frontend"})
public final class TextDiagnostic
implements AbstractTestDiagnostic {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @Nullable
    private final String platform;
    @Nullable
    private final List<String> parameters;
    @NotNull
    private InferenceCompatibility inferenceCompatibility;
    private static final Pattern crossPlatformLineBreak = Pattern.compile("\\r?\\n");

    public TextDiagnostic(@NotNull String name2, @Nullable String platform, @Nullable List<String> parameters, @Nullable InferenceCompatibility inference) {
        Intrinsics.checkNotNullParameter(name2, "name");
        this.name = name2;
        this.platform = platform;
        this.parameters = parameters;
        InferenceCompatibility inferenceCompatibility = inference;
        if (inferenceCompatibility == null) {
            inferenceCompatibility = InferenceCompatibility.ALL;
        }
        this.inferenceCompatibility = inferenceCompatibility;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getPlatform() {
        return this.platform;
    }

    @Nullable
    public final List<String> getParameters() {
        return this.parameters;
    }

    @Override
    @NotNull
    public InferenceCompatibility getInferenceCompatibility() {
        return this.inferenceCompatibility;
    }

    public void setInferenceCompatibility(@NotNull InferenceCompatibility inferenceCompatibility) {
        Intrinsics.checkNotNullParameter((Object)inferenceCompatibility, "<set-?>");
        this.inferenceCompatibility = inferenceCompatibility;
    }

    @NotNull
    public final String getDescription() {
        return (this.getPlatform() != null ? this.getPlatform() + ':' : "") + this.getName();
    }

    @Override
    public int compareTo(@NotNull AbstractTestDiagnostic other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.getName().compareTo(other.getName());
    }

    @Override
    public void enhanceInferenceCompatibility(@NotNull InferenceCompatibility inferenceCompatibility) {
        Intrinsics.checkNotNullParameter((Object)inferenceCompatibility, "inferenceCompatibility");
        this.setInferenceCompatibility(inferenceCompatibility);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        TextDiagnostic that = (TextDiagnostic)other;
        if (!Intrinsics.areEqual(this.getName(), that.getName())) {
            return false;
        }
        boolean bl = this.getPlatform() != null ? !Intrinsics.areEqual(this.getPlatform(), that.getPlatform()) : that.getPlatform() != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.parameters != null ? !Intrinsics.areEqual(this.parameters, that.parameters) : that.parameters != null;
        if (bl2) {
            return false;
        }
        return this.getInferenceCompatibility() == that.getInferenceCompatibility();
    }

    public int hashCode() {
        int result2 = this.getName().hashCode();
        String string2 = this.getPlatform();
        result2 = 31 * result2 + (string2 != null ? string2.hashCode() : 0);
        List<String> list = this.parameters;
        result2 = 31 * result2 + (list != null ? ((Object)list).hashCode() : 0);
        result2 = 31 * result2 + this.getInferenceCompatibility().hashCode();
        return result2;
    }

    @NotNull
    public final String asString(boolean withNewInference, boolean renderParameters) {
        StringBuilder result2 = new StringBuilder();
        if (withNewInference && this.getInferenceCompatibility().getAbbreviation$frontend() != null) {
            result2.append(this.getInferenceCompatibility().getAbbreviation$frontend());
            result2.append(";");
        }
        if (this.getPlatform() != null) {
            result2.append(this.getPlatform());
            result2.append(":");
        }
        result2.append(this.getName());
        if (renderParameters && this.parameters != null) {
            result2.append("(");
            result2.append(StringUtil.join((Collection)this.parameters, arg_0 -> TextDiagnostic.asString$lambda$1(TextDiagnostic::asString$lambda$0, arg_0), ", "));
            result2.append(")");
        }
        String string2 = result2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    public static /* synthetic */ String asString$default(TextDiagnostic textDiagnostic, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return textDiagnostic.asString(bl, bl2);
    }

    @NotNull
    public String toString() {
        return TextDiagnostic.asString$default(this, false, false, 3, null);
    }

    private static final String asString$lambda$0(String it) {
        return '\"' + crossPlatformLineBreak.matcher(it).replaceAll(" ") + '\"';
    }

    private static final String asString$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$Companion;", "", "<init>", "()V", "crossPlatformLineBreak", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "parseDiagnostic", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic;", "text", "", "computeInferenceCompatibility", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "abbreviation", "extractDataBefore", "prefix", "anchor", "asTextDiagnostic", "abstractTestDiagnostic", "Lorg/jetbrains/kotlin/checkers/diagnostics/AbstractTestDiagnostic;", "actualDiagnostic", "Lorg/jetbrains/kotlin/checkers/diagnostics/ActualDiagnostic;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nTextDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextDiagnostic.kt\norg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n626#2,12:171\n1#3:183\n*S KotlinDebug\n*F\n+ 1 TextDiagnostic.kt\norg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$Companion\n*L\n126#1:171,12\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextDiagnostic parseDiagnostic(@NotNull String text) {
            Intrinsics.checkNotNullParameter(text, "text");
            Matcher matcher = CheckerTestUtil.INSTANCE.getIndividualDiagnosticPattern().matcher(text);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Could not parse diagnostic: " + text);
            }
            InferenceCompatibility inference = this.computeInferenceCompatibility(this.extractDataBefore(matcher.group(1), ";"));
            String platform = this.extractDataBefore(matcher.group(2), ":");
            String name2 = matcher.group(3);
            String string2 = matcher.group(5);
            if (string2 == null) {
                Intrinsics.checkNotNull(name2);
                return new TextDiagnostic(name2, platform, null, inference);
            }
            String parameters = string2;
            Intrinsics.checkNotNull(name2);
            Object object = new char[]{'\"'};
            object = StringsKt.trim(parameters, object);
            Regex regex = new Regex("\",\\s*\"");
            int n = 0;
            return new TextDiagnostic(name2, platform, regex.split((CharSequence)object, n), inference);
        }

        private final InferenceCompatibility computeInferenceCompatibility(String abbreviation) {
            InferenceCompatibility inferenceCompatibility;
            if (abbreviation == null) {
                inferenceCompatibility = InferenceCompatibility.ALL;
            } else {
                Iterable $this$single$iv = InferenceCompatibility.getEntries();
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    InferenceCompatibility inference = (InferenceCompatibility)((Object)element$iv);
                    boolean bl = false;
                    if (!Intrinsics.areEqual(abbreviation, inference.getAbbreviation$frontend())) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                inferenceCompatibility = single$iv;
            }
            return inferenceCompatibility;
        }

        private final String extractDataBefore(String prefix, String anchor) {
            boolean bl;
            boolean bl2 = bl = prefix == null || StringsKt.endsWith$default(prefix, anchor, false, 2, null);
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = prefix;
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = string2;
                throw new AssertionError((Object)string3);
            }
            String string4 = prefix;
            return string4 != null ? StringsKt.substringBeforeLast(string4, anchor, prefix) : null;
        }

        @NotNull
        public final TextDiagnostic asTextDiagnostic(@NotNull AbstractTestDiagnostic abstractTestDiagnostic) {
            Intrinsics.checkNotNullParameter(abstractTestDiagnostic, "abstractTestDiagnostic");
            return abstractTestDiagnostic instanceof ActualDiagnostic ? this.asTextDiagnostic((ActualDiagnostic)abstractTestDiagnostic) : (TextDiagnostic)abstractTestDiagnostic;
        }

        private final TextDiagnostic asTextDiagnostic(ActualDiagnostic actualDiagnostic) {
            Diagnostic diagnostic = actualDiagnostic.getDiagnostic();
            DiagnosticRenderer renderer = diagnostic.getFactory() instanceof DebugInfoDiagnosticFactory1 ? (DiagnosticRenderer)new DiagnosticWithParameters1Renderer("{0}", (DiagnosticParameterRenderer)Renderers.TO_STRING) : DefaultErrorMessages.getRendererForDiagnostic(diagnostic);
            String diagnosticName = actualDiagnostic.getName();
            if (renderer instanceof AbstractDiagnosticWithParametersRenderer) {
                Object[] renderParameters = ((AbstractDiagnosticWithParametersRenderer)renderer).renderParameters((UnboundDiagnostic)diagnostic);
                List<String> list = ContainerUtil.map(renderParameters, Companion::asTextDiagnostic$lambda$2);
                Intrinsics.checkNotNullExpressionValue(list, "map(...)");
                List<String> parameters = list;
                return new TextDiagnostic(diagnosticName, actualDiagnostic.getPlatform(), parameters, actualDiagnostic.getInferenceCompatibility());
            }
            return new TextDiagnostic(diagnosticName, actualDiagnostic.getPlatform(), null, actualDiagnostic.getInferenceCompatibility());
        }

        private static final String asTextDiagnostic$lambda$2(Object it) {
            return String.valueOf(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0013\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "", "abbreviation", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getAbbreviation$frontend", "()Ljava/lang/String;", "setAbbreviation$frontend", "(Ljava/lang/String;)V", "NEW", "OLD", "ALL", "isCompatible", "", "other", "frontend"})
    public static final class InferenceCompatibility
    extends Enum<InferenceCompatibility> {
        @Nullable
        private String abbreviation;
        public static final /* enum */ InferenceCompatibility NEW = new InferenceCompatibility("NI");
        public static final /* enum */ InferenceCompatibility OLD = new InferenceCompatibility("OI");
        public static final /* enum */ InferenceCompatibility ALL = new InferenceCompatibility(null);
        private static final /* synthetic */ InferenceCompatibility[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private InferenceCompatibility(String abbreviation) {
            this.abbreviation = abbreviation;
        }

        @Nullable
        public final String getAbbreviation$frontend() {
            return this.abbreviation;
        }

        public final void setAbbreviation$frontend(@Nullable String string2) {
            this.abbreviation = string2;
        }

        public final boolean isCompatible(@NotNull InferenceCompatibility other) {
            Intrinsics.checkNotNullParameter((Object)other, "other");
            return this == other || this == ALL || other == ALL;
        }

        public static InferenceCompatibility[] values() {
            return (InferenceCompatibility[])$VALUES.clone();
        }

        public static InferenceCompatibility valueOf(String value2) {
            return Enum.valueOf(InferenceCompatibility.class, value2);
        }

        @NotNull
        public static EnumEntries<InferenceCompatibility> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = inferenceCompatibilityArray = new InferenceCompatibility[]{InferenceCompatibility.NEW, InferenceCompatibility.OLD, InferenceCompatibility.ALL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

