/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public final class BaseScriptTransformationSupport
implements AstTransformationSupport {
    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        GrTypeDefinition grTypeDefinition;
        if (context == null) {
            BaseScriptTransformationSupport.$$$reportNull$$$0(0);
        }
        if (!((grTypeDefinition = context.getCodeClass()) instanceof GroovyScriptClass)) {
            return;
        }
        GroovyScriptClass scriptClass = (GroovyScriptClass)grTypeDefinition;
        LightMethodBuilder mainMethod = new LightMethodBuilder(scriptClass.getManager(), (Language)GroovyLanguage.INSTANCE, "main").setMethodReturnType((PsiType)PsiTypes.voidType()).addParameter("args", (PsiType)new PsiArrayType((PsiType)PsiType.getJavaLangString((PsiManager)scriptClass.getManager(), (GlobalSearchScope)scriptClass.getResolveScope()))).addModifiers(new String[]{"public", "static"});
        LightMethodBuilder runMethod = new LightMethodBuilder(scriptClass.getManager(), (Language)GroovyLanguage.INSTANCE, "run").setMethodReturnType((PsiType)TypesUtil.getJavaLangObject(scriptClass)).addModifier("public");
        context.addMethod((PsiMethod)runMethod, true);
        context.addMethod((PsiMethod)mainMethod, true);
        context.setSuperType(BaseScriptTransformationSupport.getBaseClassType(scriptClass));
    }

    @NotNull
    private static PsiClassType getBaseClassType(@NotNull GroovyScriptClass scriptClass) {
        PsiClassType type;
        if (scriptClass == null) {
            BaseScriptTransformationSupport.$$$reportNull$$$0(1);
        }
        if ((type = (PsiClassType)CachedValuesManager.getCachedValue((PsiElement)scriptClass, () -> CachedValueProvider.Result.create((Object)BaseScriptTransformationSupport.getSuperClassTypeFromBaseScriptAnnotation(scriptClass), (Object[])new Object[]{scriptClass.getContainingFile()}))) != null) {
            PsiClass resolved = type.resolve();
            if (resolved instanceof GrTypeDefinition && BaseScriptTransformationSupport.reachableInHierarchy(new HashSet<PsiClass>(List.of(scriptClass)), (GrTypeDefinition)resolved)) {
                PsiClassType psiClassType = TypesUtil.createTypeByFQClassName("groovy.lang.Script", scriptClass);
                if (psiClassType == null) {
                    BaseScriptTransformationSupport.$$$reportNull$$$0(2);
                }
                return psiClassType;
            }
            PsiClassType psiClassType = type;
            if (psiClassType == null) {
                BaseScriptTransformationSupport.$$$reportNull$$$0(3);
            }
            return psiClassType;
        }
        PsiClassType superClassFromDSL = GroovyDslFileIndex.processScriptSuperClasses(scriptClass.getContainingFile());
        if (superClassFromDSL != null) {
            PsiClassType psiClassType = superClassFromDSL;
            if (psiClassType == null) {
                BaseScriptTransformationSupport.$$$reportNull$$$0(4);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = TypesUtil.createTypeByFQClassName("groovy.lang.Script", scriptClass);
        if (psiClassType == null) {
            BaseScriptTransformationSupport.$$$reportNull$$$0(5);
        }
        return psiClassType;
    }

    private static boolean reachableInHierarchy(Set<PsiClass> forbidden, GrTypeDefinition root) {
        for (PsiClass aSuper : root.getSupers(false)) {
            if (forbidden.contains(aSuper)) {
                return true;
            }
            forbidden.add(aSuper);
            if (!(aSuper instanceof GrTypeDefinition) || !BaseScriptTransformationSupport.reachableInHierarchy(forbidden, (GrTypeDefinition)aSuper)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiClassType getSuperClassTypeFromBaseScriptAnnotation(@NotNull GroovyScriptClass scriptClass) {
        PsiClassType fromVariable;
        if (scriptClass == null) {
            BaseScriptTransformationSupport.$$$reportNull$$$0(6);
        }
        if ((fromVariable = BaseScriptTransformationSupport.getSuperClassTypeFromBaseScriptAnnotatedVariable(scriptClass)) != null) {
            return fromVariable;
        }
        PsiClassType fromImport = BaseScriptTransformationSupport.getSuperClassTypeFromBaseScriptAnnotatedImportDefinition(scriptClass);
        if (fromImport != null) {
            return fromImport;
        }
        return BaseScriptTransformationSupport.getSuperClassTypeFromBaseScriptAnnotatedPackageDefinition(scriptClass);
    }

    @Nullable
    private static PsiClassType getSuperClassTypeFromBaseScriptAnnotatedImportDefinition(@NotNull GroovyScriptClass scriptClass) {
        GrImportStatement[] importStatements;
        if (scriptClass == null) {
            BaseScriptTransformationSupport.$$$reportNull$$$0(7);
        }
        for (GrImportStatement importStatement : importStatements = scriptClass.getContainingFile().getImportStatements()) {
            PsiClassType superClassType;
            GrModifierList annotations = importStatement.getAnnotationList();
            PsiAnnotation baseScriptAnnotation = annotations.findAnnotation("groovy.transform.BaseScript");
            if (baseScriptAnnotation == null || (superClassType = BaseScriptTransformationSupport.getSuperClassTypeFromAnnotationValue(scriptClass, baseScriptAnnotation)) == null) continue;
            return superClassType;
        }
        return null;
    }

    @Nullable
    private static PsiClassType getSuperClassTypeFromBaseScriptAnnotatedPackageDefinition(@NotNull GroovyScriptClass scriptClass) {
        GrPackageDefinition packageDefinition;
        if (scriptClass == null) {
            BaseScriptTransformationSupport.$$$reportNull$$$0(8);
        }
        if ((packageDefinition = scriptClass.getContainingFile().getPackageDefinition()) == null) {
            return null;
        }
        PsiModifierList modifierList = packageDefinition.getModifierList();
        if (modifierList == null) {
            return null;
        }
        PsiAnnotation baseScriptAnnotation = modifierList.findAnnotation("groovy.transform.BaseScript");
        if (baseScriptAnnotation == null) {
            return null;
        }
        return BaseScriptTransformationSupport.getSuperClassTypeFromAnnotationValue(scriptClass, baseScriptAnnotation);
    }

    @Nullable
    private static PsiClassType getSuperClassTypeFromAnnotationValue(GroovyScriptClass scriptClass, PsiAnnotation baseScriptAnnotation) {
        PsiClass clazz = GrAnnotationUtil.getPsiClass(GrAnnotationUtilKt.findDeclaredDetachedValue(baseScriptAnnotation, "value"));
        if (clazz != null) {
            String className = clazz.getQualifiedName();
            if (className == null) {
                clazz.getName();
            }
            if (className != null) {
                return TypesUtil.createTypeByFQClassName(className, scriptClass);
            }
        }
        return null;
    }

    @Nullable
    private static PsiClassType getSuperClassTypeFromBaseScriptAnnotatedVariable(GroovyScriptClass scriptClass) {
        PsiType type;
        GrTypeElement typeElement;
        GrVariableDeclaration declaration = BaseScriptTransformationSupport.findDeclaration(scriptClass.getContainingFile());
        if (declaration != null && (typeElement = declaration.getTypeElementGroovy()) != null && (type = typeElement.getType()) instanceof PsiClassType) {
            return (PsiClassType)type;
        }
        return null;
    }

    @Nullable
    private static GrVariableDeclaration findDeclaration(GroovyFile file) {
        if (!PsiSearchHelper.getInstance((Project)file.getProject()).hasIdentifierInFile((PsiFile)file, "BaseScript")) {
            return null;
        }
        for (GrVariableDeclaration declaration : file.getScriptDeclarations(false)) {
            if (!declaration.getModifierList().hasAnnotation("groovy.transform.BaseScript")) continue;
            return declaration;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/transformations/impl/BaseScriptTransformationSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/transformations/impl/BaseScriptTransformationSupport";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseClassType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyTransformation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBaseClassType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassTypeFromBaseScriptAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassTypeFromBaseScriptAnnotatedImportDefinition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassTypeFromBaseScriptAnnotatedPackageDefinition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

