"""Generated client library for cloudapiregistry version v1alpha."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.cloudapiregistry.v1alpha import cloudapiregistry_v1alpha_messages as messages


class CloudapiregistryV1alpha(base_api.BaseApiClient):
  """Generated client library for service cloudapiregistry version v1alpha."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://cloudapiregistry.googleapis.com/'
  MTLS_BASE_URL = 'https://cloudapiregistry.mtls.googleapis.com/'

  _PACKAGE = 'cloudapiregistry'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'CloudapiregistryV1alpha'
  _URL_VERSION = 'v1alpha'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new cloudapiregistry handle."""
    url = url or self.BASE_URL
    super(CloudapiregistryV1alpha, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_mcpServers_mcpTools = self.ProjectsLocationsMcpServersMcpToolsService(self)
    self.projects_locations_mcpServers = self.ProjectsLocationsMcpServersService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsMcpServersMcpToolsService(base_api.BaseApiService):
    """Service class for the projects_locations_mcpServers_mcpTools resource."""

    _NAME = 'projects_locations_mcpServers_mcpTools'

    def __init__(self, client):
      super(CloudapiregistryV1alpha.ProjectsLocationsMcpServersMcpToolsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets a single McpTool.

      Args:
        request: (CloudapiregistryProjectsLocationsMcpServersMcpToolsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (McpTool) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/mcpServers/{mcpServersId}/mcpTools/{mcpToolsId}',
        http_method='GET',
        method_id='cloudapiregistry.projects.locations.mcpServers.mcpTools.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudapiregistryProjectsLocationsMcpServersMcpToolsGetRequest',
        response_type_name='McpTool',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists McpTools in a given McpServer.

      Args:
        request: (CloudapiregistryProjectsLocationsMcpServersMcpToolsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMcpToolsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/mcpServers/{mcpServersId}/mcpTools',
        http_method='GET',
        method_id='cloudapiregistry.projects.locations.mcpServers.mcpTools.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/mcpTools',
        request_field='',
        request_type_name='CloudapiregistryProjectsLocationsMcpServersMcpToolsListRequest',
        response_type_name='ListMcpToolsResponse',
        supports_download=False,
    )

  class ProjectsLocationsMcpServersService(base_api.BaseApiService):
    """Service class for the projects_locations_mcpServers resource."""

    _NAME = 'projects_locations_mcpServers'

    def __init__(self, client):
      super(CloudapiregistryV1alpha.ProjectsLocationsMcpServersService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets a single McpServer.

      Args:
        request: (CloudapiregistryProjectsLocationsMcpServersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (McpServer) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/mcpServers/{mcpServersId}',
        http_method='GET',
        method_id='cloudapiregistry.projects.locations.mcpServers.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudapiregistryProjectsLocationsMcpServersGetRequest',
        response_type_name='McpServer',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists McpServers in a given Project.

      Args:
        request: (CloudapiregistryProjectsLocationsMcpServersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMcpServersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/mcpServers',
        http_method='GET',
        method_id='cloudapiregistry.projects.locations.mcpServers.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/mcpServers',
        request_field='',
        request_type_name='CloudapiregistryProjectsLocationsMcpServersListRequest',
        response_type_name='ListMcpServersResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(CloudapiregistryV1alpha.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (CloudapiregistryProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='cloudapiregistry.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudapiregistryProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service. This method can be called in two ways: * **List all public locations:** Use the path `GET /v1/locations`. * **List project-visible locations:** Use the path `GET /v1/projects/{project_id}/locations`. This may include public locations as well as private or other locations specifically visible to the project.

      Args:
        request: (CloudapiregistryProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations',
        http_method='GET',
        method_id='cloudapiregistry.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['extraLocationTypes', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}/locations',
        request_field='',
        request_type_name='CloudapiregistryProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(CloudapiregistryV1alpha.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
