/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.DatabaseListChangeEvent;
import ca.sqlpower.sql.DatabaseListChangeListener;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sql.Olap4jDataSource;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLTypePhysicalProperties;
import ca.sqlpower.sqlobject.SQLTypePhysicalPropertiesProvider;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import com.google.common.collect.ArrayListMultimap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.log4j.Logger;

public class PlDotIni
implements DataSourceCollection<SPDataSource> {
    private boolean dontAutoSave;
    List<DatabaseListChangeListener> listeners;
    private final List<UndoableEditListener> undoListeners = new ArrayList<UndoableEditListener>();
    DatabaseListChangeListener saver = new DatabaseListChangeListener(){

        @Override
        public void databaseAdded(DatabaseListChangeEvent e) {
            this.saveIfFileKnown();
        }

        @Override
        public void databaseRemoved(DatabaseListChangeEvent e) {
            this.saveIfFileKnown();
        }

        private void saveIfFileKnown() {
            if (PlDotIni.this.dontAutoSave) {
                return;
            }
            if (PlDotIni.this.lastFileAccessed != null) {
                try {
                    PlDotIni.this.write(PlDotIni.this.lastFileAccessed);
                }
                catch (IOException e) {
                    logger.error((Object)"Error auto-saving PL.INI file", (Throwable)e);
                }
            }
        }
    };
    private final URI mondrianServerBaseURI;
    private static final Logger logger = Logger.getLogger(PlDotIni.class);
    private static final String unknownTypeUUID = "Unknown_UserDefinedSQLType";
    private final List<Object> fileSections = new ArrayList<Object>();
    private long fileTime;
    private URI serverBaseURI;
    boolean shuttingDown = false;
    int WAIT_TIME = 30;
    Thread monitor = new Thread(){

        @Override
        public void run() {
            while (!PlDotIni.this.shuttingDown) {
                try {
                    long newFileTime;
                    Thread.sleep(PlDotIni.this.WAIT_TIME * 1000);
                    if (PlDotIni.this.lastFileAccessed == null || (newFileTime = PlDotIni.this.lastFileAccessed.lastModified()) == PlDotIni.this.fileTime) continue;
                    logger.debug((Object)"Re-reading PL.INI file because it has been modified externally.");
                    PlDotIni.this.read(PlDotIni.this.lastFileAccessed);
                    PlDotIni.this.fileTime = newFileTime;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    };
    File lastFileAccessed;

    public PlDotIni() {
        this(null);
    }

    public PlDotIni(URI serverBaseURI) {
        this(serverBaseURI, null);
    }

    public PlDotIni(URI serverBaseURI, URI mondrianServerBaseURI) {
        this.listeners = new ArrayList<DatabaseListChangeListener>();
        this.listeners.add(this.saver);
        this.serverBaseURI = serverBaseURI;
        this.mondrianServerBaseURI = mondrianServerBaseURI;
    }

    Object getSection(int number) {
        return this.fileSections.get(number);
    }

    int getSectionCount() {
        return this.fileSections.size();
    }

    @Override
    public void read(File location) throws IOException {
        if (!location.canRead()) {
            throw new IOException("pl.ini file is not readable: " + location.getAbsolutePath());
        }
        this.fileTime = location.lastModified();
        this.lastFileAccessed = location;
        this.read(new FileInputStream(location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(InputStream inStream) throws IOException {
        if (inStream == null) {
            throw new NullPointerException("InputStream was null!");
        }
        logger.info((Object)"Beginning to read/merge new pl.ini data");
        ReadState mode = ReadState.READ_GENERIC;
        try {
            this.dontAutoSave = true;
            JDBCDataSourceType currentType = null;
            SPDataSource currentDS = null;
            UserDefinedSQLType currentSQLType = null;
            Section currentSection = new Section(null);
            ArrayListMultimap typePropertiesMap = ArrayListMultimap.create();
            BufferedInputStream in = new BufferedInputStream(inStream);
            byte[] lineBytes = null;
            while ((lineBytes = this.readLine(in)) != null) {
                String value;
                String key;
                String line = new String(lineBytes);
                line = this.convertOldLines(line);
                logger.debug((Object)("Read in new line: " + line));
                if (line.startsWith("[")) {
                    this.mergeFileData(mode, currentType, currentDS, currentSQLType, currentSection);
                }
                if (line.startsWith("[Databases_")) {
                    logger.debug((Object)("It's a new database connection spec!" + this.fileSections));
                    currentDS = new JDBCDataSource((DataSourceCollection)this);
                    mode = ReadState.READ_DS;
                    continue;
                }
                if (line.startsWith("[OLAP_databases_")) {
                    logger.debug((Object)("It's a new database connection spec!" + this.fileSections));
                    currentDS = new Olap4jDataSource(this);
                    mode = ReadState.READ_DS;
                    continue;
                }
                if (line.startsWith("[Database Types_")) {
                    logger.debug((Object)("It's a new database type!" + this.fileSections));
                    currentType = new JDBCDataSourceType(this.getServerBaseURI());
                    mode = ReadState.READ_TYPE;
                    continue;
                }
                if (line.startsWith("[Data Types_")) {
                    logger.debug((Object)("It's a new data type!" + this.fileSections));
                    currentSQLType = new UserDefinedSQLType();
                    String platform = "GENERIC";
                    currentSQLType.setConstraintType(platform, SQLTypePhysicalProperties.SQLTypeConstraint.NONE);
                    currentSQLType.setDefaultValue(platform, "");
                    currentSQLType.setPrecision(platform, 0);
                    currentSQLType.setScale(platform, 0);
                    currentSQLType.setMyAutoIncrement(false);
                    currentSQLType.setMyNullability(0);
                    mode = ReadState.READ_SQLTYPE;
                    continue;
                }
                if (line.startsWith("[")) {
                    logger.debug((Object)"It's a new generic section!");
                    currentSection = new Section(line.substring(1, line.length() - 1));
                    mode = ReadState.READ_GENERIC;
                    continue;
                }
                int equalsIdx = line.indexOf(61);
                if (equalsIdx > 0) {
                    key = line.substring(0, equalsIdx);
                    value = line.substring(equalsIdx + 1, line.length());
                } else {
                    key = line;
                    value = null;
                }
                logger.debug((Object)("key=" + key + ",val=" + value));
                if (mode == ReadState.READ_DS) {
                    if (key.equals("PWD") && value != null) {
                        byte[] cypherBytes = new byte[lineBytes.length - equalsIdx - 1];
                        System.arraycopy(lineBytes, equalsIdx + 1, cypherBytes, 0, cypherBytes.length);
                        value = PlDotIni.decryptPassword(9, cypherBytes);
                    }
                    currentDS.put(key, value);
                    continue;
                }
                if (mode == ReadState.READ_TYPE) {
                    if (key.matches("ca.sqlpower.sqlobject.SQLTypePhysicalProperties_\\d+")) {
                        String[] values = value.split(",");
                        String typeUUID = values[0];
                        SQLTypePhysicalProperties props = new SQLTypePhysicalProperties(currentType.getName());
                        props.setName(values[1]);
                        props.setPrecisionType(SQLTypePhysicalPropertiesProvider.PropertyType.valueOf(values[2]));
                        props.setScaleType(SQLTypePhysicalPropertiesProvider.PropertyType.valueOf(values[3]));
                        typePropertiesMap.put((Object)typeUUID, (Object)props);
                        continue;
                    }
                    currentType.putProperty(key, value);
                    continue;
                }
                if (mode == ReadState.READ_GENERIC) {
                    currentSection.put(key, value);
                    continue;
                }
                if (mode != ReadState.READ_SQLTYPE) continue;
                this.putPropertyIntoSQLType(currentSQLType, key, value);
            }
            in.close();
            this.mergeFileData(mode, currentType, currentDS, currentSQLType, currentSection);
            for (Object o : this.fileSections) {
                UserDefinedSQLType type;
                Collection typeProperties;
                if (o instanceof JDBCDataSourceType) {
                    JDBCDataSourceType dst = (JDBCDataSourceType)o;
                    String parentTypeName = dst.getProperty("Parent Type");
                    if (parentTypeName == null) continue;
                    JDBCDataSourceType parentType = this.getDataSourceType(parentTypeName);
                    if (parentType == null) {
                        throw new IllegalStateException("Database type \"" + dst.getName() + "\" refers to parent type \"" + parentTypeName + "\", which doesn't exist");
                    }
                    dst.setParentType(parentType);
                    continue;
                }
                if (o instanceof JDBCDataSource) {
                    JDBCDataSource ds = (JDBCDataSource)o;
                    String typeName = ds.getPropertiesMap().get("Connection Type");
                    if (typeName == null) continue;
                    JDBCDataSourceType type2 = this.getDataSourceType(typeName);
                    if (type2 == null) {
                        logger.error((Object)("Database connection \"" + ds.getName() + "\" refers to database type \"" + typeName + "\", which doesn't exist"));
                        continue;
                    }
                    logger.debug((Object)("The data source type \"" + type2 + "\" is being set as the parent type of" + ds));
                    ds.setParentType(type2);
                    continue;
                }
                if (!(o instanceof UserDefinedSQLType) || (typeProperties = typePropertiesMap.get((Object)(type = (UserDefinedSQLType)o).getUUID())) == null) continue;
                for (SQLTypePhysicalProperties properties : typeProperties) {
                    type.putPhysicalProperties(properties.getPlatform(), properties);
                }
            }
        }
        finally {
            this.dontAutoSave = false;
        }
        logger.info((Object)"Finished reading file.");
    }

    private String convertOldLines(String line) {
        if (line.contains("ca.sqlpower.architect.SQLIndex")) {
            return line.replace("ca.sqlpower.architect.SQLIndex", SQLIndex.class.getName());
        }
        return line;
    }

    private void mergeFileData(ReadState mode, JDBCDataSourceType currentType, SPDataSource currentDS, UserDefinedSQLType currentSQLType, Section currentSection) {
        if (mode == ReadState.READ_DS) {
            this.mergeDataSource(currentDS);
        } else if (mode == ReadState.READ_GENERIC) {
            this.mergeSection(currentSection);
        } else if (mode == ReadState.READ_SQLTYPE) {
            this.mergeSQLType(currentSQLType);
        } else if (mode == ReadState.READ_TYPE) {
            if (currentType.getProperties().size() > 0) {
                this.mergeDataSourceType(currentType);
            }
        } else {
            throw new IllegalArgumentException("Unknown read state. Can't merge");
        }
    }

    private void mergeSection(Section currentSection) {
        logger.debug((Object)("Attempting to merge Section: \"" + currentSection.getName() + "\""));
        for (Object o : this.fileSections) {
            Section s;
            if (!(o instanceof Section) || ((s = (Section)o).getName() != null || currentSection.getName() != null) && (s.getName() == null || !s.getName().equals(currentSection.getName()))) continue;
            logger.debug((Object)"Found a section to merge, now merging");
            s.merge(currentSection);
            return;
        }
        logger.debug((Object)"Didn't find section to merge. Adding...");
        this.fileSections.add(currentSection);
    }

    private byte[] readLine(BufferedInputStream in) throws IOException {
        int ch;
        int MAX_LINE_LENGTH = 10000;
        byte[] buffer = new byte[10000];
        int lineSize = 0;
        while ((ch = in.read()) != -1 && lineSize < 10000) {
            buffer[lineSize] = (byte)ch;
            if (++lineSize < 2 || buffer[lineSize - 2] != 13 || buffer[lineSize - 1] != 10) continue;
            lineSize -= 2;
            break;
        }
        if (ch == -1 && lineSize == 0) {
            return null;
        }
        if (lineSize == 10000) {
            logger.error((Object)"Maximum line size exceeded while reading pl.ini.  Line will be split up.");
        }
        byte[] chopBuffer = new byte[lineSize];
        System.arraycopy(buffer, 0, chopBuffer, 0, lineSize);
        return chopBuffer;
    }

    @Override
    public void write() throws IOException {
        if (this.lastFileAccessed == null) {
            throw new IllegalStateException("Can't determine location for saving");
        }
        this.write(this.lastFileAccessed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File location) throws IOException {
        logger.debug((Object)("Writing to " + location));
        try {
            this.dontAutoSave = true;
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(location));
            this.write(out);
            ((OutputStream)out).close();
            this.lastFileAccessed = location;
            this.fileTime = location.lastModified();
        }
        finally {
            this.dontAutoSave = false;
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        int dbNum = 1;
        int typeNum = 1;
        int olapNum = 1;
        int sqltypeNum = 1;
        for (Object next : this.fileSections) {
            if (next instanceof Section) {
                this.writeSection(out, ((Section)next).getName(), ((Section)next).getPropertiesMap());
                continue;
            }
            if (next instanceof JDBCDataSource) {
                this.writeSection(out, "Databases_" + dbNum, ((JDBCDataSource)next).getPropertiesMap());
                ++dbNum;
                continue;
            }
            if (next instanceof JDBCDataSourceType) {
                List<SQLTypePhysicalProperties> properties = this.getPropertiesForDataSourceType((JDBCDataSourceType)next);
                LinkedHashMap<String, String> propMap = new LinkedHashMap<String, String>(((JDBCDataSourceType)next).getProperties());
                for (int i = 0; i < properties.size(); ++i) {
                    SQLTypePhysicalProperties typeProp = properties.get(i);
                    StringBuilder value = new StringBuilder();
                    value.append(typeProp.getParent().getUUID()).append(",");
                    value.append(typeProp.getName()).append(",");
                    value.append((Object)typeProp.getPrecisionType()).append(",");
                    value.append((Object)typeProp.getScaleType());
                    propMap.put("ca.sqlpower.sqlobject.SQLTypePhysicalProperties_" + i, value.toString());
                }
                this.writeSection(out, "Database Types_" + typeNum, propMap);
                ++typeNum;
                continue;
            }
            if (next instanceof Olap4jDataSource) {
                this.writeSection(out, "OLAP_databases_" + olapNum, ((Olap4jDataSource)next).getPropertiesMap());
                ++olapNum;
                continue;
            }
            if (next instanceof UserDefinedSQLType) {
                Map<String, String> typeProperties = this.getPropertiesFromSQLType((UserDefinedSQLType)next);
                this.writeSection(out, "Data Types_" + sqltypeNum, typeProperties);
                ++sqltypeNum;
                continue;
            }
            if (next == null) {
                logger.error((Object)"write: Null section");
                continue;
            }
            logger.error((Object)("write: Unknown section type: " + next.getClass().getName()));
        }
    }

    private List<SQLTypePhysicalProperties> getPropertiesForDataSourceType(JDBCDataSourceType ds) {
        ArrayList<SQLTypePhysicalProperties> propertiesList = new ArrayList<SQLTypePhysicalProperties>();
        for (Object o : this.fileSections) {
            UserDefinedSQLType type;
            SQLTypePhysicalProperties properties;
            if (!(o instanceof UserDefinedSQLType) || (properties = (type = (UserDefinedSQLType)o).getPhysicalProperties(ds.getName())) == null || !properties.getPlatform().equals(ds.getName())) continue;
            propertiesList.add(properties);
        }
        return propertiesList;
    }

    Map<String, String> createSQLTypePropertiesMap(UserDefinedSQLType next) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("Name", next.getName());
        properties.put("Basic Type", next.getBasicType().toString());
        properties.put("Description", next.getDescription());
        properties.put("JDBC Type", String.valueOf(next.getType()));
        return Collections.unmodifiableMap(properties);
    }

    private void putPropertyIntoSQLType(UserDefinedSQLType sqlType, String key, String value) {
        String platform = "GENERIC";
        if (key.equals("Name")) {
            sqlType.setName(value);
            sqlType.setPhysicalTypeName(platform, value);
        } else if (key.equals("Basic Type")) {
            sqlType.setBasicType(SQLTypePhysicalPropertiesProvider.BasicSQLType.valueOf(value));
        } else if (key.equals("Description")) {
            sqlType.setMyDescription(value);
        } else if (key.equals("JDBC Type")) {
            sqlType.setType(Integer.valueOf(value));
        } else if (key.equals("Precision Type")) {
            sqlType.setPrecisionType(platform, SQLTypePhysicalPropertiesProvider.PropertyType.valueOf(value));
        } else if (key.equals("Scale Type")) {
            sqlType.setScaleType(platform, SQLTypePhysicalPropertiesProvider.PropertyType.valueOf(value));
        } else if (key.equals("UUID")) {
            sqlType.setUUID(value);
        }
    }

    private Map<String, String> getPropertiesFromSQLType(UserDefinedSQLType sqlType) {
        String platform = "GENERIC";
        LinkedHashMap<String, String> typeProperties = new LinkedHashMap<String, String>();
        typeProperties.put("Name", sqlType.getName());
        typeProperties.put("UUID", sqlType.getUUID());
        typeProperties.put("Basic Type", sqlType.getBasicType().toString());
        typeProperties.put("Description", sqlType.getDescription());
        typeProperties.put("Precision Type", sqlType.getPrecisionType(platform).toString());
        typeProperties.put("Scale Type", sqlType.getScaleType(platform).toString());
        typeProperties.put("JDBC Type", sqlType.getType().toString());
        return typeProperties;
    }

    private void writeSection(OutputStream out, String name, Map<String, String> properties) throws IOException {
        if (name != null) {
            String sectionHeading = "[" + name + "]" + "\r\n";
            out.write(sectionHeading.getBytes());
        }
        String s = null;
        s = properties.get("Logical");
        if (s != null) {
            out.write("Logical".getBytes());
            out.write("=".getBytes());
            out.write(s.getBytes());
            out.write("\r\n".getBytes());
        }
        for (Map.Entry<String, String> ent : properties.entrySet()) {
            if (ent.getKey().equals("Logical")) continue;
            out.write(ent.getKey().getBytes());
            if (ent.getValue() != null) {
                byte[] val = ent.getKey().equals("PWD") ? this.encryptPassword(9, ent.getValue()) : ent.getValue().getBytes();
                out.write("=".getBytes());
                out.write(val);
            }
            out.write("\r\n".getBytes());
        }
    }

    @Override
    public SPDataSource getDataSource(String name) {
        return this.getDataSource(name, SPDataSource.class);
    }

    @Override
    public <C extends SPDataSource> C getDataSource(String name, Class<C> classType) {
        for (Object next : this.fileSections) {
            if (!classType.isInstance(next)) continue;
            SPDataSource ds = (SPDataSource)classType.cast(next);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checking if data source " + ds + " is PL Logical connection " + name));
            }
            if (!ds.getName().equals(name)) continue;
            return (C)ds;
        }
        return null;
    }

    public JDBCDataSourceType getDataSourceType(String name) {
        for (Object next : this.fileSections) {
            if (!(next instanceof JDBCDataSourceType)) continue;
            JDBCDataSourceType dst = (JDBCDataSourceType)next;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checking if data source type " + dst + " is called " + name));
            }
            if (!dst.getName().equals(name)) continue;
            return dst;
        }
        return null;
    }

    @Override
    public List<JDBCDataSourceType> getDataSourceTypes() {
        ArrayList<JDBCDataSourceType> list = new ArrayList<JDBCDataSourceType>();
        for (Object next : this.fileSections) {
            if (!(next instanceof JDBCDataSourceType)) continue;
            JDBCDataSourceType dst = (JDBCDataSourceType)next;
            list.add(dst);
        }
        return list;
    }

    @Override
    public List<SPDataSource> getConnections() {
        return this.getConnections(SPDataSource.class);
    }

    @Override
    public <C extends SPDataSource> List<C> getConnections(Class<C> classType) {
        ArrayList<C> connections = new ArrayList<C>();
        for (Object next : this.fileSections) {
            if (!classType.isInstance(next)) continue;
            connections.add(classType.cast(next));
        }
        Collections.sort(connections);
        return connections;
    }

    @Override
    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.write(out);
        }
        catch (IOException e) {
            return "PlDotIni: toString: Couldn't create string description: " + e.getMessage();
        }
        return ((Object)out).toString();
    }

    private byte[] encryptPassword(int key, String plaintext) {
        byte[] cyphertext = new byte[plaintext.length()];
        for (int i = 0; i < plaintext.length(); ++i) {
            int temp = plaintext.charAt(i);
            temp = i % 2 == 1 ? (temp -= key) : (temp += key);
            cyphertext[i] = (byte)(temp ^= 10 - key);
        }
        if (logger.isDebugEnabled()) {
            StringBuffer nums = new StringBuffer();
            for (int i = 0; i < cyphertext.length; ++i) {
                nums.append(cyphertext[i]);
                nums.append(' ');
            }
            logger.debug((Object)("Encrypt: Plaintext: \"" + plaintext + "\"; cyphertext=(" + nums + ")"));
        }
        return cyphertext;
    }

    public static String decryptPassword(int number, byte[] cyphertext) {
        StringBuffer plaintext = new StringBuffer(cyphertext.length);
        int n = cyphertext.length;
        for (int i = 0; i < n; ++i) {
            int temp = cyphertext[i] & 0xFF ^ 10 - number;
            temp = i % 2 == 1 ? (temp += number) : (temp -= number);
            plaintext.append((char)temp);
        }
        if (logger.isDebugEnabled()) {
            StringBuffer nums = new StringBuffer();
            for (int i = 0; i < cyphertext.length; ++i) {
                nums.append(cyphertext[i]);
                nums.append(' ');
            }
            logger.debug((Object)("Decrypt: cyphertext=(" + nums + "); Plaintext: \"" + plaintext + "\""));
        }
        return plaintext.toString();
    }

    @Override
    public void addDataSource(SPDataSource dbcs) {
        String newName = dbcs.getDisplayName();
        for (Object o : this.fileSections) {
            SPDataSource oneDbcs;
            if (!(o instanceof SPDataSource) || !newName.equalsIgnoreCase((oneDbcs = (SPDataSource)o).getDisplayName())) continue;
            throw new IllegalArgumentException("There is already a datasource with the name " + newName);
        }
        this.addDataSourceImpl(dbcs);
    }

    @Override
    public void mergeDataSource(SPDataSource dbcs) {
        String newName = dbcs.getDisplayName();
        for (Object o : this.fileSections) {
            SPDataSource oneDbcs;
            if (!(o instanceof SPDataSource) || !newName.equalsIgnoreCase((oneDbcs = (SPDataSource)o).getDisplayName())) continue;
            for (Map.Entry<String, String> ent : dbcs.getPropertiesMap().entrySet()) {
                oneDbcs.put(ent.getKey(), ent.getValue());
            }
            return;
        }
        this.addDataSourceImpl(dbcs);
    }

    @Override
    public void removeDataSource(SPDataSource dbcs) {
        for (int where = 0; where < this.fileSections.size(); ++where) {
            SPDataSource current;
            Object o = this.fileSections.get(where);
            if (!(o instanceof SPDataSource) || !(current = (SPDataSource)o).getName().equals(dbcs.getName())) continue;
            this.fileSections.remove(where);
            this.fireRemoveEvent(where, dbcs);
            return;
        }
        throw new IllegalArgumentException("dbcs not in list");
    }

    @Override
    public void mergeDataSourceType(JDBCDataSourceType dst) {
        logger.debug((Object)("Merging data source type " + dst.getName()));
        String newName = dst.getName();
        if (newName == null) {
            throw new IllegalArgumentException("Can't merge a nameless data source type: " + dst);
        }
        for (Object o : this.fileSections) {
            JDBCDataSourceType current;
            if (!(o instanceof JDBCDataSourceType) || !newName.equalsIgnoreCase((current = (JDBCDataSourceType)o).getName())) continue;
            logger.debug((Object)"    Found it");
            for (Map.Entry<String, String> ent : dst.getProperties().entrySet()) {
                current.putProperty(ent.getKey(), ent.getValue());
            }
            return;
        }
        logger.debug((Object)"    Not found.. adding");
        this.addDataSourceType(dst);
    }

    private void addDataSourceImpl(SPDataSource dbcs) {
        this.fileSections.add(dbcs);
        this.fireAddEvent(dbcs);
    }

    @Override
    public void addDataSourceType(JDBCDataSourceType dataSourceType) {
        this.fileSections.add(dataSourceType);
        for (int i = this.undoListeners.size() - 1; i >= 0; --i) {
            this.undoListeners.get(i).undoableEditHappened(new UndoableEditEvent(this, new AddDSTypeUndoableEdit(dataSourceType)));
        }
    }

    @Override
    public boolean removeDataSourceType(JDBCDataSourceType dataSourceType) {
        for (int i = this.undoListeners.size() - 1; i >= 0; --i) {
            this.undoListeners.get(i).undoableEditHappened(new UndoableEditEvent(this, new RemoveDSTypeUndoableEdit(dataSourceType)));
        }
        return this.fileSections.remove(dataSourceType);
    }

    public void mergeSQLType(UserDefinedSQLType sqlType) {
        String name = sqlType.getName();
        for (Object o : this.fileSections) {
            UserDefinedSQLType existingType;
            if (!(o instanceof UserDefinedSQLType) || !(existingType = (UserDefinedSQLType)o).getName().equals(name)) continue;
            for (Map.Entry<String, String> entry : this.createSQLTypePropertiesMap(sqlType).entrySet()) {
                this.putPropertyIntoSQLType(existingType, entry.getKey(), entry.getValue());
            }
            return;
        }
        this.addSQLType(sqlType);
    }

    private void addSQLType(UserDefinedSQLType sqlType) {
        this.fileSections.add(sqlType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAddEvent(SPDataSource dbcs) {
        int index = this.fileSections.size() - 1;
        DatabaseListChangeEvent e = new DatabaseListChangeEvent(this, index, dbcs);
        List<DatabaseListChangeListener> list = this.listeners;
        synchronized (list) {
            for (DatabaseListChangeListener listener : this.listeners) {
                listener.databaseAdded(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveEvent(int i, SPDataSource dbcs) {
        DatabaseListChangeEvent e = new DatabaseListChangeEvent(this, i, dbcs);
        List<DatabaseListChangeListener> list = this.listeners;
        synchronized (list) {
            for (DatabaseListChangeListener listener : this.listeners) {
                listener.databaseRemoved(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDatabaseListChangeListener(DatabaseListChangeListener l) {
        List<DatabaseListChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDatabaseListChangeListener(DatabaseListChangeListener l) {
        List<DatabaseListChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener l) {
        this.undoListeners.add(l);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener l) {
        this.undoListeners.remove(l);
    }

    @Override
    public URI getServerBaseURI() {
        return this.serverBaseURI;
    }

    @Override
    public URI getMondrianServerBaseURI() {
        return this.mondrianServerBaseURI;
    }

    @Override
    public UserDefinedSQLType getSQLType(String name) {
        for (Object o : this.fileSections) {
            if (!(o instanceof UserDefinedSQLType) || !((UserDefinedSQLType)o).getName().equals(name)) continue;
            return (UserDefinedSQLType)o;
        }
        return null;
    }

    @Override
    public List<UserDefinedSQLType> getSQLTypes() {
        ArrayList<UserDefinedSQLType> list = new ArrayList<UserDefinedSQLType>();
        for (Object o : this.fileSections) {
            if (!(o instanceof UserDefinedSQLType)) continue;
            list.add((UserDefinedSQLType)o);
        }
        return list;
    }

    @Override
    public UserDefinedSQLType getNewSQLType(String name, int jdbcCode) {
        for (UserDefinedSQLType type : this.getSQLTypes()) {
            if (!type.getUUID().equals(unknownTypeUUID)) continue;
            return type;
        }
        throw new IllegalStateException("The Unknown Datatype has been removed");
    }

    private static enum ReadState {
        READ_DS,
        READ_GENERIC,
        READ_TYPE,
        READ_SQLTYPE;

    }

    static class Section {
        private String name;
        private Map<String, String> properties;

        public Section(String name) {
            this.name = name;
            this.properties = new LinkedHashMap<String, String>();
        }

        public Object put(String key, String value) {
            return this.properties.put(key, value);
        }

        public Map<String, String> getPropertiesMap() {
            return this.properties;
        }

        public String getName() {
            return this.name;
        }

        public void merge(Section s) {
            this.properties.keySet().retainAll(s.properties.keySet());
            this.properties.putAll(s.properties);
        }
    }

    public class RemoveDSTypeUndoableEdit
    extends AbstractUndoableEdit {
        private final JDBCDataSourceType type;

        public RemoveDSTypeUndoableEdit(JDBCDataSourceType type) {
            this.type = type;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            PlDotIni.this.fileSections.remove(this.type);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            PlDotIni.this.fileSections.add(this.type);
        }

        public JDBCDataSourceType getType() {
            return this.type;
        }
    }

    public class AddDSTypeUndoableEdit
    extends AbstractUndoableEdit {
        private final JDBCDataSourceType type;

        public AddDSTypeUndoableEdit(JDBCDataSourceType type) {
            this.type = type;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            PlDotIni.this.fileSections.add(this.type);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            PlDotIni.this.fileSections.remove(this.type);
        }

        public JDBCDataSourceType getType() {
            return this.type;
        }
    }
}

