/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.SAXException;

public class TransformerHandlerImpl
extends ReceivingContentHandler
implements TransformerHandler {
    Controller controller;
    Builder builder;
    Receiver receiver;
    Result result;
    String systemId;
    boolean started = false;

    protected TransformerHandlerImpl(Controller controller) {
        int val;
        this.controller = controller;
        Configuration config = controller.getConfiguration();
        int validation = config.getSchemaValidationMode();
        this.builder = controller.makeBuilder();
        this.setPipelineConfiguration(this.builder.getPipelineConfiguration());
        this.receiver = controller.makeStripper(this.builder);
        if (controller.getExecutable().stripsInputTypeAnnotations()) {
            this.receiver = controller.getConfiguration().getAnnotationStripper(this.receiver);
        }
        if ((val = validation & 0xFF) != 3) {
            this.receiver = config.getDocumentValidator(this.receiver, this.getSystemId(), val, 0, null, -1);
        }
        this.setReceiver(this.receiver);
    }

    public void startDocument() throws SAXException {
        if (this.started) {
            throw new UnsupportedOperationException("The TransformerHandler is not serially reusable. The startDocument() method must be called once only.");
        }
        this.started = true;
        super.startDocument();
    }

    public Transformer getTransformer() {
        return this.controller;
    }

    public void setSystemId(String url) {
        this.systemId = url;
        this.receiver.setSystemId(url);
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setResult(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result must not be null");
        }
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        DocumentInfo doc = (DocumentInfo)this.builder.getCurrentRoot();
        this.builder.reset();
        if (doc == null) {
            throw new SAXException("No source document has been built");
        }
        try {
            this.controller.transformDocument(doc, this.result);
        }
        catch (TransformerException err) {
            if (err instanceof XPathException) {
                this.controller.reportFatalError((XPathException)err);
            }
            throw new SAXException(err);
        }
    }
}

