/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;

public class HuabaoFrameDecoder
extends BaseFrameDecoder {
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        if (buf.readableBytes() < 2) {
            return null;
        }
        if (buf.getByte(buf.readerIndex()) == 40) {
            int index = buf.indexOf(buf.readerIndex() + 1, buf.writerIndex(), (byte)41);
            if (index >= 0) {
                return buf.readRetainedSlice(index + 1);
            }
        } else {
            short delimiter = buf.getUnsignedByte(buf.readerIndex());
            boolean alternative = delimiter == 231;
            int index = buf.indexOf(buf.readerIndex() + 1, buf.writerIndex(), (byte)delimiter);
            if (index >= 0) {
                ByteBuf result = Unpooled.buffer((int)(index + 1 - buf.readerIndex()));
                while (buf.readerIndex() <= index) {
                    short ext;
                    short b = buf.readUnsignedByte();
                    if (alternative && (b == 230 || b == 62)) {
                        ext = buf.readUnsignedByte();
                        if (b == 230 && ext == 1) {
                            result.writeByte(230);
                            continue;
                        }
                        if (b == 230 && ext == 2) {
                            result.writeByte(231);
                            continue;
                        }
                        if (b == 62 && ext == 1) {
                            result.writeByte(62);
                            continue;
                        }
                        if (b != 62 || ext != 2) continue;
                        result.writeByte(61);
                        continue;
                    }
                    if (!alternative && b == 125) {
                        ext = buf.readUnsignedByte();
                        if (ext == 1) {
                            result.writeByte(125);
                            continue;
                        }
                        if (ext != 2) continue;
                        result.writeByte(126);
                        continue;
                    }
                    result.writeByte((int)b);
                }
                return result;
            }
        }
        return null;
    }
}

