/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import com.google.common.collect.Sets;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ClientCertificateType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.CertificateRequestParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.CertificateRequestPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.CertificateRequestSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateRequestHandler
extends HandshakeMessageHandler<CertificateRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CertificateRequestHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public CertificateRequestParser getParser(byte[] message, int pointer) {
        return new CertificateRequestParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), this.tlsContext.getConfig());
    }

    public CertificateRequestPreparator getPreparator(CertificateRequestMessage message) {
        return new CertificateRequestPreparator(this.tlsContext.getChooser(), message);
    }

    public CertificateRequestSerializer getSerializer(CertificateRequestMessage message) {
        return new CertificateRequestSerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(CertificateRequestMessage message) {
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().isTLS13()) {
            this.adjustCertifiateRequestContext(message);
            this.adjustServerSupportedSignatureAndHashAlgorithms(message);
        } else {
            this.adjustClientCertificateTypes(message);
            this.adjustDistinguishedNames(message);
            if (this.tlsContext.getChooser().getSelectedProtocolVersion() == ProtocolVersion.TLS12 || this.tlsContext.getChooser().getSelectedProtocolVersion() == ProtocolVersion.DTLS12) {
                this.adjustServerSupportedSignatureAndHashAlgorithms(message);
            }
        }
    }

    private void adjustServerSupportedSignatureAndHashAlgorithms(CertificateRequestMessage message) {
        List<SignatureAndHashAlgorithm> algoList = this.convertSignatureAndHashAlgorithms((byte[])message.getSignatureHashAlgorithms().getValue());
        this.tlsContext.setServerSupportedSignatureAndHashAlgorithms(algoList);
        LOGGER.debug("Set ServerSupportedSignatureAndHashAlgortihms to " + algoList.toString());
    }

    private void adjustDistinguishedNames(CertificateRequestMessage message) {
        if (message.getDistinguishedNames() != null && message.getDistinguishedNames().getValue() != null) {
            byte[] distinguishedNames = (byte[])message.getDistinguishedNames().getValue();
            this.tlsContext.setDistinguishedNames(distinguishedNames);
            LOGGER.debug("Set DistinguishedNames in Context to " + ArrayConverter.bytesToHexString((byte[])distinguishedNames, (boolean)false));
        } else {
            LOGGER.debug("Not adjusting DistinguishedNames");
        }
    }

    private void adjustClientCertificateTypes(CertificateRequestMessage message) {
        List<ClientCertificateType> clientCertTypes = this.convertClientCertificateTypes((byte[])message.getClientCertificateTypes().getValue());
        this.tlsContext.setClientCertificateTypes(clientCertTypes);
        LOGGER.debug("Set ClientCertificateType in Context to " + clientCertTypes.toString());
    }

    private List<ClientCertificateType> convertClientCertificateTypes(byte[] bytesToConvert) {
        LinkedList<ClientCertificateType> list = new LinkedList<ClientCertificateType>();
        for (byte b : bytesToConvert) {
            ClientCertificateType type = ClientCertificateType.getClientCertificateType(b);
            if (type == null) {
                LOGGER.warn("Cannot convert:" + b + " to a ClientCertificateType");
                continue;
            }
            list.add(type);
        }
        return list;
    }

    private List<SignatureAndHashAlgorithm> convertSignatureAndHashAlgorithms(byte[] bytesToConvert) {
        if (bytesToConvert.length % 2 != 0) {
            LOGGER.warn("Cannot convert:" + ArrayConverter.bytesToHexString((byte[])bytesToConvert, (boolean)false) + " to a List<SignatureAndHashAlgorithm>");
            return new LinkedList<SignatureAndHashAlgorithm>();
        }
        LinkedList<SignatureAndHashAlgorithm> list = new LinkedList<SignatureAndHashAlgorithm>();
        for (int i = 0; i < bytesToConvert.length; i += 2) {
            byte[] copied = new byte[]{bytesToConvert[i], bytesToConvert[i + 1]};
            SignatureAndHashAlgorithm algo = SignatureAndHashAlgorithm.getSignatureAndHashAlgorithm(copied);
            list.add(algo);
        }
        return list;
    }

    private void adjustSelectedSignatureAndHashAlgorithm() {
        if (Collections.disjoint(this.tlsContext.getChooser().getClientSupportedSignatureAndHashAlgorithms(), this.tlsContext.getChooser().getServerSupportedSignatureAndHashAlgorithms())) {
            LOGGER.warn("Client and Server have no signature and hash algorithm in common");
        } else {
            Sets.SetView intersection = Sets.intersection((Set)Sets.newHashSet(this.tlsContext.getChooser().getClientSupportedSignatureAndHashAlgorithms()), (Set)Sets.newHashSet(this.tlsContext.getChooser().getServerSupportedSignatureAndHashAlgorithms()));
            SignatureAndHashAlgorithm algo = (SignatureAndHashAlgorithm)((Object)intersection.toArray()[0]);
            this.tlsContext.setSelectedSignatureAndHashAlgorithm(algo);
            LOGGER.debug("Adjusting selected signature and hash algorithm to: " + algo.name());
        }
    }

    private void adjustCertifiateRequestContext(CertificateRequestMessage msg) {
        this.tlsContext.setCertificateRequestContext((byte[])msg.getCertificateRequestContext().getValue());
    }
}

