/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.nio;

import ca.odell.glazedlists.impl.nio.NIOAttachment;
import ca.odell.glazedlists.impl.nio.NIODaemon;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class SelectAndHandle
implements Runnable {
    private static Logger logger = Logger.getLogger(SelectAndHandle.class.toString());
    private NIODaemon nioDaemon = null;

    public SelectAndHandle(NIODaemon nioDaemon) {
        this.nioDaemon = nioDaemon;
    }

    public void run() {
        this.select();
        this.handle();
    }

    void select() {
        try {
            this.nioDaemon.getSelector().select();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    void handle() {
        Iterator<SelectionKey> i = this.nioDaemon.getSelector().selectedKeys().iterator();
        while (i.hasNext()) {
            NIOAttachment attachment;
            SelectionKey key = i.next();
            i.remove();
            if (key.isValid() && key.isAcceptable()) {
                this.nioDaemon.getServer().handleAccept(key, this.nioDaemon.getSelector());
            }
            if (key.isValid() && key.isConnectable()) {
                attachment = (NIOAttachment)key.attachment();
                attachment.handleConnect();
            }
            if (key.isValid() && key.isReadable()) {
                attachment = (NIOAttachment)key.attachment();
                attachment.handleRead();
            }
            if (key.isValid() && key.isWritable()) {
                attachment = (NIOAttachment)key.attachment();
                attachment.handleWrite();
            }
            if (key.isValid()) continue;
            attachment = (NIOAttachment)key.attachment();
            attachment.close(new IOException("Connection closed"));
        }
    }
}

