/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.text.DecimalFormat;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.fasttrack.UnexpectedStructureException;

final class FastTrackUtility {
    private static final long NULL_DOUBLE = 4128101167230658355L;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    FastTrackUtility() {
    }

    public static final void validateSize(int n) {
        if (n < 0 || n > 100000) {
            throw new UnexpectedStructureException();
        }
    }

    public static final void validateOffset(byte[] byArray, int n) {
        if (n >= byArray.length) {
            throw new UnexpectedStructureException();
        }
    }

    public static final int getInt(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = n;
        for (int i = 0; i < 32; i += 8) {
            n2 |= (byArray[n3] & 0xFF) << i;
            ++n3;
        }
        return n2;
    }

    public static final int getShort(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = n;
        for (int i = 0; i < 16; i += 8) {
            n2 |= (byArray[n3] & 0xFF) << i;
            ++n3;
        }
        return n2;
    }

    public static final long getLong(byte[] byArray, int n) {
        if (byArray.length != 8) {
            throw new UnexpectedStructureException();
        }
        long l = 0L;
        int n2 = n;
        for (int i = 0; i < 64; i += 8) {
            l |= (long)(byArray[n2] & 0xFF) << i;
            ++n2;
        }
        return l;
    }

    public static final Double getDouble(byte[] byArray, int n) {
        double d;
        Double d2 = null;
        long l = FastTrackUtility.getLong(byArray, n);
        if (l != 4128101167230658355L && !Double.isNaN(d = Double.longBitsToDouble(l))) {
            d2 = d;
        }
        return d2;
    }

    public static final int getByte(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        return n2;
    }

    public static final TimeUnit getTimeUnit(int n) {
        TimeUnit timeUnit = null;
        switch (n) {
            case 1: {
                timeUnit = TimeUnit.ELAPSED_DAYS;
                break;
            }
            case 2: {
                timeUnit = TimeUnit.HOURS;
                break;
            }
            case 4: {
                timeUnit = TimeUnit.DAYS;
                break;
            }
            case 6: {
                timeUnit = TimeUnit.WEEKS;
                break;
            }
            case 8: 
            case 10: {
                timeUnit = TimeUnit.MONTHS;
                break;
            }
            case 12: {
                timeUnit = TimeUnit.YEARS;
                break;
            }
        }
        return timeUnit;
    }

    public static int skipToNextMatchingShort(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (FastTrackUtility.getShort(byArray, n3) != n2) {
            ++n3;
        }
        return n3 += 2;
    }

    public static final String hexdump(byte[] byArray, int n, int n2, boolean bl, int n3, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (byArray != null) {
            DecimalFormat decimalFormat = new DecimalFormat("00000");
            for (int i = n; i < n + n2; i += n3) {
                if (i + n3 > n + n2) {
                    n3 = n + n2 - i;
                }
                stringBuilder.append(string);
                stringBuilder.append(decimalFormat.format(i - n));
                stringBuilder.append(":");
                stringBuilder.append(FastTrackUtility.hexdump(byArray, i, n3, bl));
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public static final String hexdump(byte[] byArray, int n, int n2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (byArray != null) {
            int n3;
            int n4 = n + n2;
            for (n3 = n; n3 < n4; ++n3) {
                stringBuilder.append(" ");
                stringBuilder.append(HEX_DIGITS[(byArray[n3] & 0xF0) >> 4]);
                stringBuilder.append(HEX_DIGITS[byArray[n3] & 0xF]);
            }
            if (bl) {
                stringBuilder.append("   ");
                for (n3 = n; n3 < n4; ++n3) {
                    char c = (char)byArray[n3];
                    if (c > '\u00c8' || c < '\u001b') {
                        c = ' ';
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

