/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.util.LoaderUtils;

public class ProjectHelperRepository {
    private static final String DEBUG_PROJECT_HELPER_REPOSITORY = "ant.project-helper-repo.debug";
    private static final boolean DEBUG = "true".equals(System.getProperty("ant.project-helper-repo.debug"));
    private static ProjectHelperRepository instance = new ProjectHelperRepository();
    private List helpers = new ArrayList();
    private static final Class[] NO_CLASS = new Class[0];
    private static final Object[] NO_OBJECT = new Object[0];

    public static ProjectHelperRepository getInstance() {
        return instance;
    }

    private ProjectHelperRepository() {
        this.collectProjectHelpers();
    }

    private void collectProjectHelpers() {
        ProjectHelper projectHelper;
        block5: {
            projectHelper = this.getProjectHelperBySystemProperty();
            this.registerProjectHelper(projectHelper);
            try {
                InputStream systemResource;
                ClassLoader classLoader = LoaderUtils.getContextClassLoader();
                if (classLoader != null) {
                    Enumeration<URL> resources = classLoader.getResources("META-INF/services/org.apache.tools.ant.ProjectHelper");
                    while (resources.hasMoreElements()) {
                        URL resource = resources.nextElement();
                        projectHelper = this.getProjectHelperByService(resource.openStream());
                        this.registerProjectHelper(projectHelper);
                    }
                }
                if ((systemResource = ClassLoader.getSystemResourceAsStream("META-INF/services/org.apache.tools.ant.ProjectHelper")) != null) {
                    projectHelper = this.getProjectHelperByService(systemResource);
                    this.registerProjectHelper(projectHelper);
                }
            }
            catch (Exception e) {
                System.err.println("Unable to load ProjectHelper from service META-INF/services/org.apache.tools.ant.ProjectHelper (" + e.getClass().getName() + ": " + e.getMessage() + ")");
                if (!DEBUG) break block5;
                e.printStackTrace(System.err);
            }
        }
        projectHelper = new ProjectHelper2();
        this.registerProjectHelper(projectHelper);
    }

    private void registerProjectHelper(ProjectHelper projectHelper) {
        if (projectHelper == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("ProjectHelper " + projectHelper.getClass().getName() + " registered.");
        }
        try {
            this.helpers.add(projectHelper.getClass().getConstructor(NO_CLASS));
        }
        catch (NoSuchMethodException nse) {
            throw new BuildException("Couldn't find no-arg constructor in " + projectHelper.getClass().getName());
        }
    }

    private ProjectHelper getProjectHelperBySystemProperty() {
        block3: {
            String helperClass = System.getProperty("org.apache.tools.ant.ProjectHelper");
            try {
                if (helperClass != null) {
                    return this.newHelper(helperClass);
                }
            }
            catch (SecurityException e) {
                System.err.println("Unable to load ProjectHelper class \"" + helperClass + " specified in system property " + "org.apache.tools.ant.ProjectHelper" + " (" + e.getMessage() + ")");
                if (!DEBUG) break block3;
                e.printStackTrace(System.err);
            }
        }
        return null;
    }

    private ProjectHelper getProjectHelperByService(InputStream is) {
        block5: {
            try {
                InputStreamReader isr;
                try {
                    isr = new InputStreamReader(is, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    isr = new InputStreamReader(is);
                }
                BufferedReader rd = new BufferedReader(isr);
                String helperClassName = rd.readLine();
                rd.close();
                if (helperClassName != null && !"".equals(helperClassName)) {
                    return this.newHelper(helperClassName);
                }
            }
            catch (Exception e) {
                System.out.println("Unable to load ProjectHelper from service META-INF/services/org.apache.tools.ant.ProjectHelper (" + e.getMessage() + ")");
                if (!DEBUG) break block5;
                e.printStackTrace(System.err);
            }
        }
        return null;
    }

    private ProjectHelper newHelper(String helperClass) throws BuildException {
        ClassLoader classLoader = LoaderUtils.getContextClassLoader();
        try {
            Class<?> clazz = null;
            if (classLoader != null) {
                try {
                    clazz = classLoader.loadClass(helperClass);
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = Class.forName(helperClass);
            }
            return (ProjectHelper)clazz.newInstance();
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    public ProjectHelper getProjectHelperForBuildFile(Resource buildFile) throws BuildException {
        Iterator it = this.getHelpers();
        while (it.hasNext()) {
            ProjectHelper helper = (ProjectHelper)it.next();
            if (!helper.canParseBuildFile(buildFile)) continue;
            if (DEBUG) {
                System.out.println("ProjectHelper " + helper.getClass().getName() + " selected for the build file " + buildFile);
            }
            return helper;
        }
        throw new RuntimeException("BUG: at least the ProjectHelper2 should have supported the file " + buildFile);
    }

    public ProjectHelper getProjectHelperForAntlib(Resource antlib) throws BuildException {
        Iterator it = this.getHelpers();
        while (it.hasNext()) {
            ProjectHelper helper = (ProjectHelper)it.next();
            if (!helper.canParseAntlibDescriptor(antlib)) continue;
            if (DEBUG) {
                System.out.println("ProjectHelper " + helper.getClass().getName() + " selected for the antlib " + antlib);
            }
            return helper;
        }
        throw new RuntimeException("BUG: at least the ProjectHelper2 should have supported the file " + antlib);
    }

    public Iterator getHelpers() {
        return new ConstructingIterator(this.helpers.iterator());
    }

    private static class ConstructingIterator
    implements Iterator {
        private final Iterator nested;

        ConstructingIterator(Iterator nested) {
            this.nested = nested;
        }

        public boolean hasNext() {
            return this.nested.hasNext();
        }

        public Object next() {
            Constructor c = (Constructor)this.nested.next();
            try {
                return c.newInstance(NO_OBJECT);
            }
            catch (Exception e) {
                throw new BuildException("Failed to invoke no-arg constructor on " + c.getName());
            }
        }

        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }
    }
}

