/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;

public class Path {
    private Path() {
    }

    public static String normalizeResourcePath(String path) {
        if (path == null) {
            return null;
        }
        String normalizedPath = Path.replaceSlashes(path.trim());
        if (normalizedPath.startsWith("/") && normalizedPath.length() > 1) {
            normalizedPath = normalizedPath.substring(1);
        }
        return normalizedPath;
    }

    public static String securePath(String path) {
        String p = path == null ? "" : FilenameUtils.separatorsToUnix(path);
        try {
            URL url = new URL(p);
            p = url.getPath();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return FilenameUtils.normalize(p, true);
    }

    public static String replaceSlashes(String target) {
        String replaced = target;
        if (replaced != null) {
            replaced = replaced.replaceAll("/+", "/");
        }
        return replaced;
    }

    public static String[] normalizePatterns(String[] urlPatterns) {
        String[] normalized = null;
        if (urlPatterns != null) {
            normalized = new String[urlPatterns.length];
            for (int i = 0; i < urlPatterns.length; ++i) {
                normalized[i] = Path.normalizePattern(urlPatterns[i]);
            }
        }
        return normalized;
    }

    public static String normalizePattern(String pattern) {
        if (pattern == null || "".equals(pattern.trim())) {
            return "/";
        }
        if (!pattern.startsWith("/") && !pattern.startsWith("*")) {
            return "/" + pattern;
        }
        return pattern;
    }

    public static String normalizeAlias(String alias) {
        if (alias == null) {
            return null;
        }
        if (alias.equals("/")) {
            return alias;
        }
        if (alias.startsWith("*.")) {
            throw new IllegalArgumentException("Alias can't be in the form of \"*.alias\"");
        }
        if (!alias.startsWith("/")) {
            alias = "/" + alias;
        }
        while (alias.length() > 1 && alias.endsWith("/")) {
            alias = alias.substring(0, alias.length() - 1);
        }
        return alias;
    }
}

