/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.constants;

public abstract class Enum {
    public static String NULL = "NULL";
    protected String value = NULL;

    protected Enum(String value) {
        this.setValue(value);
    }

    protected Enum() {
        this(NULL);
    }

    protected abstract String[] getValues();

    public void setValue(String value) {
        if (value.equals(NULL)) {
            this.value = NULL;
        } else {
            String[] possibleValues = this.getValues();
            String[] valuesToBeTested = value.split("\\s");
            for (int i = 0; i < valuesToBeTested.length; ++i) {
                for (int j = 0; j < possibleValues.length && !possibleValues[j].equals(valuesToBeTested[i]); ++j) {
                    if (i != possibleValues.length - 1) continue;
                    throw new EnumValueException("Bad Enumeration value '" + value + "'");
                }
            }
            this.value = value;
        }
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object what) {
        return what.getClass().equals(this.getClass()) && ((Enum)what).getValue().equals(this.getValue());
    }

    protected static final int index(String value, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (!value.equals(values[i])) continue;
            return i;
        }
        return -1;
    }

    public static class EnumValueException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public EnumValueException(String mesg) {
            super(mesg);
        }
    }
}

