/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.jd.gui.util.swing.SwingUtil;

public class SaveAllSourcesView {
    protected JDialog saveAllSourcesDialog;
    protected JLabel saveAllSourcesLabel;
    protected JProgressBar saveAllSourcesProgressBar;

    public SaveAllSourcesView(JFrame mainFrame, final Runnable cancelCallback) {
        SwingUtil.invokeLater(() -> {
            this.saveAllSourcesDialog = new JDialog(mainFrame, "Save All Sources", false);
            this.saveAllSourcesDialog.setResizable(false);
            this.saveAllSourcesDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    cancelCallback.run();
                }
            });
            Box vbox = Box.createVerticalBox();
            vbox.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
            this.saveAllSourcesDialog.add(vbox);
            Box hbox = Box.createHorizontalBox();
            this.saveAllSourcesLabel = new JLabel();
            hbox.add(this.saveAllSourcesLabel);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(10));
            this.saveAllSourcesProgressBar = new JProgressBar();
            vbox.add(this.saveAllSourcesProgressBar);
            vbox.add(Box.createVerticalStrut(15));
            hbox = Box.createHorizontalBox();
            hbox.add(Box.createHorizontalGlue());
            JButton saveAllSourcesCancelButton = new JButton("Cancel");
            AbstractAction saveAllSourcesCancelActionListener = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    cancelCallback.run();
                    SaveAllSourcesView.this.saveAllSourcesDialog.setVisible(false);
                }
            };
            saveAllSourcesCancelButton.addActionListener(saveAllSourcesCancelActionListener);
            hbox.add(saveAllSourcesCancelButton);
            vbox.add(hbox);
            JRootPane rootPane = this.saveAllSourcesDialog.getRootPane();
            rootPane.setDefaultButton(saveAllSourcesCancelButton);
            rootPane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "SaveAllSourcesView.cancel");
            rootPane.getActionMap().put("SaveAllSourcesView.cancel", saveAllSourcesCancelActionListener);
            this.saveAllSourcesDialog.pack();
        });
    }

    public void show(File file) {
        SwingUtil.invokeLater(() -> {
            this.saveAllSourcesLabel.setText("Saving '" + file.getAbsolutePath() + "'...");
            this.saveAllSourcesProgressBar.setValue(0);
            this.saveAllSourcesProgressBar.setMaximum(10);
            this.saveAllSourcesProgressBar.setIndeterminate(true);
            this.saveAllSourcesDialog.pack();
            this.saveAllSourcesDialog.setLocationRelativeTo(this.saveAllSourcesDialog.getParent());
            this.saveAllSourcesDialog.setVisible(true);
        });
    }

    public boolean isVisible() {
        return this.saveAllSourcesDialog.isVisible();
    }

    public void setMaxValue(int maxValue) {
        SwingUtil.invokeLater(() -> {
            if (maxValue > 0) {
                this.saveAllSourcesProgressBar.setMaximum(maxValue);
                this.saveAllSourcesProgressBar.setIndeterminate(false);
            } else {
                this.saveAllSourcesProgressBar.setIndeterminate(true);
            }
        });
    }

    public void updateProgressBar(int value) {
        SwingUtil.invokeLater(() -> this.saveAllSourcesProgressBar.setValue(value));
    }

    public void hide() {
        SwingUtil.invokeLater(() -> this.saveAllSourcesDialog.setVisible(false));
    }

    public void showActionFailedDialog() {
        SwingUtil.invokeLater(() -> JOptionPane.showMessageDialog(this.saveAllSourcesDialog, "'Save All Sources' action failed.", "Error", 0));
    }
}

