/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.core.xmlgen.ParserConstants;
import jadx.core.xmlgen.ParserStream;
import java.io.IOException;
import java.util.Arrays;

public class CommonBinaryParser
extends ParserConstants {
    protected ParserStream is;

    protected String[] parseStringPool() throws IOException {
        this.is.checkInt16(1, "String pool expected");
        return this.parseStringPoolNoType();
    }

    protected String[] parseStringPoolNoType() throws IOException {
        long start = this.is.getPos() - 2L;
        this.is.checkInt16(28, "String pool header size not 0x001c");
        long size = this.is.readUInt32();
        long chunkEnd = start + size;
        int stringCount = this.is.readInt32();
        int styleCount = this.is.readInt32();
        int flags = this.is.readInt32();
        long stringsStart = this.is.readInt32();
        long stylesStart = this.is.readInt32();
        int[] stringsOffset = this.is.readInt32Array(stringCount);
        int[] stylesOffset = this.is.readInt32Array(styleCount);
        this.is.skipToPos(start + stringsStart, "Expected strings start");
        String[] strings = new String[stringCount];
        byte[] strData = this.is.readInt8Array((int)(chunkEnd - this.is.getPos()));
        if ((flags & 0x100) != 0) {
            for (int i = 0; i < stringCount; ++i) {
                strings[i] = CommonBinaryParser.extractString8(strData, stringsOffset[i]);
            }
        } else {
            for (int i = 0; i < stringCount; ++i) {
                strings[i] = CommonBinaryParser.extractString16(strData, stringsOffset[i]);
            }
        }
        this.is.checkPos(chunkEnd, "Expected strings pool end");
        return strings;
    }

    private static String extractString8(byte[] strArray, int offset) {
        int len;
        if (offset >= strArray.length) {
            return "STRING_DECODE_ERROR";
        }
        int start = offset + CommonBinaryParser.skipStrLen8(strArray, offset);
        if ((len = strArray[start++]) == 0) {
            return "";
        }
        if ((len & 0x80) != 0) {
            len = (len & 0x7F) << 8 | strArray[start++] & 0xFF;
        }
        byte[] arr = Arrays.copyOfRange(strArray, start, start + len);
        return new String(arr, ParserStream.STRING_CHARSET_UTF8);
    }

    private static String extractString16(byte[] strArray, int offset) {
        int start;
        int len = strArray.length;
        int end = start = offset + CommonBinaryParser.skipStrLen16(strArray, offset);
        while (end + 1 < len && (strArray[end] != 0 || strArray[end + 1] != 0)) {
            end += 2;
        }
        byte[] arr = Arrays.copyOfRange(strArray, start, end);
        return new String(arr, ParserStream.STRING_CHARSET_UTF16);
    }

    private static int skipStrLen8(byte[] strArray, int offset) {
        return (strArray[offset] & 0x80) == 0 ? 1 : 2;
    }

    private static int skipStrLen16(byte[] strArray, int offset) {
        return (strArray[offset + 1] & 0x80) == 0 ? 2 : 4;
    }

    protected void die(String message) throws IOException {
        throw new IOException("Decode error: " + message + ", position: 0x" + Long.toHexString(this.is.getPos()));
    }
}

