/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.Collections;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import javax.xml.crypto.dsig.spec.XSLTTransformParameterSpec;
import javax.xml.crypto.test.dsig.TestUtils;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class TransformTest
extends TestCase {
    XMLSignatureFactory factory;
    private static final String[] TRANSFORM_ALGOS = new String[]{"http://www.w3.org/2000/09/xmldsig#base64", "http://www.w3.org/2000/09/xmldsig#enveloped-signature", "http://www.w3.org/TR/1999/REC-xpath-19991116", "http://www.w3.org/2002/06/xmldsig-filter2", "http://www.w3.org/TR/1999/REC-xslt-19991116"};

    public TransformTest() {
        super("TransformTest");
    }

    public TransformTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.factory = XMLSignatureFactory.getInstance("DOM", new XMLDSigRI());
    }

    public void tearDown() {
    }

    public void testisFeatureSupported() throws Exception {
        for (int i = 0; i < TRANSFORM_ALGOS.length; ++i) {
            String string = TRANSFORM_ALGOS[i];
            TransformParameterSpec transformParameterSpec = null;
            if (string.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
                transformParameterSpec = new XPathFilterParameterSpec("xPath");
            } else if (string.equals("http://www.w3.org/2002/06/xmldsig-filter2")) {
                transformParameterSpec = new XPathFilter2ParameterSpec(Collections.singletonList(new XPathType("xPath2", XPathType.Filter.INTERSECT)));
            } else if (string.equals("http://www.w3.org/TR/1999/REC-xslt-19991116")) {
                transformParameterSpec = new XSLTTransformParameterSpec(new XSLTStructure());
            }
            Transform transform = this.factory.newTransform(string, transformParameterSpec);
            try {
                transform.isFeatureSupported(null);
                TransformTest.fail((String)(TRANSFORM_ALGOS[i] + ": Should raise a NPE for null feature"));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            TransformTest.assertTrue((!transform.isFeatureSupported("not supported") ? 1 : 0) != 0);
        }
    }

    public void testConstructor() throws Exception {
        Transform transform;
        for (int i = 0; i < TRANSFORM_ALGOS.length; ++i) {
            String string = TRANSFORM_ALGOS[i];
            TransformParameterSpec transformParameterSpec = null;
            if (string.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
                transformParameterSpec = new XPathFilterParameterSpec("xPath");
            } else if (string.equals("http://www.w3.org/2002/06/xmldsig-filter2")) {
                transformParameterSpec = new XPathFilter2ParameterSpec(Collections.singletonList(new XPathType("xPath2", XPathType.Filter.INTERSECT)));
            } else if (string.equals("http://www.w3.org/TR/1999/REC-xslt-19991116")) {
                transformParameterSpec = new XSLTTransformParameterSpec(new XSLTStructure());
            }
            try {
                transform = this.factory.newTransform(string, transformParameterSpec);
                TransformTest.assertNotNull((Object)transform);
                TransformTest.assertEquals((String)transform.getAlgorithm(), (String)string);
                TransformTest.assertEquals((Object)transform.getParameterSpec(), (Object)transformParameterSpec);
            }
            catch (Exception exception) {
                TransformTest.fail((String)(TRANSFORM_ALGOS[i] + ": Unexpected exception " + exception));
            }
            try {
                transform = this.factory.newTransform(string, new TestUtils.MyOwnC14nParameterSpec());
                TransformTest.fail((String)(TRANSFORM_ALGOS[i] + ": Should raise an IAPE for invalid parameters"));
                continue;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                continue;
            }
            catch (Exception exception) {
                TransformTest.fail((String)(TRANSFORM_ALGOS[i] + ": Should raise a IAPE instead of " + exception));
            }
        }
        try {
            transform = this.factory.newTransform(null, (TransformParameterSpec)null);
            TransformTest.fail((String)"Should raise a NPE for null algo");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            TransformTest.fail((String)("Should raise a NPE instead of " + exception));
        }
        try {
            transform = this.factory.newTransform("non-existent", (TransformParameterSpec)null);
            TransformTest.fail((String)"Should raise an NSAE for non-existent algos");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (Exception exception) {
            TransformTest.fail((String)("Should raise an NSAE instead of " + exception));
        }
    }

    static {
        Security.insertProviderAt(new XMLDSigRI(), 1);
    }

    private static class XSLTStructure
    implements XMLStructure {
        private XSLTStructure() {
        }

        public boolean isFeatureSupported(String string) {
            return false;
        }
    }
}

