/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import nu.validator.messages.MessageEmitter;
import nu.validator.messages.MessageTextHandler;
import nu.validator.messages.ResultHandler;
import nu.validator.messages.TextMessageTextHandler;
import nu.validator.messages.TextResultHandler;
import nu.validator.messages.types.MessageType;
import org.xml.sax.SAXException;

public class TextMessageEmitter
extends MessageEmitter {
    private static final char[] COLON_SPACE = new char[]{':', ' '};
    private static final char[] PERIOD = new char[]{'.'};
    private static final char[] ON_LINE = "On line ".toCharArray();
    private static final char[] AT_LINE = "At line ".toCharArray();
    private static final char[] FROM_LINE = "From line ".toCharArray();
    private static final char[] TO_LINE = "; to line ".toCharArray();
    private static final char[] COLUMN = ", column ".toCharArray();
    private static final char[] IN_RESOURCE = " in resource ".toCharArray();
    private final Writer writer;
    private final TextMessageTextHandler messageTextHandler;
    private String systemId;
    private int oneBasedFirstLine;
    private int oneBasedFirstColumn;
    private int oneBasedLastLine;
    private int oneBasedLastColumn;
    private boolean textEmitted;

    private static Writer newOutputStreamWriter(OutputStream out) {
        CharsetEncoder enc = Charset.forName("UTF-8").newEncoder();
        enc.onMalformedInput(CodingErrorAction.REPLACE);
        enc.onUnmappableCharacter(CodingErrorAction.REPLACE);
        return new OutputStreamWriter(out, enc);
    }

    public TextMessageEmitter(OutputStream out, boolean asciiQuotes) {
        this.writer = TextMessageEmitter.newOutputStreamWriter(out);
        this.messageTextHandler = new TextMessageTextHandler(this.writer, asciiQuotes);
    }

    public TextMessageEmitter(Writer writer, boolean asciiQuotes) {
        this.writer = writer;
        this.messageTextHandler = new TextMessageTextHandler(writer, asciiQuotes);
    }

    private void emitErrorLevel(char[] level) throws IOException {
        this.writer.write(level, 0, level.length);
    }

    private void maybeEmitLocation() throws IOException {
        if (this.oneBasedLastLine == -1 && this.systemId == null) {
            return;
        }
        if (this.oneBasedLastLine == -1) {
            this.emitSystemId();
        } else if (this.oneBasedLastColumn == -1) {
            this.emitLineLocation();
        } else if (this.oneBasedFirstLine == -1 || this.oneBasedFirstLine == this.oneBasedLastLine && this.oneBasedFirstColumn == this.oneBasedLastColumn) {
            this.emitSingleLocation();
        } else {
            this.emitRangeLocation();
        }
        this.writer.write(10);
    }

    private void maybeEmitInResource() throws IOException {
        if (this.systemId != null) {
            this.writer.write(IN_RESOURCE);
            this.emitSystemId();
        }
    }

    private void emitSystemId() throws IOException {
        this.writer.write(this.systemId);
    }

    private void emitRangeLocation() throws IOException {
        this.writer.write(FROM_LINE);
        this.writer.write(Integer.toString(this.oneBasedFirstLine));
        this.writer.write(COLUMN);
        this.writer.write(Integer.toString(this.oneBasedFirstColumn));
        this.writer.write(TO_LINE);
        this.writer.write(Integer.toString(this.oneBasedLastLine));
        this.writer.write(COLUMN);
        this.writer.write(Integer.toString(this.oneBasedLastColumn));
        this.maybeEmitInResource();
    }

    private void emitSingleLocation() throws IOException {
        this.writer.write(AT_LINE);
        this.writer.write(Integer.toString(this.oneBasedLastLine));
        this.writer.write(COLUMN);
        this.writer.write(Integer.toString(this.oneBasedLastColumn));
        this.maybeEmitInResource();
    }

    private void emitLineLocation() throws IOException {
        this.writer.write(ON_LINE);
        this.writer.write(Integer.toString(this.oneBasedLastLine));
        this.maybeEmitInResource();
    }

    @Override
    public void startMessage(MessageType type, String systemId, int oneBasedFirstLine, int oneBasedFirstColumn, int oneBasedLastLine, int oneBasedLastColumn, boolean exact) throws SAXException {
        this.systemId = systemId;
        this.oneBasedFirstLine = oneBasedFirstLine;
        this.oneBasedFirstColumn = oneBasedFirstColumn;
        this.oneBasedLastLine = oneBasedLastLine;
        this.oneBasedLastColumn = oneBasedLastColumn;
        try {
            this.emitErrorLevel(type.getPresentationName());
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
        this.textEmitted = false;
    }

    @Override
    public void endMessages(String language) throws SAXException {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endText() throws SAXException {
        try {
            this.writer.write(10);
            this.textEmitted = true;
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void startMessages(String documentUri, boolean willShowSource) throws SAXException {
    }

    @Override
    public MessageTextHandler startText() throws SAXException {
        try {
            this.writer.write(COLON_SPACE);
            return this.messageTextHandler;
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endMessage() throws SAXException {
        try {
            if (!this.textEmitted) {
                this.writer.write(PERIOD);
                this.writer.write(10);
            }
            this.maybeEmitLocation();
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public ResultHandler startResult() throws SAXException {
        return new TextResultHandler(this.writer);
    }
}

