/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.swing;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class LinkButton
extends JButton {
    private boolean mouseOver;
    private boolean focused;
    private String text;

    public LinkButton() {
        this.tweak();
    }

    public LinkButton(String text) {
        super(text);
        this.tweak();
    }

    public LinkButton(String text, Icon icon) {
        super(text, icon);
        this.tweak();
    }

    @Override
    public void setText(String text) {
        this.text = text.replace("<", "&lt;").replace(">", "&gt;").replace(" ", "&nbsp;");
        if (this.isEnabled() && (this.mouseOver || this.focused)) {
            super.setText("<html><a href='#'>" + this.text + "</a></html>");
        } else {
            super.setText("<html>" + this.text + "</html>");
        }
    }

    @Override
    protected void fireActionPerformed(ActionEvent e) {
        super.fireActionPerformed(e);
        this.clicked();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected void clicked() {
    }

    protected void middleClicked(MouseEvent e) {
    }

    protected void populatePopup(JPopupMenu popup) {
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 525 || code == 121 && e.getModifiers() == 1) {
            e.consume();
            this.showPopupMenu(null);
        }
        super.processKeyEvent(e);
    }

    private void tweak() {
        this.putClientProperty("JComponent.sizeVariant", "regular");
        this.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
        this.setOpaque(false);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        MouseAdapter mouse = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                LinkButton.this.mouseOver = true;
                LinkButton.this.setText(LinkButton.this.text);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LinkButton.this.mouseOver = false;
                LinkButton.this.setText(LinkButton.this.text);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!LinkButton.this.mouseOver) {
                    LinkButton.this.mouseOver = true;
                    LinkButton.this.setText(LinkButton.this.text);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    LinkButton.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    LinkButton.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    LinkButton.this.middleClicked(e);
                }
            }
        };
        this.addMouseListener(mouse);
        this.addMouseMotionListener(mouse);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LinkButton.this.focused = true;
                LinkButton.this.setText(LinkButton.this.text);
            }

            @Override
            public void focusLost(FocusEvent e) {
                LinkButton.this.focused = false;
                LinkButton.this.mouseOver = false;
                LinkButton.this.setText(LinkButton.this.text);
            }
        });
    }

    private void showPopupMenu(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        this.populatePopup(popup);
        if (popup.getComponentCount() > 0) {
            Dimension pref = popup.getPreferredSize();
            if (e == null) {
                popup.show(this, this.getWidth() / 2, -pref.height);
            } else {
                popup.show(this, e.getX(), e.getY() - pref.height);
            }
        }
    }
}

