/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.context.Flag;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakTransaction;

public class InfinispanKeycloakTransaction
implements KeycloakTransaction {
    private static final Logger log = Logger.getLogger(InfinispanKeycloakTransaction.class);
    private static final CacheTask TOMBSTONE = new CacheTask(){

        @Override
        public void execute() {
        }

        public String toString() {
            return "Tombstone after removal";
        }
    };
    private boolean active;
    private boolean rollback;
    private final Map<Object, CacheTask> tasks = new LinkedHashMap<Object, CacheTask>();

    public void begin() {
        this.active = true;
    }

    public void commit() {
        if (this.rollback) {
            throw new RuntimeException("Rollback only!");
        }
        this.tasks.values().forEach(CacheTask::execute);
    }

    public void rollback() {
        this.tasks.clear();
    }

    public void setRollbackOnly() {
        this.rollback = true;
    }

    public boolean getRollbackOnly() {
        return this.rollback;
    }

    public boolean isActive() {
        return this.active;
    }

    public <K, V> void put(final BasicCache<K, V> cache, final K key, V value, long lifespan, TimeUnit lifespanUnit) {
        log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.ADD_WITH_LIFESPAN, key);
        Object taskKey = InfinispanKeycloakTransaction.getTaskKey(cache, key);
        if (this.tasks.containsKey(taskKey)) {
            throw new IllegalStateException("Can't add session: task in progress for session");
        }
        this.tasks.put(taskKey, new CacheTaskWithValue<V>(value, lifespan, lifespanUnit){

            @Override
            public void execute() {
                InfinispanKeycloakTransaction.decorateCache(cache).put(key, this.value, this.lifespan, this.lifespanUnit);
            }

            public String toString() {
                return String.format("CacheTaskWithValue: Operation 'put' for key %s, lifespan %d TimeUnit %s", new Object[]{key, this.lifespan, this.lifespanUnit});
            }

            @Override
            public Operation getOperation() {
                return Operation.PUT;
            }
        });
    }

    public <K, V> void replace(final Cache<K, V> cache, final K key, V value, long lifespan, TimeUnit lifespanUnit) {
        log.tracev("Adding cache operation: {0} on {1}. Lifespan {2} {3}.", new Object[]{CacheOperation.REPLACE, key, lifespan, lifespanUnit});
        Object taskKey = InfinispanKeycloakTransaction.getTaskKey(cache, key);
        CacheTask current = this.tasks.get(taskKey);
        if (current != null) {
            if (current instanceof CacheTaskWithValue) {
                ((CacheTaskWithValue)current).setValue(value);
                ((CacheTaskWithValue)current).updateLifespan(lifespan, lifespanUnit);
            } else if (current != TOMBSTONE && current.getOperation() != Operation.REMOVE) {
                throw new IllegalStateException("Can't replace entry: task " + String.valueOf(current) + " in progress for session");
            }
        } else {
            this.tasks.put(taskKey, new CacheTaskWithValue<V>(value, lifespan, lifespanUnit){

                @Override
                public void execute() {
                    InfinispanKeycloakTransaction.decorateCache(cache).replace(key, this.value, this.lifespan, this.lifespanUnit);
                }

                public String toString() {
                    return String.format("CacheTaskWithValue: Operation 'replace' for key %s, lifespan %d TimeUnit %s", new Object[]{key, this.lifespan, this.lifespanUnit});
                }
            });
        }
    }

    public <K, V> void remove(final BasicCache<K, V> cache, final K key) {
        log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.REMOVE, key);
        Object taskKey = InfinispanKeycloakTransaction.getTaskKey(cache, key);
        CacheTask current = this.tasks.get(taskKey);
        if (current != null) {
            if (current instanceof CacheTaskWithValue && current.getOperation() == Operation.PUT) {
                this.tasks.put(taskKey, TOMBSTONE);
                return;
            }
            if (current == TOMBSTONE) {
                return;
            }
        }
        this.tasks.put(taskKey, new CacheTask(){

            @Override
            public void execute() {
                InfinispanKeycloakTransaction.decorateCache(cache).remove(key);
            }

            public String toString() {
                return String.format("CacheTask: Operation 'remove' for key %s", key);
            }

            @Override
            public Operation getOperation() {
                return Operation.REMOVE;
            }
        });
    }

    public <K, V> V get(BasicCache<K, V> cache, K key) {
        Object taskKey = InfinispanKeycloakTransaction.getTaskKey(cache, key);
        CacheTask current = this.tasks.get(taskKey);
        if (current != null && current instanceof CacheTaskWithValue) {
            return ((CacheTaskWithValue)current).getValue();
        }
        return (V)cache.get(key);
    }

    private static <K, V> Object getTaskKey(BasicCache<K, V> cache, K key) {
        if (key instanceof String) {
            return cache.getName() + "::" + key;
        }
        return key;
    }

    private static <K, V> BasicCache<K, V> decorateCache(BasicCache<K, V> cache) {
        if (cache instanceof RemoteCache) {
            return cache;
        }
        return ((Cache)cache).getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.SKIP_REMOTE_LOOKUP});
    }

    public static enum CacheOperation {
        ADD_WITH_LIFESPAN,
        REMOVE,
        REPLACE;

    }

    public static interface CacheTask {
        public void execute();

        default public Operation getOperation() {
            return Operation.OTHER;
        }
    }

    public static abstract class CacheTaskWithValue<V>
    implements CacheTask {
        protected V value;
        protected long lifespan;
        protected TimeUnit lifespanUnit;

        public CacheTaskWithValue(V value, long lifespan, TimeUnit lifespanUnit) {
            this.value = value;
            this.lifespan = lifespan;
            this.lifespanUnit = lifespanUnit;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public void updateLifespan(long lifespan, TimeUnit lifespanUnit) {
            this.lifespan = lifespan;
            this.lifespanUnit = lifespanUnit;
        }
    }

    public static enum Operation {
        PUT,
        REMOVE,
        OTHER;

    }
}

