/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metadata.impl;

import java.util.Objects;
import net.jcip.annotations.Immutable;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@Immutable
@ProtoTypeId(value=13)
public final class PrivateMetadata {
    private static final PrivateMetadata EMPTY = new PrivateMetadata(null, null);
    @ProtoField(value=1)
    final IracMetadata iracMetadata;
    private final IncrementableEntryVersion entryVersion;

    private PrivateMetadata(IracMetadata iracMetadata, IncrementableEntryVersion entryVersion) {
        this.iracMetadata = iracMetadata;
        this.entryVersion = entryVersion;
    }

    public static PrivateMetadata empty() {
        return EMPTY;
    }

    public static Builder getBuilder(PrivateMetadata metadata) {
        return metadata == null ? new Builder() : metadata.builder();
    }

    @ProtoFactory
    static PrivateMetadata protoFactory(IracMetadata iracMetadata, NumericVersion numericVersion, SimpleClusteredVersion clusteredVersion) {
        IncrementableEntryVersion entryVersion = numericVersion == null ? clusteredVersion : numericVersion;
        return PrivateMetadata.newInstance(iracMetadata, entryVersion);
    }

    private static PrivateMetadata newInstance(IracMetadata iracMetadata, IncrementableEntryVersion entryVersion) {
        return iracMetadata == null && entryVersion == null ? EMPTY : new PrivateMetadata(iracMetadata, entryVersion);
    }

    public Builder builder() {
        return new Builder(this);
    }

    public IracMetadata iracMetadata() {
        return this.iracMetadata;
    }

    public IncrementableEntryVersion entryVersion() {
        return this.entryVersion;
    }

    public boolean isEmpty() {
        return this.iracMetadata == null && this.entryVersion == null;
    }

    public String toString() {
        return "PrivateMetadata{iracMetadata=" + String.valueOf(this.iracMetadata) + ", entryVersion=" + String.valueOf(this.entryVersion) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivateMetadata metadata = (PrivateMetadata)o;
        return Objects.equals(this.iracMetadata, metadata.iracMetadata) && Objects.equals(this.entryVersion, metadata.entryVersion);
    }

    public int hashCode() {
        return Objects.hash(this.iracMetadata, this.entryVersion);
    }

    @ProtoField(value=2)
    public NumericVersion getNumericVersion() {
        return this.entryVersion instanceof NumericVersion ? (NumericVersion)this.entryVersion : null;
    }

    @ProtoField(value=3)
    public SimpleClusteredVersion getClusteredVersion() {
        return this.entryVersion instanceof SimpleClusteredVersion ? (SimpleClusteredVersion)this.entryVersion : null;
    }

    public static class Builder {
        private IracMetadata iracMetadata;
        private IncrementableEntryVersion entryVersion;

        public Builder() {
        }

        private Builder(PrivateMetadata metadata) {
            this.iracMetadata = metadata.iracMetadata;
            this.entryVersion = metadata.entryVersion;
        }

        public PrivateMetadata build() {
            return PrivateMetadata.newInstance(this.iracMetadata, this.entryVersion);
        }

        public Builder iracMetadata(IracMetadata metadata) {
            this.iracMetadata = metadata;
            return this;
        }

        public Builder entryVersion(IncrementableEntryVersion entryVersion) {
            this.entryVersion = entryVersion;
            return this;
        }
    }
}

