/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.prefs;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.Utilities;

public class ActionPrefs {
    private static final Logger LOG = Logger.getLogger("tr.view.action.prefs");
    public static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/2.2.1/actn");
    public static final String KEY_NOTE_DELEGATE_EMAIL = "note.delegate.email";
    private static final boolean DEF_NOTE_DELEGATE_EMAIL = true;
    public static final String KEY_SHOW_DUE = "show.due";
    private static final boolean DEF_SHOW_DUE = false;
    public static final String KEY_SHOW_START = "show.start";
    private static final boolean DEF_SHOW_START = false;
    public static final String KEY_SHOW_SUCCESS = "show.success";
    private static final boolean DEF_SHOW_SUCCESS = true;
    public static final String KEY_EDIT_CREATE_DATE = "edit.create-date";
    private static final boolean DEF_EDIT_CREATE_DATE = false;
    private static final String KEY_ENCODING = "email.encoding";
    private static final String DEF_ENCODING = "UTF-8";
    private static final String DEF_ENCODING_LINUX = "";
    private static Boolean isNoteDelegateEmail;
    private static Boolean isShowSuccess;
    private static Boolean isShowDueDate;
    private static Boolean isShowStartDate;
    private static Boolean isEditCreateDate;

    public static final boolean isNoteDelegateEmail() {
        isNoteDelegateEmail = prefs.getBoolean(KEY_NOTE_DELEGATE_EMAIL, true);
        return isNoteDelegateEmail;
    }

    public static final void setNoteDelegateEmail(boolean value) {
        if (value == isNoteDelegateEmail) {
            return;
        }
        prefs.putBoolean(KEY_NOTE_DELEGATE_EMAIL, value);
        ActionPrefs.flush();
        isNoteDelegateEmail = value;
    }

    public static final boolean isShowDueDate() {
        isShowDueDate = prefs.getBoolean(KEY_SHOW_DUE, false);
        return isShowDueDate;
    }

    public static final void setShowDueDate(boolean value) {
        if (value == isShowDueDate) {
            return;
        }
        prefs.putBoolean(KEY_SHOW_DUE, value);
        ActionPrefs.flush();
        isShowDueDate = value;
    }

    public static final boolean isShowStartDate() {
        isShowStartDate = prefs.getBoolean(KEY_SHOW_START, false);
        return isShowStartDate;
    }

    public static final void setShowStartDate(boolean value) {
        if (value == isShowStartDate) {
            return;
        }
        prefs.putBoolean(KEY_SHOW_START, value);
        ActionPrefs.flush();
        isShowStartDate = value;
    }

    public static final boolean isShowSuccess() {
        isShowSuccess = prefs.getBoolean(KEY_SHOW_SUCCESS, true);
        return isShowSuccess;
    }

    public static final void setShowSuccess(boolean value) {
        if (value == isShowSuccess) {
            return;
        }
        prefs.putBoolean(KEY_SHOW_SUCCESS, value);
        ActionPrefs.flush();
        isShowSuccess = value;
    }

    public static final boolean isEditCreateDate() {
        isEditCreateDate = prefs.getBoolean(KEY_EDIT_CREATE_DATE, false);
        return isEditCreateDate;
    }

    public static final void setEditCreateDate(boolean value) {
        if (value == isEditCreateDate) {
            return;
        }
        prefs.putBoolean(KEY_EDIT_CREATE_DATE, value);
        ActionPrefs.flush();
        isEditCreateDate = value;
    }

    public static final String getEmailEncoding() {
        if (Utilities.getOperatingSystem() == 16) {
            return prefs.get(KEY_ENCODING, DEF_ENCODING_LINUX);
        }
        return prefs.get(KEY_ENCODING, DEF_ENCODING);
    }

    public static final void setEmailEncoding(String value) {
        prefs.put(KEY_ENCODING, value == null ? DEF_ENCODING_LINUX : value.trim());
        ActionPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Action preferences error. " + ex.getMessage());
        }
    }
}

