/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.fonts;

public class CharacterSetOrientation {
    private String _codePage;
    private String _encoding;
    private int _ascender;
    private int _descender;
    private int _capHeight;
    private int[] _characters = new int[256];
    private int _xHeight;
    private int _firstCharacter;
    private int _lastCharacter;
    private int _orientation = 0;

    public CharacterSetOrientation(int orientation) {
        this._orientation = orientation;
    }

    public int getAscender() {
        return this._ascender;
    }

    public int getCapHeight() {
        return this._capHeight;
    }

    public int getDescender() {
        return this._descender;
    }

    public int getFirstChar() {
        return this._firstCharacter;
    }

    public int getLastChar() {
        return this._lastCharacter;
    }

    public int getOrientation() {
        return this._orientation;
    }

    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(this._characters, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    public int getXHeight() {
        return this._xHeight;
    }

    public int width(int character) {
        return this._characters[character];
    }

    public void setAscender(int ascender) {
        this._ascender = ascender;
    }

    public void setCapHeight(int capHeight) {
        this._capHeight = capHeight;
    }

    public void setDescender(int descender) {
        this._descender = descender;
    }

    public void setFirstChar(int firstCharacter) {
        this._firstCharacter = firstCharacter;
    }

    public void setLastChar(int lastCharacter) {
        this._lastCharacter = lastCharacter;
    }

    public void setWidth(int character, int width) {
        if (character >= this._characters.length) {
            int[] arr = new int[character - this._firstCharacter + 1];
            System.arraycopy(this._characters, 0, arr, 0, this._characters.length);
            this._characters = arr;
        }
        this._characters[character] = width;
    }

    public void setXHeight(int xHeight) {
        this._xHeight = xHeight;
    }
}

