/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(22, -23, 4) >> 0) => ivec3(22, -23, 4)
 * (ivec3(22, -23, 4) >> 1) => ivec3(11, -12, 2)
 * (ivec3(22, -23, 4) >> 2) => ivec3(5, -6, 1)
 * (ivec3(22, -23, 4) >> 5) => ivec3(0, -1, 0)
 * (ivec3(22, -23, 4) >> 25) => ivec3(0, -1, 0)
 * (ivec3(22, -23, 4) >> 31) => ivec3(0, -1, 0)
 * (ivec3(22, 23, 4) >> 0) => ivec3(22, 23, 4)
 * (ivec3(22, 23, 4) >> 1) => ivec3(11, 11, 2)
 * (ivec3(22, 23, 4) >> 2) => ivec3(5, 5, 1)
 * (ivec3(22, 23, 4) >> 5) => ivec3(0, 0, 0)
 * (ivec3(22, 23, 4) >> 25) => ivec3(0, 0, 0)
 * (ivec3(22, 23, 4) >> 31) => ivec3(0, 0, 0)
 * (ivec3(-19, 1, -13) >> 0) => ivec3(-19, 1, -13)
 * (ivec3(-19, 1, -13) >> 1) => ivec3(-10, 0, -7)
 * (ivec3(-19, 1, -13) >> 2) => ivec3(-5, 0, -4)
 * (ivec3(-19, 1, -13) >> 5) => ivec3(-1, 0, -1)
 * (ivec3(-19, 1, -13) >> 25) => ivec3(-1, 0, -1)
 * (ivec3(-19, 1, -13) >> 31) => ivec3(-1, 0, -1)
 * (ivec3(19, 1, 13) >> 0) => ivec3(19, 1, 13)
 * (ivec3(19, 1, 13) >> 1) => ivec3(9, 0, 6)
 * (ivec3(19, 1, 13) >> 2) => ivec3(4, 0, 3)
 * (ivec3(19, 1, 13) >> 5) => ivec3(0, 0, 0)
 * (ivec3(19, 1, 13) >> 25) => ivec3(0, 0, 0)
 * (ivec3(19, 1, 13) >> 31) => ivec3(0, 0, 0)
 */
#version 150

void main()
{
  float[all(equal((ivec3(22, -23, 4) >> 0), ivec3(22, -23, 4))) ? 1 : -1] array0;
  float[all(equal((ivec3(22, -23, 4) >> 1), ivec3(11, -12, 2))) ? 1 : -1] array1;
  float[all(equal((ivec3(22, -23, 4) >> 2), ivec3(5, -6, 1))) ? 1 : -1] array2;
  float[all(equal((ivec3(22, -23, 4) >> 5), ivec3(0, -1, 0))) ? 1 : -1] array3;
  float[all(equal((ivec3(22, -23, 4) >> 25), ivec3(0, -1, 0))) ? 1 : -1] array4;
  float[all(equal((ivec3(22, -23, 4) >> 31), ivec3(0, -1, 0))) ? 1 : -1] array5;
  float[all(equal((ivec3(22, 23, 4) >> 0), ivec3(22, 23, 4))) ? 1 : -1] array6;
  float[all(equal((ivec3(22, 23, 4) >> 1), ivec3(11, 11, 2))) ? 1 : -1] array7;
  float[all(equal((ivec3(22, 23, 4) >> 2), ivec3(5, 5, 1))) ? 1 : -1] array8;
  float[all(equal((ivec3(22, 23, 4) >> 5), ivec3(0, 0, 0))) ? 1 : -1] array9;
  float[all(equal((ivec3(22, 23, 4) >> 25), ivec3(0, 0, 0))) ? 1 : -1] array10;
  float[all(equal((ivec3(22, 23, 4) >> 31), ivec3(0, 0, 0))) ? 1 : -1] array11;
  float[all(equal((ivec3(-19, 1, -13) >> 0), ivec3(-19, 1, -13))) ? 1 : -1] array12;
  float[all(equal((ivec3(-19, 1, -13) >> 1), ivec3(-10, 0, -7))) ? 1 : -1] array13;
  float[all(equal((ivec3(-19, 1, -13) >> 2), ivec3(-5, 0, -4))) ? 1 : -1] array14;
  float[all(equal((ivec3(-19, 1, -13) >> 5), ivec3(-1, 0, -1))) ? 1 : -1] array15;
  float[all(equal((ivec3(-19, 1, -13) >> 25), ivec3(-1, 0, -1))) ? 1 : -1] array16;
  float[all(equal((ivec3(-19, 1, -13) >> 31), ivec3(-1, 0, -1))) ? 1 : -1] array17;
  float[all(equal((ivec3(19, 1, 13) >> 0), ivec3(19, 1, 13))) ? 1 : -1] array18;
  float[all(equal((ivec3(19, 1, 13) >> 1), ivec3(9, 0, 6))) ? 1 : -1] array19;
  float[all(equal((ivec3(19, 1, 13) >> 2), ivec3(4, 0, 3))) ? 1 : -1] array20;
  float[all(equal((ivec3(19, 1, 13) >> 5), ivec3(0, 0, 0))) ? 1 : -1] array21;
  float[all(equal((ivec3(19, 1, 13) >> 25), ivec3(0, 0, 0))) ? 1 : -1] array22;
  float[all(equal((ivec3(19, 1, 13) >> 31), ivec3(0, 0, 0))) ? 1 : -1] array23;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length());
}
