/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(-64, 72, 88, -76) & (- 12)) => ivec4(-64, 64, 80, -76)
 * (ivec4(-64, 72, 88, -76) & (- -6)) => ivec4(0, 0, 0, 4)
 * (ivec4(-64, 72, 88, -76) & (- 76)) => ivec4(-128, 0, 16, -76)
 * (ivec4(-64, 72, 88, -76) & (- -32)) => ivec4(0, 0, 0, 32)
 * (ivec4(-64, 72, 88, -76) & (- 0)) => ivec4(0, 0, 0, 0)
 * (ivec4(64, 72, 88, 76) & (- 12)) => ivec4(64, 64, 80, 68)
 * (ivec4(64, 72, 88, 76) & (- -6)) => ivec4(0, 0, 0, 4)
 * (ivec4(64, 72, 88, 76) & (- 76)) => ivec4(0, 0, 16, 4)
 * (ivec4(64, 72, 88, 76) & (- -32)) => ivec4(0, 0, 0, 0)
 * (ivec4(64, 72, 88, 76) & (- 0)) => ivec4(0, 0, 0, 0)
 * (ivec4(-24, 40, -23, 64) & (- 12)) => ivec4(-32, 32, -32, 64)
 * (ivec4(-24, 40, -23, 64) & (- -6)) => ivec4(0, 0, 0, 0)
 * (ivec4(-24, 40, -23, 64) & (- 76)) => ivec4(-96, 32, -96, 0)
 * (ivec4(-24, 40, -23, 64) & (- -32)) => ivec4(32, 32, 32, 0)
 * (ivec4(-24, 40, -23, 64) & (- 0)) => ivec4(0, 0, 0, 0)
 * (ivec4(24, 40, 23, 64) & (- 12)) => ivec4(16, 32, 20, 64)
 * (ivec4(24, 40, 23, 64) & (- -6)) => ivec4(0, 0, 6, 0)
 * (ivec4(24, 40, 23, 64) & (- 76)) => ivec4(16, 32, 20, 0)
 * (ivec4(24, 40, 23, 64) & (- -32)) => ivec4(0, 32, 0, 0)
 * (ivec4(24, 40, 23, 64) & (- 0)) => ivec4(0, 0, 0, 0)
 */
#version 150

void main()
{
  float[all(equal((ivec4(-64, 72, 88, -76) & (- 12)), ivec4(-64, 64, 80, -76))) ? 1 : -1] array0;
  float[all(equal((ivec4(-64, 72, 88, -76) & (- -6)), ivec4(0, 0, 0, 4))) ? 1 : -1] array1;
  float[all(equal((ivec4(-64, 72, 88, -76) & (- 76)), ivec4(-128, 0, 16, -76))) ? 1 : -1] array2;
  float[all(equal((ivec4(-64, 72, 88, -76) & (- -32)), ivec4(0, 0, 0, 32))) ? 1 : -1] array3;
  float[all(equal((ivec4(-64, 72, 88, -76) & (- 0)), ivec4(0, 0, 0, 0))) ? 1 : -1] array4;
  float[all(equal((ivec4(64, 72, 88, 76) & (- 12)), ivec4(64, 64, 80, 68))) ? 1 : -1] array5;
  float[all(equal((ivec4(64, 72, 88, 76) & (- -6)), ivec4(0, 0, 0, 4))) ? 1 : -1] array6;
  float[all(equal((ivec4(64, 72, 88, 76) & (- 76)), ivec4(0, 0, 16, 4))) ? 1 : -1] array7;
  float[all(equal((ivec4(64, 72, 88, 76) & (- -32)), ivec4(0, 0, 0, 0))) ? 1 : -1] array8;
  float[all(equal((ivec4(64, 72, 88, 76) & (- 0)), ivec4(0, 0, 0, 0))) ? 1 : -1] array9;
  float[all(equal((ivec4(-24, 40, -23, 64) & (- 12)), ivec4(-32, 32, -32, 64))) ? 1 : -1] array10;
  float[all(equal((ivec4(-24, 40, -23, 64) & (- -6)), ivec4(0, 0, 0, 0))) ? 1 : -1] array11;
  float[all(equal((ivec4(-24, 40, -23, 64) & (- 76)), ivec4(-96, 32, -96, 0))) ? 1 : -1] array12;
  float[all(equal((ivec4(-24, 40, -23, 64) & (- -32)), ivec4(32, 32, 32, 0))) ? 1 : -1] array13;
  float[all(equal((ivec4(-24, 40, -23, 64) & (- 0)), ivec4(0, 0, 0, 0))) ? 1 : -1] array14;
  float[all(equal((ivec4(24, 40, 23, 64) & (- 12)), ivec4(16, 32, 20, 64))) ? 1 : -1] array15;
  float[all(equal((ivec4(24, 40, 23, 64) & (- -6)), ivec4(0, 0, 6, 0))) ? 1 : -1] array16;
  float[all(equal((ivec4(24, 40, 23, 64) & (- 76)), ivec4(16, 32, 20, 0))) ? 1 : -1] array17;
  float[all(equal((ivec4(24, 40, 23, 64) & (- -32)), ivec4(0, 32, 0, 0))) ? 1 : -1] array18;
  float[all(equal((ivec4(24, 40, 23, 64) & (- 0)), ivec4(0, 0, 0, 0))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
