/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.customized;

import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.UserTransaction;
import io.quarkus.arc.Arc;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.lang.annotation.Annotation;
import org.hibernate.engine.transaction.jta.platform.internal.TransactionManagerAccess;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformException;

public final class QuarkusJtaPlatform
implements JtaPlatform,
TransactionManagerAccess {
    public static final QuarkusJtaPlatform INSTANCE = new QuarkusJtaPlatform();
    private volatile TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private volatile jakarta.transaction.TransactionManager transactionManager;
    private volatile jakarta.transaction.UserTransaction userTransaction;

    private QuarkusJtaPlatform() {
    }

    public TransactionSynchronizationRegistry retrieveTransactionSynchronizationRegistry() {
        TransactionSynchronizationRegistry transactionSynchronizationRegistry = this.transactionSynchronizationRegistry;
        if (transactionSynchronizationRegistry == null) {
            this.transactionSynchronizationRegistry = transactionSynchronizationRegistry = (TransactionSynchronizationRegistry)Arc.container().instance(TransactionSynchronizationRegistry.class, new Annotation[0]).get();
        }
        return transactionSynchronizationRegistry;
    }

    public jakarta.transaction.TransactionManager retrieveTransactionManager() {
        jakarta.transaction.TransactionManager transactionManager = this.transactionManager;
        if (transactionManager == null) {
            this.transactionManager = transactionManager = TransactionManager.transactionManager();
        }
        return transactionManager;
    }

    public jakarta.transaction.TransactionManager getTransactionManager() {
        return this.retrieveTransactionManager();
    }

    public jakarta.transaction.UserTransaction retrieveUserTransaction() {
        jakarta.transaction.UserTransaction userTransaction = this.userTransaction;
        if (userTransaction == null) {
            this.userTransaction = userTransaction = UserTransaction.userTransaction();
        }
        return userTransaction;
    }

    public Object getTransactionIdentifier(Transaction transaction) {
        return transaction;
    }

    public void registerSynchronization(Synchronization synchronization) {
        try {
            this.getTransactionManager().getTransaction().registerSynchronization(synchronization);
        }
        catch (Exception e) {
            throw new JtaPlatformException("Could not access JTA Transaction to register synchronization", (Throwable)e);
        }
    }

    public boolean canRegisterSynchronization() {
        return this.retrieveTransactionSynchronizationRegistry().getTransactionStatus() == 0;
    }

    public int getCurrentStatus() throws SystemException {
        return this.retrieveTransactionManager().getStatus();
    }
}

