/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Retry;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.sessions.infinispan.changes.PersistentUpdate;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.tracing.TracingProvider;

public class PersistentSessionsWorker {
    private static final Logger LOG = Logger.getLogger(PersistentSessionsWorker.class);
    private final KeycloakSessionFactory factory;
    private final ArrayBlockingQueue<PersistentUpdate> asyncQueuePersistentUpdate;
    private final int maxBatchSize;
    private final List<Thread> threads = new ArrayList<Thread>();
    private volatile boolean stop;

    public PersistentSessionsWorker(KeycloakSessionFactory factory, ArrayBlockingQueue<PersistentUpdate> asyncQueuePersistentUpdate, int maxBatchSize) {
        this.factory = factory;
        this.asyncQueuePersistentUpdate = asyncQueuePersistentUpdate;
        this.maxBatchSize = maxBatchSize;
    }

    public void start() {
        this.threads.add(new BatchWorker(this.asyncQueuePersistentUpdate));
        this.threads.forEach(Thread::start);
    }

    public void stop() {
        this.stop = true;
        this.threads.forEach(Thread::interrupt);
        this.threads.forEach(t -> {
            try {
                t.join(TimeUnit.MINUTES.toMillis(1L));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        });
    }

    private class BatchWorker
    extends Thread {
        private final ArrayBlockingQueue<PersistentUpdate> queue;

        public BatchWorker(ArrayBlockingQueue<PersistentUpdate> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            Thread.currentThread().setName(this.getClass().getName());
            while (!PersistentSessionsWorker.this.stop) {
                try {
                    this.process(this.queue);
                }
                catch (InterruptedException e) {
                    if (PersistentSessionsWorker.this.stop) continue;
                    LOG.warn((Object)"Caught interrupted exception", (Throwable)e);
                }
                catch (RuntimeException e) {
                    LOG.warn((Object)"Exception when processing queue events", (Throwable)e);
                }
            }
        }

        private void process(ArrayBlockingQueue<PersistentUpdate> queue) throws InterruptedException {
            ArrayList<PersistentUpdate> batch = new ArrayList<PersistentUpdate>();
            PersistentUpdate polled = queue.poll(1L, TimeUnit.SECONDS);
            if (polled != null) {
                batch.add(polled);
                queue.drainTo(batch, PersistentSessionsWorker.this.maxBatchSize - 1);
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)PersistentSessionsWorker.this.factory, outerSession -> {
                    TracingProvider tracing = (TracingProvider)outerSession.getProvider(TracingProvider.class);
                    Tracer process = tracing.getTracer("PersistentSessionsWorker");
                    SpanBuilder spanBuilder = process.spanBuilder("PersistentSessionsWorker.process");
                    batch.stream().map(update -> update.getSpan().getSpanContext()).forEach(arg_0 -> ((SpanBuilder)spanBuilder).addLink(arg_0));
                    Span span = tracing.startSpan(spanBuilder);
                    LinkedList batchSpans = new LinkedList();
                    try {
                        batch.forEach(persistentUpdate -> {
                            SpanBuilder sb = process.spanBuilder("PersistentSessionsWorker.batch");
                            sb.setParent(Context.current().with((ImplicitContextKeyed)persistentUpdate.getSpan()));
                            sb.addLink(span.getSpanContext());
                            batchSpans.add(sb.startSpan());
                        });
                        LOG.debugf("Processing %d deferred session updates.", batch.size());
                        Retry.executeWithBackoff(iteration -> {
                            if (iteration < 2) {
                                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)PersistentSessionsWorker.this.factory, innerSession -> batch.forEach(c -> c.perform(innerSession)));
                                batch.forEach(PersistentUpdate::complete);
                            } else {
                                LOG.warnf("Running single changes in iteration %d for %d entries", (Object)iteration, (Object)batch.size());
                                ArrayList performedChanges = new ArrayList();
                                ArrayList throwables = new ArrayList();
                                batch.forEach(change -> {
                                    try {
                                        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)PersistentSessionsWorker.this.factory, change::perform);
                                        change.complete();
                                        performedChanges.add(change);
                                    }
                                    catch (ModelDuplicateException ex) {
                                        tracing.error((Throwable)ex);
                                        change.fail(ex);
                                        performedChanges.add(change);
                                    }
                                    catch (Throwable ex) {
                                        if (iteration > 20) {
                                            tracing.error(ex);
                                            change.fail(ex);
                                            performedChanges.add(change);
                                        }
                                        throwables.add(ex);
                                    }
                                });
                                batch.removeAll(performedChanges);
                                if (!throwables.isEmpty()) {
                                    RuntimeException ex = new RuntimeException("unable to complete some changes");
                                    throwables.forEach(ex::addSuppressed);
                                    throw ex;
                                }
                            }
                        }, (Duration)Duration.of(10L, ChronoUnit.SECONDS), (int)0);
                    }
                    catch (RuntimeException ex) {
                        tracing.error((Throwable)ex);
                        batch.forEach(o -> o.fail(ex));
                        LOG.warnf((Throwable)ex, "Unable to write %d deferred session updates", (Object)batch.size());
                    }
                    finally {
                        batchSpans.forEach(Span::end);
                        tracing.endSpan();
                    }
                });
            }
        }
    }
}

