/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.AscendingRangeIterator;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.IntegerValue;

public class ForMemberExpression
extends Assignation {
    @Override
    public String getExpressionName() {
        return "forMember";
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getSequenceOp().typeCheck(visitor, contextInfo);
        RoleDiagnostic role = new RoleDiagnostic(20, "'in' clause of for-member", 0);
        Expression operand = visitor.getConfiguration().getTypeChecker(false).staticTypeCheck(this.getSequence(), ArrayItemType.SINGLE_ARRAY, role, visitor);
        this.setSequence(operand);
        if (Literal.isEmptySequence(this.getAction())) {
            return this.getAction();
        }
        this.getActionOp().typeCheck(visitor, contextInfo);
        return this;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        return this.getAction().getIntegerBounds();
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ForMemberExpression forExp = new ForMemberExpression();
        ExpressionTool.copyLocationInfo(this, forExp);
        forExp.setRequiredType(this.requiredType);
        forExp.setVariableQName(this.variableName);
        forExp.setSequence(this.getSequence().copy(rebindings));
        Expression newAction = this.getAction().copy(rebindings);
        forExp.setAction(newAction);
        forExp.variableName = this.variableName;
        forExp.slotNumber = this.slotNumber;
        ExpressionTool.rebindVariableReferences(newAction, this, forExp);
        return forExp;
    }

    @Override
    public boolean isVacuousExpression() {
        return this.getAction().isVacuousExpression();
    }

    @Override
    public int getImplementationMethod() {
        return 6;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, boolean whole) throws XPathException {
        this.getAction().checkPermittedContents(parentType, false);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        int slot = this.getLocalSlotNumber();
        ArrayItem theArray = (ArrayItem)this.getSequence().evaluateItem(context);
        int length = theArray.arrayLength();
        AscendingRangeIterator base = new AscendingRangeIterator(0L, 1L, length - 1);
        return MappingIterator.map(base, index -> {
            GroundedValue member = theArray.get((int)((IntegerValue)index).longValue());
            context.setLocalVariable(slot, member);
            return this.getAction().iterate(context);
        });
    }

    @Override
    public void process(Outputter output, XPathContext context) throws XPathException {
        int slot = this.getLocalSlotNumber();
        ArrayItem theArray = (ArrayItem)this.getSequence().evaluateItem(context);
        for (GroundedValue member : theArray.members()) {
            context.setLocalVariable(slot, member);
            this.getAction().process(output, context);
        }
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        int slot = this.getLocalSlotNumber();
        ArrayItem theArray = (ArrayItem)this.getSequence().evaluateItem(context);
        for (GroundedValue member : theArray.members()) {
            context.setLocalVariable(slot, member);
            this.getAction().evaluatePendingUpdates(context, pul);
        }
    }

    @Override
    public ItemType getItemType() {
        return this.getAction().getItemType();
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        return this.getAction().getStaticUType(contextItemType);
    }

    @Override
    protected int computeCardinality() {
        return 57344;
    }

    @Override
    public String toString() {
        return "for member $" + this.getVariableEQName() + " in " + (this.getSequence() == null ? "(...)" : this.getSequence().toString()) + " return " + (this.getAction() == null ? "(...)" : ExpressionTool.parenthesize(this.getAction()));
    }

    @Override
    public String toShortString() {
        return "for member $" + this.getVariableQName().getDisplayName() + " in " + (this.getSequence() == null ? "(...)" : this.getSequence().toShortString()) + " return " + (this.getAction() == null ? "(...)" : this.getAction().toShortString());
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("forMember", this);
        out.emitAttribute("var", this.getVariableQName());
        out.emitAttribute("slot", "" + this.getLocalSlotNumber());
        out.setChildRole("in");
        this.getSequence().export(out);
        out.setChildRole("return");
        this.getAction().export(out);
        out.endElement();
    }

    @Override
    public String getStreamerName() {
        return "ForMemberExpression";
    }
}

