/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.message;

import org.ice4j.StunException;

public class ChannelData {
    private char channelNumber = '\u0000';
    private byte[] data = null;
    public static char HEADER_LENGTH = (char)4;

    public void setChannelNumber(char channelNumber) {
        this.channelNumber = channelNumber;
    }

    public char getChannelNumber() {
        return this.channelNumber;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public char getDataLength() {
        if (this.data == null) {
            return '\u0000';
        }
        return (char)this.data.length;
    }

    private static int padTo4(int num) {
        return num + 3 & 0xFFFFFFFC;
    }

    private static boolean validateChannelNumber(char channelNumber) {
        return channelNumber > '\u3fff';
    }

    public byte[] encode() throws StunException {
        return this.encode(false);
    }

    public byte[] encode(boolean pad) throws StunException {
        int dataLength = this.getDataLength();
        if (pad) {
            dataLength = ChannelData.padTo4(dataLength);
        }
        byte[] binMsg = new byte[HEADER_LENGTH + dataLength];
        int offset = 0;
        if (!ChannelData.validateChannelNumber(this.channelNumber)) {
            throw new StunException(2, "Channel number invalid");
        }
        binMsg[offset++] = (byte)(this.channelNumber >> 8);
        binMsg[offset++] = (byte)(this.channelNumber & 0xFF);
        binMsg[offset++] = (byte)(this.data != null ? this.data.length >> 8 : 0);
        binMsg[offset++] = (byte)(this.data != null ? this.data.length & 0xFF : 0);
        if (this.data != null) {
            System.arraycopy(this.data, 0, binMsg, offset, this.data.length);
        }
        return binMsg;
    }

    public static ChannelData decode(byte[] binMessage, char offset, char arrayLen) throws StunException {
        return ChannelData.decode(binMessage, offset);
    }

    public static ChannelData decode(byte[] binMessage, char offset) throws StunException {
        char msgLen = '\u0000';
        char channelNumber = '\u0000';
        ChannelData channelData = null;
        byte[] data = null;
        if (binMessage.length - offset < HEADER_LENGTH) {
            throw new StunException(2, "Size too short");
        }
        char c = offset;
        char c2 = offset = (char)(offset + '\u0001');
        offset = (char)(offset + '\u0001');
        channelNumber = (char)(binMessage[c] << 8 | binMessage[c2] & 0xFF);
        if (!ChannelData.validateChannelNumber(channelNumber)) {
            throw new StunException(2, "Channel number invalid");
        }
        char c3 = offset;
        msgLen = (char)(binMessage[c3] << 8 | binMessage[offset = (char)(offset + '\u0001')] & 0xFF);
        if (msgLen > binMessage.length - (offset = (char)(offset + '\u0001'))) {
            throw new StunException(2, "Size mismatch");
        }
        data = new byte[msgLen];
        System.arraycopy(binMessage, offset, data, 0, msgLen);
        channelData = new ChannelData();
        channelData.setData(data);
        channelData.setChannelNumber(channelNumber);
        return channelData;
    }

    public static boolean isChannelDataMessage(byte[] binMessage) {
        return binMessage[0] >> 6 == 1;
    }
}

