/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.widgets;

import com.github.ajalt.mordant.internal.FormattingKt;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.table.ColumnWidth;
import com.github.ajalt.mordant.widgets.ProgressCell;
import com.github.ajalt.mordant.widgets.ProgressState;
import com.github.ajalt.mordant.widgets.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/github/ajalt/mordant/widgets/SpeedProgressCell;", "Lcom/github/ajalt/mordant/widgets/ProgressCell;", "suffix", "", "style", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "(Ljava/lang/String;Lcom/github/ajalt/mordant/rendering/TextStyle;)V", "animationRate", "Lcom/github/ajalt/mordant/widgets/ProgressCell$AnimationRate;", "getAnimationRate", "()Lcom/github/ajalt/mordant/widgets/ProgressCell$AnimationRate;", "columnWidth", "Lcom/github/ajalt/mordant/table/ColumnWidth;", "getColumnWidth", "()Lcom/github/ajalt/mordant/table/ColumnWidth;", "makeWidget", "Lcom/github/ajalt/mordant/rendering/Widget;", "Lcom/github/ajalt/mordant/widgets/ProgressState;", "mordant"})
public final class SpeedProgressCell
implements ProgressCell {
    @NotNull
    private final String suffix;
    @NotNull
    private final TextStyle style;

    public SpeedProgressCell(@NotNull String suffix, @NotNull TextStyle style) {
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        Intrinsics.checkNotNullParameter(style, "style");
        this.suffix = suffix;
        this.style = style;
    }

    @Override
    @NotNull
    public ProgressCell.AnimationRate getAnimationRate() {
        return ProgressCell.AnimationRate.TEXT;
    }

    @Override
    @NotNull
    public ColumnWidth getColumnWidth() {
        return new ColumnWidth.Fixed(6 + this.suffix.length());
    }

    @Override
    @NotNull
    public Widget makeWidget(@NotNull ProgressState $this$makeWidget) {
        Intrinsics.checkNotNullParameter($this$makeWidget, "<this>");
        String t = $this$makeWidget.getIndeterminate() || $this$makeWidget.getCompletedPerSecond() <= 0.0 ? "---.-" : FormattingKt.formatWithSiSuffix($this$makeWidget.getCompletedPerSecond(), 1);
        return new Text(this.style.invoke(t + this.suffix), Whitespace.PRE, null, null, null, null, 60, null);
    }
}

