/***************************************************************************
    qgsuuidwidgetwrapper.h
     --------------------------------------
    Date                 : 5.1.2014
    Copyright            : (C) 2014 Matthias Kuhn
    Email                : matthias at opengis dot ch
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSUUIDWIDGETWRAPPER_H
#define QGSUUIDWIDGETWRAPPER_H

#include "qgseditorwidgetwrapper.h"

#include <QLineEdit>
#include <QLabel>
#include "qgis_gui.h"

SIP_NO_FILE


/**
 * \ingroup gui
 * \brief Wraps a uuid widget. Will create a new UUID if empty or represent the current value if not empty.
 * \note not available in Python bindings
 */

class GUI_EXPORT QgsUuidWidgetWrapper : public QgsEditorWidgetWrapper
{
    Q_OBJECT
  public:
    /**
     * Constructor for QgsUuidWidgetWrapper.
     *
     * The \a layer and \a fieldIdx arguments specify the vector layer field associated with the wrapper.
     *
     * The \a editor argument indicates the editor widget to use with the wrapper. This can be NULLPTR if a
     * new widget should be autogenerated.
     *
     * A \a parent widget for this widget wrapper and the created widget can also be specified.
     */
    explicit QgsUuidWidgetWrapper( QgsVectorLayer *layer, int fieldIdx, QWidget *editor = nullptr, QWidget *parent = nullptr );

    /**
     * Creates a UUID value, respecting the specified maximum length.
     *
     * \since QGIS 3.22
     */
    static QString createUiid( int maxLength = 0 );

    // QgsEditorWidgetWrapper interface

  public:
    QVariant value() const override;

  protected:
    QWidget *createWidget( QWidget *parent ) override;
    void initWidget( QWidget *editor ) override;
    bool valid() const override;

  public slots:
    void setEnabled( bool enabled ) override;

  private:
    void updateValues( const QVariant &value, const QVariantList & = QVariantList() ) override;

    QLabel *mLabel = nullptr;
    QLineEdit *mLineEdit = nullptr;
};

#endif // QGSUUIDWIDGETWRAPPER_H
