/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.protobuf;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.protobuf.ByteString;
import org.jetbrains.kotlin.protobuf.Descriptors;
import org.jetbrains.kotlin.protobuf.ExtensionRegistry;
import org.jetbrains.kotlin.protobuf.Message;
import org.jetbrains.kotlin.protobuf.MessageOrBuilder;
import org.jetbrains.kotlin.protobuf.MessageReflection;
import org.jetbrains.kotlin.protobuf.UnknownFieldSet;
import org.jetbrains.kotlin.protobuf.WireFormat;

public final class TextFormat {
    private static final Logger logger = Logger.getLogger(TextFormat.class.getName());
    private static final Printer DEFAULT_PRINTER = new Printer();
    private static final Printer SINGLE_LINE_PRINTER = Printer.access$100(new Printer(), true);
    private static final Printer UNICODE_PRINTER = Printer.access$200(new Printer(), false);
    private static final Parser PARSER = Parser.newBuilder().build();

    private TextFormat() {
    }

    public static void print(MessageOrBuilder message, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.print(message, new TextGenerator(output));
    }

    public static void print(UnknownFieldSet fields2, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.printUnknownFields(fields2, new TextGenerator(output));
    }

    public static void printUnicode(MessageOrBuilder message, Appendable output) throws IOException {
        TextFormat.UNICODE_PRINTER.print(message, new TextGenerator(output));
    }

    public static void printUnicode(UnknownFieldSet fields2, Appendable output) throws IOException {
        TextFormat.UNICODE_PRINTER.printUnknownFields(fields2, new TextGenerator(output));
    }

    public static String shortDebugString(MessageOrBuilder message) {
        try {
            StringBuilder sb = new StringBuilder();
            TextFormat.SINGLE_LINE_PRINTER.print(message, new TextGenerator(sb));
            return sb.toString().trim();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String shortDebugString(UnknownFieldSet fields2) {
        try {
            StringBuilder sb = new StringBuilder();
            TextFormat.SINGLE_LINE_PRINTER.printUnknownFields(fields2, new TextGenerator(sb));
            return sb.toString().trim();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToString(MessageOrBuilder message) {
        try {
            StringBuilder text = new StringBuilder();
            TextFormat.print(message, (Appendable)text);
            return text.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToString(UnknownFieldSet fields2) {
        try {
            StringBuilder text = new StringBuilder();
            TextFormat.print(fields2, (Appendable)text);
            return text.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToUnicodeString(MessageOrBuilder message) {
        try {
            StringBuilder text = new StringBuilder();
            TextFormat.UNICODE_PRINTER.print(message, new TextGenerator(text));
            return text.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToUnicodeString(UnknownFieldSet fields2) {
        try {
            StringBuilder text = new StringBuilder();
            TextFormat.UNICODE_PRINTER.printUnknownFields(fields2, new TextGenerator(text));
            return text.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void printField(Descriptors.FieldDescriptor field, Object value2, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.printField(field, value2, new TextGenerator(output));
    }

    public static String printFieldToString(Descriptors.FieldDescriptor field, Object value2) {
        try {
            StringBuilder text = new StringBuilder();
            TextFormat.printField(field, value2, text);
            return text.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void printFieldValue(Descriptors.FieldDescriptor field, Object value2, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.printFieldValue(field, value2, new TextGenerator(output));
    }

    public static void printUnknownFieldValue(int tag, Object value2, Appendable output) throws IOException {
        TextFormat.printUnknownFieldValue(tag, value2, new TextGenerator(output));
    }

    private static void printUnknownFieldValue(int tag, Object value2, TextGenerator generator) throws IOException {
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                generator.print(TextFormat.unsignedToString((Long)value2));
                break;
            }
            case 5: {
                generator.print(String.format((Locale)null, "0x%08x", (Integer)value2));
                break;
            }
            case 1: {
                generator.print(String.format((Locale)null, "0x%016x", (Long)value2));
                break;
            }
            case 2: {
                generator.print("\"");
                generator.print(TextFormat.escapeBytes((ByteString)value2));
                generator.print("\"");
                break;
            }
            case 3: {
                TextFormat.DEFAULT_PRINTER.printUnknownFields((UnknownFieldSet)value2, generator);
                break;
            }
            default: {
                int n = tag;
                throw new IllegalArgumentException(new StringBuilder(20).append("Bad tag: ").append(n).toString());
            }
        }
    }

    public static String unsignedToString(int value2) {
        if (value2 >= 0) {
            return Integer.toString(value2);
        }
        return Long.toString((long)value2 & 0xFFFFFFFFL);
    }

    public static String unsignedToString(long value2) {
        if (value2 >= 0L) {
            return Long.toString(value2);
        }
        return BigInteger.valueOf(value2 & Long.MAX_VALUE).setBit(63).toString();
    }

    public static Parser getParser() {
        return PARSER;
    }

    public static void merge(Readable input, Message.Builder builder) throws IOException {
        PARSER.merge(input, builder);
    }

    public static void merge(CharSequence input, Message.Builder builder) throws ParseException {
        PARSER.merge(input, builder);
    }

    public static void merge(Readable input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        PARSER.merge(input, extensionRegistry, builder);
    }

    public static void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        PARSER.merge(input, extensionRegistry, builder);
    }

    private static String escapeBytes(ByteSequence input) {
        StringBuilder builder = new StringBuilder(input.size());
        block12: for (int i = 0; i < input.size(); ++i) {
            byte b = input.byteAt(i);
            switch (b) {
                case 7: {
                    builder.append("\\a");
                    continue block12;
                }
                case 8: {
                    builder.append("\\b");
                    continue block12;
                }
                case 12: {
                    builder.append("\\f");
                    continue block12;
                }
                case 10: {
                    builder.append("\\n");
                    continue block12;
                }
                case 13: {
                    builder.append("\\r");
                    continue block12;
                }
                case 9: {
                    builder.append("\\t");
                    continue block12;
                }
                case 11: {
                    builder.append("\\v");
                    continue block12;
                }
                case 92: {
                    builder.append("\\\\");
                    continue block12;
                }
                case 39: {
                    builder.append("\\'");
                    continue block12;
                }
                case 34: {
                    builder.append("\\\"");
                    continue block12;
                }
                default: {
                    if (b >= 32) {
                        builder.append((char)b);
                        continue block12;
                    }
                    builder.append('\\');
                    builder.append((char)(48 + (b >>> 6 & 3)));
                    builder.append((char)(48 + (b >>> 3 & 7)));
                    builder.append((char)(48 + (b & 7)));
                }
            }
        }
        return builder.toString();
    }

    static String escapeBytes(final ByteString input) {
        return TextFormat.escapeBytes(new ByteSequence(){

            public int size() {
                return input.size();
            }

            public byte byteAt(int offset2) {
                return input.byteAt(offset2);
            }
        });
    }

    static String escapeBytes(final byte[] input) {
        return TextFormat.escapeBytes(new ByteSequence(){

            public int size() {
                return input.length;
            }

            public byte byteAt(int offset2) {
                return input[offset2];
            }
        });
    }

    static ByteString unescapeBytes(CharSequence charString) throws InvalidEscapeSequenceException {
        ByteString input = ByteString.copyFromUtf8(charString.toString());
        byte[] result2 = new byte[input.size()];
        int pos = 0;
        for (int i = 0; i < input.size(); ++i) {
            byte c = input.byteAt(i);
            if (c == 92) {
                if (i + 1 < input.size()) {
                    int code;
                    if (TextFormat.isOctal(c = input.byteAt(++i))) {
                        code = TextFormat.digitValue(c);
                        if (i + 1 < input.size() && TextFormat.isOctal(input.byteAt(i + 1))) {
                            code = code * 8 + TextFormat.digitValue(input.byteAt(++i));
                        }
                        if (i + 1 < input.size() && TextFormat.isOctal(input.byteAt(i + 1))) {
                            code = code * 8 + TextFormat.digitValue(input.byteAt(++i));
                        }
                        result2[pos++] = (byte)code;
                        continue;
                    }
                    switch (c) {
                        case 97: {
                            result2[pos++] = 7;
                            break;
                        }
                        case 98: {
                            result2[pos++] = 8;
                            break;
                        }
                        case 102: {
                            result2[pos++] = 12;
                            break;
                        }
                        case 110: {
                            result2[pos++] = 10;
                            break;
                        }
                        case 114: {
                            result2[pos++] = 13;
                            break;
                        }
                        case 116: {
                            result2[pos++] = 9;
                            break;
                        }
                        case 118: {
                            result2[pos++] = 11;
                            break;
                        }
                        case 92: {
                            result2[pos++] = 92;
                            break;
                        }
                        case 39: {
                            result2[pos++] = 39;
                            break;
                        }
                        case 34: {
                            result2[pos++] = 34;
                            break;
                        }
                        case 120: {
                            code = 0;
                            if (i + 1 >= input.size() || !TextFormat.isHex(input.byteAt(i + 1))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            code = TextFormat.digitValue(input.byteAt(++i));
                            if (i + 1 < input.size() && TextFormat.isHex(input.byteAt(i + 1))) {
                                code = code * 16 + TextFormat.digitValue(input.byteAt(++i));
                            }
                            result2[pos++] = (byte)code;
                            break;
                        }
                        default: {
                            char c2 = (char)c;
                            throw new InvalidEscapeSequenceException(new StringBuilder(29).append("Invalid escape sequence: '\\").append(c2).append("'").toString());
                        }
                    }
                    continue;
                }
                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            result2[pos++] = c;
        }
        return ByteString.copyFrom(result2, 0, pos);
    }

    static String escapeText(String input) {
        return TextFormat.escapeBytes(ByteString.copyFromUtf8(input));
    }

    public static String escapeDoubleQuotesAndBackslashes(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static boolean isOctal(byte c) {
        return 48 <= c && c <= 55;
    }

    private static boolean isHex(byte c) {
        return 48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    private static int digitValue(byte c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 122) {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    static int parseInt32(String text) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text, true, false);
    }

    static int parseUInt32(String text) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text, false, false);
    }

    static long parseInt64(String text) throws NumberFormatException {
        return TextFormat.parseInteger(text, true, true);
    }

    static long parseUInt64(String text) throws NumberFormatException {
        return TextFormat.parseInteger(text, false, true);
    }

    private static long parseInteger(String text, boolean isSigned, boolean isLong) throws NumberFormatException {
        int pos = 0;
        boolean negative = false;
        if (text.startsWith("-", pos)) {
            if (!isSigned) {
                String string2 = String.valueOf(text);
                throw new NumberFormatException(string2.length() != 0 ? "Number must be positive: ".concat(string2) : new String("Number must be positive: "));
            }
            ++pos;
            negative = true;
        }
        int radix = 10;
        if (text.startsWith("0x", pos)) {
            pos += 2;
            radix = 16;
        } else if (text.startsWith("0", pos)) {
            radix = 8;
        }
        String numberText = text.substring(pos);
        long result2 = 0L;
        if (numberText.length() < 16) {
            result2 = Long.parseLong(numberText, radix);
            if (negative) {
                result2 = -result2;
            }
            if (!isLong) {
                if (isSigned) {
                    if (result2 > Integer.MAX_VALUE || result2 < Integer.MIN_VALUE) {
                        String string3 = String.valueOf(text);
                        throw new NumberFormatException(string3.length() != 0 ? "Number out of range for 32-bit signed integer: ".concat(string3) : new String("Number out of range for 32-bit signed integer: "));
                    }
                } else if (result2 >= 0x100000000L || result2 < 0L) {
                    String string4 = String.valueOf(text);
                    throw new NumberFormatException(string4.length() != 0 ? "Number out of range for 32-bit unsigned integer: ".concat(string4) : new String("Number out of range for 32-bit unsigned integer: "));
                }
            }
        } else {
            BigInteger bigValue = new BigInteger(numberText, radix);
            if (negative) {
                bigValue = bigValue.negate();
            }
            if (!isLong) {
                if (isSigned) {
                    if (bigValue.bitLength() > 31) {
                        String string5 = String.valueOf(text);
                        throw new NumberFormatException(string5.length() != 0 ? "Number out of range for 32-bit signed integer: ".concat(string5) : new String("Number out of range for 32-bit signed integer: "));
                    }
                } else if (bigValue.bitLength() > 32) {
                    String string6 = String.valueOf(text);
                    throw new NumberFormatException(string6.length() != 0 ? "Number out of range for 32-bit unsigned integer: ".concat(string6) : new String("Number out of range for 32-bit unsigned integer: "));
                }
            } else if (isSigned) {
                if (bigValue.bitLength() > 63) {
                    String string7 = String.valueOf(text);
                    throw new NumberFormatException(string7.length() != 0 ? "Number out of range for 64-bit signed integer: ".concat(string7) : new String("Number out of range for 64-bit signed integer: "));
                }
            } else if (bigValue.bitLength() > 64) {
                String string8 = String.valueOf(text);
                throw new NumberFormatException(string8.length() != 0 ? "Number out of range for 64-bit unsigned integer: ".concat(string8) : new String("Number out of range for 64-bit unsigned integer: "));
            }
            result2 = bigValue.longValue();
        }
        return result2;
    }

    static class InvalidEscapeSequenceException
    extends IOException {
        private static final long serialVersionUID = -8164033650142593304L;

        InvalidEscapeSequenceException(String description) {
            super(description);
        }
    }

    private static interface ByteSequence {
        public int size();

        public byte byteAt(int var1);
    }

    public static class Parser {
        private final boolean allowUnknownFields;
        private final SingularOverwritePolicy singularOverwritePolicy;

        private Parser(boolean allowUnknownFields, SingularOverwritePolicy singularOverwritePolicy) {
            this.allowUnknownFields = allowUnknownFields;
            this.singularOverwritePolicy = singularOverwritePolicy;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public void merge(Readable input, Message.Builder builder) throws IOException {
            this.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
        }

        public void merge(CharSequence input, Message.Builder builder) throws ParseException {
            this.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
        }

        public void merge(Readable input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
            this.merge(Parser.toStringBuilder(input), extensionRegistry, builder);
        }

        private static StringBuilder toStringBuilder(Readable input) throws IOException {
            int n;
            StringBuilder text = new StringBuilder();
            CharBuffer buffer = CharBuffer.allocate(4096);
            while ((n = input.read(buffer)) != -1) {
                buffer.flip();
                text.append(buffer, 0, n);
            }
            return text;
        }

        public void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
            Tokenizer tokenizer = new Tokenizer(input);
            MessageReflection.BuilderAdapter target = new MessageReflection.BuilderAdapter(builder);
            while (!tokenizer.atEnd()) {
                this.mergeField(tokenizer, extensionRegistry, target);
            }
        }

        private void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget target) throws ParseException {
            String string2;
            CharSequence name2;
            Descriptors.FieldDescriptor field = null;
            Descriptors.Descriptor type2 = target.getDescriptorForType();
            ExtensionRegistry.ExtensionInfo extension = null;
            if (tokenizer.tryConsume("[")) {
                name2 = new StringBuilder(tokenizer.consumeIdentifier());
                while (tokenizer.tryConsume(".")) {
                    ((StringBuilder)name2).append('.');
                    ((StringBuilder)name2).append(tokenizer.consumeIdentifier());
                }
                extension = target.findExtensionByName(extensionRegistry, ((StringBuilder)name2).toString());
                if (extension == null) {
                    if (!this.allowUnknownFields) {
                        String string3 = String.valueOf(String.valueOf(name2));
                        throw tokenizer.parseExceptionPreviousToken(new StringBuilder(48 + string3.length()).append("Extension \"").append(string3).append("\" not found in the ExtensionRegistry.").toString());
                    }
                    string2 = String.valueOf(String.valueOf(name2));
                    logger.warning(new StringBuilder(48 + string2.length()).append("Extension \"").append(string2).append("\" not found in the ExtensionRegistry.").toString());
                } else {
                    if (extension.descriptor.getContainingType() != type2) {
                        String string4 = String.valueOf(String.valueOf(name2));
                        String string5 = String.valueOf(String.valueOf(type2.getFullName()));
                        throw tokenizer.parseExceptionPreviousToken(new StringBuilder(45 + string4.length() + string5.length()).append("Extension \"").append(string4).append("\" does not extend message type \"").append(string5).append("\".").toString());
                    }
                    field = extension.descriptor;
                }
                tokenizer.consume("]");
            } else {
                String lowerName;
                name2 = tokenizer.consumeIdentifier();
                field = type2.findFieldByName((String)name2);
                if (field == null && (field = type2.findFieldByName(lowerName = ((String)name2).toLowerCase(Locale.US))) != null && field.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                    field = null;
                }
                if (field != null && field.getType() == Descriptors.FieldDescriptor.Type.GROUP && !field.getMessageType().getName().equals(name2)) {
                    field = null;
                }
                if (field == null) {
                    if (!this.allowUnknownFields) {
                        string2 = String.valueOf(String.valueOf(type2.getFullName()));
                        String string6 = String.valueOf(String.valueOf(name2));
                        throw tokenizer.parseExceptionPreviousToken(new StringBuilder(38 + string2.length() + string6.length()).append("Message type \"").append(string2).append("\" has no field named \"").append(string6).append("\".").toString());
                    }
                    string2 = String.valueOf(String.valueOf(type2.getFullName()));
                    String string7 = String.valueOf(String.valueOf(name2));
                    logger.warning(new StringBuilder(38 + string2.length() + string7.length()).append("Message type \"").append(string2).append("\" has no field named \"").append(string7).append("\".").toString());
                }
            }
            if (field == null) {
                if (tokenizer.tryConsume(":") && !tokenizer.lookingAt("{") && !tokenizer.lookingAt("<")) {
                    this.skipFieldValue(tokenizer);
                } else {
                    this.skipFieldMessage(tokenizer);
                }
                return;
            }
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                tokenizer.tryConsume(":");
            } else {
                tokenizer.consume(":");
            }
            if (field.isRepeated() && tokenizer.tryConsume("[")) {
                while (true) {
                    this.consumeFieldValue(tokenizer, extensionRegistry, target, field, extension);
                    if (!tokenizer.tryConsume("]")) {
                        tokenizer.consume(",");
                        continue;
                    }
                    break;
                }
            } else {
                this.consumeFieldValue(tokenizer, extensionRegistry, target, field, extension);
            }
        }

        private void consumeFieldValue(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget target, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension) throws ParseException {
            Object enumType;
            Object value2 = null;
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                String endToken;
                if (tokenizer.tryConsume("<")) {
                    endToken = ">";
                } else {
                    tokenizer.consume("{");
                    endToken = "}";
                }
                MessageReflection.MergeTarget subField = target.newMergeTargetForField(field, extension == null ? null : extension.defaultInstance);
                while (!tokenizer.tryConsume(endToken)) {
                    if (tokenizer.atEnd()) {
                        String string2 = String.valueOf(String.valueOf(endToken));
                        throw tokenizer.parseException(new StringBuilder(12 + string2.length()).append("Expected \"").append(string2).append("\".").toString());
                    }
                    this.mergeField(tokenizer, extensionRegistry, subField);
                }
                value2 = subField.finish();
            } else {
                switch (field.getType()) {
                    case INT32: 
                    case SINT32: 
                    case SFIXED32: {
                        value2 = tokenizer.consumeInt32();
                        break;
                    }
                    case INT64: 
                    case SINT64: 
                    case SFIXED64: {
                        value2 = tokenizer.consumeInt64();
                        break;
                    }
                    case UINT32: 
                    case FIXED32: {
                        value2 = tokenizer.consumeUInt32();
                        break;
                    }
                    case UINT64: 
                    case FIXED64: {
                        value2 = tokenizer.consumeUInt64();
                        break;
                    }
                    case FLOAT: {
                        value2 = Float.valueOf(tokenizer.consumeFloat());
                        break;
                    }
                    case DOUBLE: {
                        value2 = tokenizer.consumeDouble();
                        break;
                    }
                    case BOOL: {
                        value2 = tokenizer.consumeBoolean();
                        break;
                    }
                    case STRING: {
                        value2 = tokenizer.consumeString();
                        break;
                    }
                    case BYTES: {
                        value2 = tokenizer.consumeByteString();
                        break;
                    }
                    case ENUM: {
                        enumType = field.getEnumType();
                        if (tokenizer.lookingAtInteger()) {
                            int number = tokenizer.consumeInt32();
                            value2 = ((Descriptors.EnumDescriptor)enumType).findValueByNumber(number);
                            if (value2 != null) break;
                            String string3 = String.valueOf(String.valueOf(((Descriptors.EnumDescriptor)enumType).getFullName()));
                            int n = number;
                            throw tokenizer.parseExceptionPreviousToken(new StringBuilder(50 + string3.length()).append("Enum type \"").append(string3).append("\" has no value with number ").append(n).append(".").toString());
                        }
                        String id = tokenizer.consumeIdentifier();
                        value2 = ((Descriptors.EnumDescriptor)enumType).findValueByName(id);
                        if (value2 != null) break;
                        String string4 = String.valueOf(String.valueOf(((Descriptors.EnumDescriptor)enumType).getFullName()));
                        String string5 = String.valueOf(String.valueOf(id));
                        throw tokenizer.parseExceptionPreviousToken(new StringBuilder(35 + string4.length() + string5.length()).append("Enum type \"").append(string4).append("\" has no value named \"").append(string5).append("\".").toString());
                    }
                    case MESSAGE: 
                    case GROUP: {
                        throw new RuntimeException("Can't get here.");
                    }
                }
            }
            if (field.isRepeated()) {
                target.addRepeatedField(field, value2);
            } else {
                if (this.singularOverwritePolicy == SingularOverwritePolicy.FORBID_SINGULAR_OVERWRITES && target.hasField(field)) {
                    enumType = String.valueOf(String.valueOf(field.getFullName()));
                    throw tokenizer.parseExceptionPreviousToken(new StringBuilder(44 + ((String)enumType).length()).append("Non-repeated field \"").append((String)enumType).append("\" cannot be overwritten.").toString());
                }
                if (this.singularOverwritePolicy == SingularOverwritePolicy.FORBID_SINGULAR_OVERWRITES && field.getContainingOneof() != null && target.hasOneof(field.getContainingOneof())) {
                    Descriptors.OneofDescriptor oneof = field.getContainingOneof();
                    String string6 = String.valueOf(String.valueOf(field.getFullName()));
                    String string7 = String.valueOf(String.valueOf(target.getOneofFieldDescriptor(oneof).getFullName()));
                    String string8 = String.valueOf(String.valueOf(oneof.getName()));
                    throw tokenizer.parseExceptionPreviousToken(new StringBuilder(70 + string6.length() + string7.length() + string8.length()).append("Field \"").append(string6).append("\" is specified along with field \"").append(string7).append("\", another member of oneof \"").append(string8).append("\".").toString());
                }
                target.setField(field, value2);
            }
        }

        private void skipField(Tokenizer tokenizer) throws ParseException {
            if (tokenizer.tryConsume("[")) {
                do {
                    tokenizer.consumeIdentifier();
                } while (tokenizer.tryConsume("."));
                tokenizer.consume("]");
            } else {
                tokenizer.consumeIdentifier();
            }
            if (tokenizer.tryConsume(":") && !tokenizer.lookingAt("<") && !tokenizer.lookingAt("{")) {
                this.skipFieldValue(tokenizer);
            } else {
                this.skipFieldMessage(tokenizer);
            }
            if (!tokenizer.tryConsume(";")) {
                tokenizer.tryConsume(",");
            }
        }

        private void skipFieldMessage(Tokenizer tokenizer) throws ParseException {
            String delimiter;
            if (tokenizer.tryConsume("<")) {
                delimiter = ">";
            } else {
                tokenizer.consume("{");
                delimiter = "}";
            }
            while (!tokenizer.lookingAt(">") && !tokenizer.lookingAt("}")) {
                this.skipField(tokenizer);
            }
            tokenizer.consume(delimiter);
        }

        private void skipFieldValue(Tokenizer tokenizer) throws ParseException {
            if (tokenizer.tryConsumeString()) {
                while (tokenizer.tryConsumeString()) {
                }
                return;
            }
            if (!(tokenizer.tryConsumeIdentifier() || tokenizer.tryConsumeInt64() || tokenizer.tryConsumeUInt64() || tokenizer.tryConsumeDouble() || tokenizer.tryConsumeFloat())) {
                String string2 = String.valueOf(tokenizer.currentToken);
                throw tokenizer.parseException(string2.length() != 0 ? "Invalid field value: ".concat(string2) : new String("Invalid field value: "));
            }
        }

        public static class Builder {
            private boolean allowUnknownFields = false;
            private SingularOverwritePolicy singularOverwritePolicy = SingularOverwritePolicy.ALLOW_SINGULAR_OVERWRITES;

            public Builder setSingularOverwritePolicy(SingularOverwritePolicy p) {
                this.singularOverwritePolicy = p;
                return this;
            }

            public Parser build() {
                return new Parser(this.allowUnknownFields, this.singularOverwritePolicy);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SingularOverwritePolicy {
            ALLOW_SINGULAR_OVERWRITES,
            FORBID_SINGULAR_OVERWRITES;

        }
    }

    public static class ParseException
    extends IOException {
        private static final long serialVersionUID = 3196188060225107702L;
        private final int line;
        private final int column;

        public ParseException(String message) {
            this(-1, -1, message);
        }

        public ParseException(int line, int column, String message) {
            String string2 = String.valueOf(String.valueOf(Integer.toString(line)));
            int n = column;
            String string3 = String.valueOf(String.valueOf(message));
            super(new StringBuilder(14 + string2.length() + string3.length()).append(string2).append(":").append(n).append(": ").append(string3).toString());
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Tokenizer {
        private final CharSequence text;
        private final Matcher matcher;
        private String currentToken;
        private int pos = 0;
        private int line = 0;
        private int column = 0;
        private int previousLine = 0;
        private int previousColumn = 0;
        private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
        private static final Pattern TOKEN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_+-]*+|[.]?[0-9+-][0-9a-zA-Z_.+-]*+|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^'\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
        private static final Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
        private static final Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
        private static final Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);

        private Tokenizer(CharSequence text) {
            this.text = text;
            this.matcher = WHITESPACE.matcher(text);
            this.skipWhitespace();
            this.nextToken();
        }

        public boolean atEnd() {
            return this.currentToken.length() == 0;
        }

        public void nextToken() {
            this.previousLine = this.line;
            this.previousColumn = this.column;
            while (this.pos < this.matcher.regionStart()) {
                if (this.text.charAt(this.pos) == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
            }
            if (this.matcher.regionStart() == this.matcher.regionEnd()) {
                this.currentToken = "";
            } else {
                this.matcher.usePattern(TOKEN);
                if (this.matcher.lookingAt()) {
                    this.currentToken = this.matcher.group();
                    this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
                } else {
                    this.currentToken = String.valueOf(this.text.charAt(this.pos));
                    this.matcher.region(this.pos + 1, this.matcher.regionEnd());
                }
                this.skipWhitespace();
            }
        }

        private void skipWhitespace() {
            this.matcher.usePattern(WHITESPACE);
            if (this.matcher.lookingAt()) {
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            }
        }

        public boolean tryConsume(String token) {
            if (this.currentToken.equals(token)) {
                this.nextToken();
                return true;
            }
            return false;
        }

        public void consume(String token) throws ParseException {
            if (!this.tryConsume(token)) {
                String string2 = String.valueOf(String.valueOf(token));
                throw this.parseException(new StringBuilder(12 + string2.length()).append("Expected \"").append(string2).append("\".").toString());
            }
        }

        public boolean lookingAtInteger() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            char c = this.currentToken.charAt(0);
            return '0' <= c && c <= '9' || c == '-' || c == '+';
        }

        public boolean lookingAt(String text) {
            return this.currentToken.equals(text);
        }

        public String consumeIdentifier() throws ParseException {
            for (int i = 0; i < this.currentToken.length(); ++i) {
                char c = this.currentToken.charAt(i);
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '.') continue;
                String string2 = String.valueOf(String.valueOf(this.currentToken));
                throw this.parseException(new StringBuilder(29 + string2.length()).append("Expected identifier. Found '").append(string2).append("'").toString());
            }
            String result2 = this.currentToken;
            this.nextToken();
            return result2;
        }

        public boolean tryConsumeIdentifier() {
            try {
                this.consumeIdentifier();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public int consumeInt32() throws ParseException {
            try {
                int result2 = TextFormat.parseInt32(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public int consumeUInt32() throws ParseException {
            try {
                int result2 = TextFormat.parseUInt32(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public long consumeInt64() throws ParseException {
            try {
                long result2 = TextFormat.parseInt64(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public boolean tryConsumeInt64() {
            try {
                this.consumeInt64();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public long consumeUInt64() throws ParseException {
            try {
                long result2 = TextFormat.parseUInt64(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public boolean tryConsumeUInt64() {
            try {
                this.consumeUInt64();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public double consumeDouble() throws ParseException {
            if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.currentToken.equalsIgnoreCase("nan")) {
                this.nextToken();
                return Double.NaN;
            }
            try {
                double result2 = Double.parseDouble(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public boolean tryConsumeDouble() {
            try {
                this.consumeDouble();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public float consumeFloat() throws ParseException {
            if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if (FLOAT_NAN.matcher(this.currentToken).matches()) {
                this.nextToken();
                return Float.NaN;
            }
            try {
                float result2 = Float.parseFloat(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public boolean tryConsumeFloat() {
            try {
                this.consumeFloat();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public boolean consumeBoolean() throws ParseException {
            if (this.currentToken.equals("true") || this.currentToken.equals("t") || this.currentToken.equals("1")) {
                this.nextToken();
                return true;
            }
            if (this.currentToken.equals("false") || this.currentToken.equals("f") || this.currentToken.equals("0")) {
                this.nextToken();
                return false;
            }
            throw this.parseException("Expected \"true\" or \"false\".");
        }

        public String consumeString() throws ParseException {
            return this.consumeByteString().toStringUtf8();
        }

        public boolean tryConsumeString() {
            try {
                this.consumeString();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public ByteString consumeByteString() throws ParseException {
            ArrayList<ByteString> list = new ArrayList<ByteString>();
            this.consumeByteString(list);
            while (this.currentToken.startsWith("'") || this.currentToken.startsWith("\"")) {
                this.consumeByteString(list);
            }
            return ByteString.copyFrom(list);
        }

        private void consumeByteString(List<ByteString> list) throws ParseException {
            char quote;
            char c = quote = this.currentToken.length() > 0 ? this.currentToken.charAt(0) : (char)'\u0000';
            if (quote != '\"' && quote != '\'') {
                throw this.parseException("Expected string.");
            }
            if (this.currentToken.length() < 2 || this.currentToken.charAt(this.currentToken.length() - 1) != quote) {
                throw this.parseException("String missing ending quote.");
            }
            try {
                String escaped = this.currentToken.substring(1, this.currentToken.length() - 1);
                ByteString result2 = TextFormat.unescapeBytes(escaped);
                this.nextToken();
                list.add(result2);
            }
            catch (InvalidEscapeSequenceException e) {
                throw this.parseException(e.getMessage());
            }
        }

        public ParseException parseException(String description) {
            return new ParseException(this.line + 1, this.column + 1, description);
        }

        public ParseException parseExceptionPreviousToken(String description) {
            return new ParseException(this.previousLine + 1, this.previousColumn + 1, description);
        }

        private ParseException integerParseException(NumberFormatException e) {
            String string2 = String.valueOf(e.getMessage());
            return this.parseException(string2.length() != 0 ? "Couldn't parse integer: ".concat(string2) : new String("Couldn't parse integer: "));
        }

        private ParseException floatParseException(NumberFormatException e) {
            String string2 = String.valueOf(e.getMessage());
            return this.parseException(string2.length() != 0 ? "Couldn't parse number: ".concat(string2) : new String("Couldn't parse number: "));
        }
    }

    private static final class TextGenerator {
        private final Appendable output;
        private final StringBuilder indent = new StringBuilder();
        private boolean atStartOfLine = true;

        private TextGenerator(Appendable output) {
            this.output = output;
        }

        public void indent() {
            this.indent.append("  ");
        }

        public void outdent() {
            int length = this.indent.length();
            if (length == 0) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.delete(length - 2, length);
        }

        public void print(CharSequence text) throws IOException {
            int size = text.length();
            int pos = 0;
            for (int i = 0; i < size; ++i) {
                if (text.charAt(i) != '\n') continue;
                this.write(text.subSequence(pos, i + 1));
                pos = i + 1;
                this.atStartOfLine = true;
            }
            this.write(text.subSequence(pos, size));
        }

        private void write(CharSequence data) throws IOException {
            if (data.length() == 0) {
                return;
            }
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.indent);
            }
            this.output.append(data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Printer {
        boolean singleLineMode = false;
        boolean escapeNonAscii = true;

        private Printer() {
        }

        private Printer setSingleLineMode(boolean singleLineMode) {
            this.singleLineMode = singleLineMode;
            return this;
        }

        private Printer setEscapeNonAscii(boolean escapeNonAscii) {
            this.escapeNonAscii = escapeNonAscii;
            return this;
        }

        private void print(MessageOrBuilder message, TextGenerator generator) throws IOException {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> field : message.getAllFields().entrySet()) {
                this.printField(field.getKey(), field.getValue(), generator);
            }
            this.printUnknownFields(message.getUnknownFields(), generator);
        }

        private void printField(Descriptors.FieldDescriptor field, Object value2, TextGenerator generator) throws IOException {
            if (field.isRepeated()) {
                for (Object element : (List)value2) {
                    this.printSingleField(field, element, generator);
                }
            } else {
                this.printSingleField(field, value2, generator);
            }
        }

        private void printSingleField(Descriptors.FieldDescriptor field, Object value2, TextGenerator generator) throws IOException {
            if (field.isExtension()) {
                generator.print("[");
                if (field.getContainingType().getOptions().getMessageSetWireFormat() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field.isOptional() && field.getExtensionScope() == field.getMessageType()) {
                    generator.print(field.getMessageType().getFullName());
                } else {
                    generator.print(field.getFullName());
                }
                generator.print("]");
            } else if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator.print(field.getMessageType().getName());
            } else {
                generator.print(field.getName());
            }
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (this.singleLineMode) {
                    generator.print(" { ");
                } else {
                    generator.print(" {\n");
                    generator.indent();
                }
            } else {
                generator.print(": ");
            }
            this.printFieldValue(field, value2, generator);
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (this.singleLineMode) {
                    generator.print("} ");
                } else {
                    generator.outdent();
                    generator.print("}\n");
                }
            } else if (this.singleLineMode) {
                generator.print(" ");
            } else {
                generator.print("\n");
            }
        }

        private void printFieldValue(Descriptors.FieldDescriptor field, Object value2, TextGenerator generator) throws IOException {
            switch (field.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    generator.print(((Integer)value2).toString());
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    generator.print(((Long)value2).toString());
                    break;
                }
                case BOOL: {
                    generator.print(((Boolean)value2).toString());
                    break;
                }
                case FLOAT: {
                    generator.print(((Float)value2).toString());
                    break;
                }
                case DOUBLE: {
                    generator.print(((Double)value2).toString());
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    generator.print(TextFormat.unsignedToString((Integer)value2));
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    generator.print(TextFormat.unsignedToString((Long)value2));
                    break;
                }
                case STRING: {
                    generator.print("\"");
                    generator.print(this.escapeNonAscii ? TextFormat.escapeText((String)value2) : TextFormat.escapeDoubleQuotesAndBackslashes((String)value2));
                    generator.print("\"");
                    break;
                }
                case BYTES: {
                    generator.print("\"");
                    if (value2 instanceof ByteString) {
                        generator.print(TextFormat.escapeBytes((ByteString)value2));
                    } else {
                        generator.print(TextFormat.escapeBytes((byte[])value2));
                    }
                    generator.print("\"");
                    break;
                }
                case ENUM: {
                    generator.print(((Descriptors.EnumValueDescriptor)value2).getName());
                    break;
                }
                case MESSAGE: 
                case GROUP: {
                    this.print((Message)value2, generator);
                }
            }
        }

        private void printUnknownFields(UnknownFieldSet unknownFields, TextGenerator generator) throws IOException {
            for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFields.asMap().entrySet()) {
                int number = entry.getKey();
                UnknownFieldSet.Field field = entry.getValue();
                this.printUnknownField(number, 0, field.getVarintList(), generator);
                this.printUnknownField(number, 5, field.getFixed32List(), generator);
                this.printUnknownField(number, 1, field.getFixed64List(), generator);
                this.printUnknownField(number, 2, field.getLengthDelimitedList(), generator);
                for (UnknownFieldSet value2 : field.getGroupList()) {
                    generator.print(entry.getKey().toString());
                    if (this.singleLineMode) {
                        generator.print(" { ");
                    } else {
                        generator.print(" {\n");
                        generator.indent();
                    }
                    this.printUnknownFields(value2, generator);
                    if (this.singleLineMode) {
                        generator.print("} ");
                        continue;
                    }
                    generator.outdent();
                    generator.print("}\n");
                }
            }
        }

        private void printUnknownField(int number, int wireType, List<?> values2, TextGenerator generator) throws IOException {
            for (Object value2 : values2) {
                generator.print(String.valueOf(number));
                generator.print(": ");
                TextFormat.printUnknownFieldValue(wireType, value2, generator);
                generator.print(this.singleLineMode ? " " : "\n");
            }
        }

        static /* synthetic */ Printer access$100(Printer x0, boolean x1) {
            return x0.setSingleLineMode(x1);
        }

        static /* synthetic */ Printer access$200(Printer x0, boolean x1) {
            return x0.setEscapeNonAscii(x1);
        }
    }
}

