/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.psi.KtExpression;

public class AliasingContext {
    @Nullable
    private final Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors;
    @Nullable
    private final Map<KtExpression, JsExpression> aliasesForExpressions;
    @Nullable
    private final AliasingContext parent;

    @NotNull
    public static AliasingContext getCleanContext() {
        return new AliasingContext(null, null, null);
    }

    private AliasingContext(@Nullable AliasingContext parent2, @Nullable Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors, @Nullable Map<KtExpression, JsExpression> aliasesForExpressions) {
        this.parent = parent2;
        this.aliasesForDescriptors = aliasesForDescriptors;
        this.aliasesForExpressions = aliasesForExpressions;
    }

    @NotNull
    public AliasingContext inner() {
        return new AliasingContext(this, null, null);
    }

    @NotNull
    public AliasingContext inner(@NotNull DeclarationDescriptor descriptor, @NotNull JsExpression alias) {
        if (descriptor == null) {
            AliasingContext.$$$reportNull$$$0(0);
        }
        if (alias == null) {
            AliasingContext.$$$reportNull$$$0(1);
        }
        return new AliasingContext(this, Collections.singletonMap(descriptor, alias), null);
    }

    @NotNull
    public AliasingContext withExpressionsAliased(@NotNull Map<KtExpression, JsExpression> aliasesForExpressions) {
        if (aliasesForExpressions == null) {
            AliasingContext.$$$reportNull$$$0(2);
        }
        return new AliasingContext(this, null, aliasesForExpressions);
    }

    @NotNull
    public AliasingContext withDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsExpression> aliases) {
        if (aliases == null) {
            AliasingContext.$$$reportNull$$$0(3);
        }
        return new AliasingContext(this, aliases, null);
    }

    @Nullable
    public JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            AliasingContext.$$$reportNull$$$0(4);
        }
        JsExpression alias = this.aliasesForDescriptors != null ? this.aliasesForDescriptors.get(descriptor.getOriginal()) : null;
        JsExpression result2 = alias != null || this.parent == null ? alias : this.parent.getAliasForDescriptor(descriptor);
        return result2 != null ? result2.deepCopy() : null;
    }

    @Nullable
    public JsExpression getAliasForExpression(@NotNull KtExpression element) {
        if (element == null) {
            AliasingContext.$$$reportNull$$$0(5);
        }
        JsExpression alias = this.aliasesForExpressions != null ? this.aliasesForExpressions.get(element) : null;
        JsExpression result2 = alias != null || this.parent == null ? alias : this.parent.getAliasForExpression(element);
        return result2 != null ? result2.deepCopy() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliasesForExpressions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliases";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/js/translate/context/AliasingContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "inner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withExpressionsAliased";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withDescriptorsAliased";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAliasForDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getAliasForExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

