/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.profiler.ProfilerSettingsSupport;
import org.graalvm.visualvm.profiling.presets.PresetSelector;
import org.graalvm.visualvm.profiling.presets.ProfilerLocksPanel;
import org.graalvm.visualvm.profiling.presets.ProfilerPreset;
import org.openide.util.NbBundle;

public abstract class LocksSettingsSupport
extends ProfilerSettingsSupport {
    private JPanel container;
    private ProfilerLocksPanel panel;
    private PresetSelector selector;
    private DataViewComponent.DetailsView detailsView;

    DataViewComponent.DetailsView getDetailsView() {
        if (this.detailsView == null) {
            this.detailsView = new DataViewComponent.DetailsView(NbBundle.getMessage(LocksSettingsSupport.class, (String)"LBL_Locks_settings"), null, 30, (JComponent)new ScrollableContainer(this.getComponent()), null);
        }
        return this.detailsView;
    }

    public JComponent getComponent() {
        if (this.container == null) {
            this.createPanel();
        }
        return this.container;
    }

    @Override
    public ProfilingSettings getSettings() {
        this.getComponent();
        return this.panel.getSettings();
    }

    public void saveSettings() {
    }

    void updateSettings(ProfilerPreset preset) {
        this.getComponent();
        this.panel.loadFromPreset(preset);
    }

    public abstract boolean presetValid();

    public boolean settingsValid() {
        this.getComponent();
        return this.panel.settingsValid();
    }

    public void showSettings(DataViewComponent dvc) {
        dvc.selectDetailsView(this.getDetailsView());
    }

    public abstract PresetSelector createSelector(Runnable var1);

    public void setEnabled(boolean enabled) {
        this.getComponent();
        this.container.setEnabled(enabled);
    }

    private JPanel createPanel() {
        this.panel = new ProfilerLocksPanel(){

            public void settingsChanged() {
                LocksSettingsSupport.this.panel.saveToPreset(LocksSettingsSupport.this.selector.customize(LocksSettingsSupport.this.presetValid()));
            }
        };
        this.selector = this.createSelector(new Runnable(){

            @Override
            public void run() {
                LocksSettingsSupport.this.panel.loadFromPreset(LocksSettingsSupport.this.selector.getSelectedPreset());
            }
        });
        this.selector.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.container = new JPanel(new BorderLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component c : this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        this.container.setOpaque(false);
        this.container.add((Component)this.panel, "Center");
        this.container.add((Component)this.selector, "South");
        return this.container;
    }
}

