/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.DrawAble;
import de.escape.quincunx.dxf.DrawLines;
import de.escape.quincunx.dxf.DxfColorModel;
import de.escape.quincunx.dxf.DxfViewer;
import de.escape.quincunx.dxf.LayerList;
import de.escape.quincunx.dxf.LineStyleManager;
import de.escape.quincunx.dxf.TemporaryPainter;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.dxf.reader.DxfLAYER;
import de.escape.quincunx.gimmicks.Utility;
import de.escape.quincunx.i18n.I18n;
import de.escape.quincunx.i18n.Localizable;
import de.escape.quincunx.i18n.RButton;
import de.escape.quincunx.i18n.RChoice;
import de.escape.quincunx.i18n.RLabel;
import de.escape.quincunx.i18n.RPanel;
import de.escape.quincunx.trafo.Matrix4D;
import de.escape.quincunx.trafo.Point3D;
import de.escape.quincunx.trafo.Quaternion;
import de.escape.quincunx.trafo.Vector3D;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Locale;
import java.util.Vector;

public class ModelDrawArea
extends Canvas
implements MouseListener,
MouseMotionListener,
KeyListener,
Localizable,
TemporaryPainter {
    public static final int DEFAULT_NUMBER_PREVIEW_LINES = 5000;
    public static final int NUMBER_PREVIEW_LINES = Utility.getIntProperty("modeldraw.reducelines", 5000);
    private static final int NO_REDUCE = 0;
    private static final int BBOX = 1;
    private static final int LESS = 2;
    private static final int ALL_TYPES = 3;
    private static final boolean BB_USES_ONLY_VISIBLE = true;
    private static final int SOUTH = 1;
    private static final int NORTH = 2;
    private static final int WEST = 4;
    private static final int EAST = 8;
    public static final int CS_NW = 6;
    public static final int CS_NE = 10;
    public static final int CS_SE = 9;
    public static final int CS_SW = 5;
    private static final int COORD_SIZE = 80;
    private static final int COORD_OFFSET = 5;
    private static final float COORD_NO_SHOW = 0.999f;
    private static final int COORD_LINE_PERCENT = 70;
    private static final Color COORD_COLOR = new Color(128, 0, 0);
    private static final Font[] COORD_FONT = new Font[]{new Font("SansSerif", 0, 9), new Font("SansSerif", 0, 10), new Font("SansSerif", 0, 11)};
    DrawAble model;
    private int prevX = -1;
    private int prevY = -1;
    private Matrix4D trafo = new Matrix4D();
    private Matrix4D view = new Matrix4D();
    private Matrix4D trans;
    private Point3D max = new Point3D(-1.0E30f, -1.0E30f, -1.0E30f);
    private Point3D min = new Point3D(1.0E30f, 1.0E30f, 1.0E30f);
    private float diameter;
    private float scale;
    private float dist;
    private Dimension lastSize = new Dimension(-1, -1);
    private DrawAble bBox;
    private int reduceType = 0;
    private int nrLines;
    private int whichReduceType = 1;
    private DxfFile dxf;
    private LineStyleManager lineStyles;
    private Choice reduceChoice;
    LayerList layerList;
    private DxfLAYER layer0;
    private Image offScreenImg;
    private DxfViewer parent;
    private RPanel modelCtrl;
    private Vector trafoStack = new Vector();
    private int stackPos = -1;
    private char initView;
    private Button resetX;
    private Button resetY;
    private Button resetZ;
    private Button forward;
    private Button backward;
    private boolean doPushTrafo = false;
    private boolean swapBW = false;
    private int coordPos = 5;
    private boolean showCoord = true;
    private boolean viewChanged = false;
    private Vector3D startVec;
    private Quaternion rotQuat;
    private Quaternion oldQuat;
    private float radius;
    private boolean rotating = false;
    private static Cursor defaultCursor = Cursor.getDefaultCursor();
    private static Cursor scaleCursor = Cursor.getPredefinedCursor(1);
    private static Cursor moveCursor = Cursor.getPredefinedCursor(13);
    private static Cursor rotateCursor = Cursor.getPredefinedCursor(12);
    private static short whiteColor = (short)7;

    public ModelDrawArea(DxfViewer parent) {
        this(null, null, parent);
    }

    public ModelDrawArea(DrawAble inModel, DxfFile dxf) {
        this(inModel, dxf, null);
    }

    public ModelDrawArea(DrawAble inModel, DxfFile dxf, DxfViewer parent) {
        this.model = inModel;
        this.dxf = dxf;
        this.parent = parent;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setBackground(Color.black);
        if (this.model != null) {
            this.initialize();
        }
    }

    private void initialize() {
        this.max = new Point3D(-1.0E30f, -1.0E30f, -1.0E30f);
        this.min = new Point3D(1.0E30f, 1.0E30f, 1.0E30f);
        this.nrLines = this.model.calcBB(this.min, this.max, null, null, true);
        this.createBBox();
        this.resetTrafos('z');
        this.layer0 = this.dxf.getLayer("0");
    }

    private void resetTrafos(char axis) {
        this.scale = 0.0f;
        this.lastSize.height = -1;
        this.lastSize.width = -1;
        switch (axis) {
            case 'X': 
            case 'x': {
                this.initView = (char)120;
                this.rotQuat = new Quaternion(-0.5f, -0.5f, -0.5f, 0.5f);
                break;
            }
            case 'Y': 
            case 'y': {
                this.initView = (char)121;
                this.rotQuat = new Quaternion(-0.70710677f, 0.0f, 0.0f, 0.70710677f);
                break;
            }
            default: {
                this.initView = (char)122;
                this.rotQuat = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
            }
        }
        this.diameter = this.max.minus(this.min).length();
        this.dist = this.diameter / 1.73f;
        this.calcViewMat();
        this.trans = new Matrix4D(1.0f, 0.0f, 0.0f, -(this.min.x + this.max.x) / 2.0f, 0.0f, 1.0f, 0.0f, -(this.min.y + this.max.y) / 2.0f, 0.0f, 0.0f, 1.0f, -(this.min.z + this.max.z) / 2.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.trafoStack.removeAllElements();
        this.stackPos = -1;
        this.setResetButtons();
        this.forward.setEnabled(false);
        this.backward.setEnabled(false);
        this.doPushTrafo = true;
    }

    private void setResetButtons() {
        this.resetX.setEnabled(this.stackPos > 0 || this.initView != 'x');
        this.resetY.setEnabled(this.stackPos > 0 || this.initView != 'y');
        this.resetZ.setEnabled(this.stackPos > 0 || this.initView != 'z');
    }

    public Component getModelCtrl() {
        if (this.modelCtrl == null) {
            this.modelCtrl = new RPanel();
            GridBagLayout gridBag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            this.modelCtrl.setLayout(gridBag);
            this.reduceChoice = new RChoice();
            this.reduceChoice.addItem("ciMoveFull");
            this.reduceChoice.addItem("ciMoveBBox");
            this.reduceChoice.addItem("ciMoveReduced");
            this.reduceChoice.select(2);
            c.gridwidth = 0;
            c.anchor = 11;
            gridBag.setConstraints(this.reduceChoice, c);
            this.modelCtrl.add(this.reduceChoice);
            RPanel views = new RPanel(new BorderLayout());
            c.insets = new Insets(10, 0, 0, 0);
            c.anchor = 15;
            gridBag.setConstraints(views, c);
            this.modelCtrl.add(views);
            RLabel l = new RLabel("lbViews");
            l.setFont(new Font("TimesRoman", 1, 14));
            views.add("North", l);
            RPanel panel = new RPanel(new BorderLayout());
            views.add("South", panel);
            l = new RLabel("lbResetView");
            panel.add("West", l);
            RPanel p = new RPanel(new GridLayout(1, 3));
            this.resetZ = new RButton("lbResetViewXY");
            this.resetZ.addActionListener(new 1());
            p.add(this.resetZ);
            this.resetX = new RButton("lbResetViewYZ");
            this.resetX.addActionListener(new 2());
            p.add(this.resetX);
            this.resetY = new RButton("lbResetViewXZ");
            this.resetY.addActionListener(new 3());
            p.add(this.resetY);
            panel.add("Center", p);
            p = new RPanel(new GridLayout(1, 2));
            views.add("Center", p);
            this.backward = new RButton("lbPrevious");
            this.backward.addActionListener(new 4());
            p.add(this.backward);
            this.forward = new RButton("lbNext");
            this.forward.addActionListener(new 5());
            p.add(this.forward);
            l = new RLabel("lbLayers");
            l.setFont(new Font("TimesRoman", 1, 14));
            c.anchor = 15;
            gridBag.setConstraints(l, c);
            this.modelCtrl.add(l);
            this.layerList = new LayerList(this);
            c.insets = new Insets(0, 0, 0, 0);
            c.weighty = 1.0;
            c.fill = 1;
            gridBag.setConstraints(this.layerList, c);
            this.modelCtrl.add(this.layerList);
            c.weighty = 0.0;
            c.fill = 2;
            RPanel buttonPanel = new RPanel();
            FlowLayout fl = new FlowLayout();
            buttonPanel.setLayout(fl);
            RButton button = new RButton("lbInvert");
            button.addActionListener(new 6());
            buttonPanel.add(button);
            button = new RButton("lbSelectAll");
            button.addActionListener(new 7());
            buttonPanel.add(button);
            c.gridheight = 0;
            gridBag.setConstraints(buttonPanel, c);
            this.modelCtrl.add(buttonPanel);
        }
        return this.modelCtrl;
    }

    public void setModel(DrawAble model, DxfFile dxf) {
        if (model != null && dxf != null) {
            this.model = model;
            this.dxf = dxf;
            this.layerList.setLayer(dxf.getLayerTable());
            this.lineStyles = new LineStyleManager(dxf);
            this.initialize();
            this.updateView();
        }
    }

    public int getNrLines() {
        return this.nrLines;
    }

    public void showHelp(String msg) {
        if (this.parent != null) {
            this.parent.showHelp(msg);
        }
    }

    public void showHelpRes(String tag) {
        if (this.parent != null) {
            this.parent.showHelpRes(tag);
        }
    }

    public void showHelpRes(String tag, String[] args) {
        if (this.parent != null) {
            this.parent.showHelpRes(tag, args);
        }
    }

    private void scaleInfo() {
        this.setCursor(scaleCursor);
        this.showHelp(I18n.getString("msgScaleInfo", this.getLocale()));
    }

    private void moveInfo() {
        this.setCursor(moveCursor);
        this.showHelp(I18n.getString("msgMoveInfo", this.getLocale()));
    }

    private void rotateInfo() {
        this.setCursor(rotateCursor);
        this.showHelp(I18n.getString("msgRotateInfo", this.getLocale()));
    }

    private void noInfo() {
        this.setCursor(defaultCursor);
        this.showHelp("");
    }

    public void mousePressed(MouseEvent event) {
        if (this.model != null) {
            int mod = event.getModifiers();
            this.prevX = event.getX();
            this.prevY = event.getY();
            if ((mod & 9) != 0) {
                this.moveInfo();
                this.rotating = false;
            } else if ((mod & 6) != 0) {
                this.scaleInfo();
                this.rotating = false;
            } else {
                this.rotateInfo();
                this.rotating = true;
                this.startVec = this.createSphereVector(this.prevX, this.prevY);
                this.oldQuat = this.rotQuat;
            }
            this.reduceType = this.getReduce();
            this.updateView();
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this.model != null) {
            this.noInfo();
            this.reduceType = 0;
            this.prevY = -1;
            this.prevX = -1;
            this.startVec = null;
            this.rotating = false;
            this.doPushTrafo = true;
            this.updateView();
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void mouseDragged(MouseEvent event) {
        if (this.model != null) {
            int x = event.getX();
            int y = event.getY();
            int mod = event.getModifiers();
            if (this.prevX != -1 && this.prevY != -1) {
                if ((mod & 9) != 0) {
                    if (this.getCursor() != moveCursor) {
                        this.moveInfo();
                        this.rotating = false;
                    }
                    Vector3D d = new Vector3D((float)(x - this.prevX) * this.diameter / this.scale, (float)(this.prevY - y) * this.diameter / this.scale, 0.0f);
                    Matrix4D rotInv = this.rotQuat.getMatrix();
                    rotInv.transponize();
                    this.trans.translate(rotInv.mult(d));
                } else if ((mod & 6) != 0) {
                    if (this.getCursor() != scaleCursor) {
                        this.scaleInfo();
                        this.rotating = false;
                    }
                    int dx = x - this.prevX;
                    int dy = y - this.prevY;
                    this.scale *= (float)Math.pow(1.01, dx);
                    this.dist -= (float)dy * (Math.abs(this.dist) + this.diameter) / 500.0f;
                    this.calcViewMat();
                } else {
                    if (this.getCursor() != rotateCursor) {
                        this.rotateInfo();
                        this.rotating = true;
                        this.startVec = this.createSphereVector(x, y);
                        this.oldQuat = this.rotQuat;
                    }
                    Vector3D rotatedVec = this.createSphereVector(x, y);
                    this.rotQuat = new Quaternion(this.startVec, rotatedVec).mult(this.oldQuat);
                }
                this.updateView();
            } else if (this.rotating) {
                this.startVec = this.createSphereVector(x, y);
                this.oldQuat = this.rotQuat;
            }
            this.prevX = x;
            this.prevY = y;
        }
    }

    private Vector3D createSphereVector(int x, int y) {
        Dimension size = this.getSize();
        this.radius = 0.3f * (float)Math.sqrt(size.width * size.width + size.height * size.height);
        Vector3D mouse = new Vector3D((float)(x - size.width / 2) / this.radius, (float)(size.height / 2 - y) / this.radius, 0.0f);
        float mag = mouse.x * mouse.x + mouse.y * mouse.y;
        if (mag > 1.0f) {
            mouse.scale(1.0f / (float)Math.sqrt(mag));
        } else {
            mouse.z = (float)Math.sqrt(1.0f - mag);
        }
        return mouse;
    }

    public void swapBlackAndWhite(boolean invert) {
        if (this.swapBW != invert) {
            this.swapBW = invert;
            this.updateView();
        }
    }

    public void keyReleased(KeyEvent event) {
        if (this.model != null) {
            switch (event.getKeyCode()) {
                case 36: 
                case 90: 
                case 122: {
                    this.resetTrafos('z');
                    event.consume();
                    this.updateView();
                    break;
                }
                case 88: 
                case 120: {
                    this.resetTrafos('x');
                    event.consume();
                    this.updateView();
                    break;
                }
                case 89: 
                case 121: {
                    this.resetTrafos('y');
                    event.consume();
                    this.updateView();
                    break;
                }
                case 82: 
                case 114: {
                    this.whichReduceType = (this.whichReduceType + 1) % 3;
                    event.consume();
                    break;
                }
            }
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void update(Graphics g) {
        if (this.model == null) {
            super.update(g);
        } else {
            this.paint(g);
        }
    }

    private void pushTrafo() {
        this.doPushTrafo = false;
        if (this.stackPos < this.trafoStack.size()) {
            int i = this.trafoStack.size() - 1;
            while (i > this.stackPos) {
                this.trafoStack.removeElementAt(i);
                --i;
            }
        }
        this.trafoStack.addElement(new TrafoChunk(this.scale, this.dist, this.rotQuat, this.trans));
        ++this.stackPos;
        this.forward.setEnabled(false);
        this.backward.setEnabled(this.stackPos > 0);
        this.setResetButtons();
    }

    void updateView() {
        this.viewChanged = true;
        this.repaint();
    }

    public void paint(Graphics g) {
        if (this.model != null) {
            if (this.layer0 == null) {
                this.layer0 = this.dxf.getLayer("0");
            }
            if (!this.lastSize.equals(this.getSize())) {
                Dimension size = this.getSize();
                if (size.width <= 0 || size.height <= 0) {
                    this.invalidate();
                    this.repaint();
                    return;
                }
                this.calcViewMat();
                this.viewChanged = true;
            }
            if (!this.viewChanged) {
                if (this.offScreenImg != null) {
                    g.drawImage(this.offScreenImg, 0, 0, this);
                }
            } else {
                this.viewChanged = false;
                this.trafo = this.view.mult(this.rotQuat.getMatrix().mult(this.trans));
                if (this.doPushTrafo) {
                    this.pushTrafo();
                }
                if (this.offScreenImg != null) {
                    DxfColorModel dxfcolors = this.swapBW ? DxfColorModel.getSwappedBWColors() : DxfColorModel.getNormalColors();
                    Graphics offScreenGC = this.offScreenImg.getGraphics();
                    offScreenGC.setColor(dxfcolors.getBackgroundColor());
                    offScreenGC.fillRect(0, 0, this.lastSize.width, this.lastSize.height);
                    offScreenGC.setClip(new Rectangle(0, 0, this.lastSize.width, this.lastSize.height));
                    switch (this.reduceType) {
                        case 0: {
                            this.model.draw(offScreenGC, this.trafo, this.layer0, dxfcolors, whiteColor, this.lineStyles, null);
                            break;
                        }
                        case 1: {
                            this.bBox.draw(offScreenGC, this.trafo, null, dxfcolors, whiteColor);
                            break;
                        }
                        case 2: {
                            this.model.draw(offScreenGC, this.trafo, this.layer0, dxfcolors, whiteColor, 0, this.nrLines / NUMBER_PREVIEW_LINES);
                            break;
                        }
                    }
                    if (this.showCoord) {
                        this.drawCoordSystem(offScreenGC, dxfcolors.getColor(whiteColor), dxfcolors.getBackgroundColor());
                    }
                    if (this.rotating) {
                        Dimension size = this.getSize();
                        int diameter = (int)(2.0f * this.radius);
                        offScreenGC.setColor(COORD_COLOR);
                        offScreenGC.drawOval((size.width - diameter) / 2, (size.height - diameter) / 2, diameter, diameter);
                    }
                    g.drawImage(this.offScreenImg, 0, 0, this);
                }
            }
        }
    }

    private void drawCoordSystem(Graphics g, Color fg, Color bg) {
        Dimension size = this.getSize();
        int midx = (this.coordPos & 8) != 0 ? size.width - 40 - 5 - 1 : 45;
        int midy = (this.coordPos & 1) != 0 ? size.height - 40 - 5 - 1 : 45;
        g = g.create();
        g.translate(midx, midy);
        g.setClip(-40, -40, 80, 80);
        g.setColor(bg);
        g.fillRect(-40, -40, 80, 80);
        Matrix4D rot = this.rotQuat.getMatrix();
        Vector3D x = new Vector3D(1.0f, 0.0f, 0.0f);
        Vector3D y = new Vector3D(0.0f, 1.0f, 0.0f);
        Vector3D z = new Vector3D(0.0f, 0.0f, 1.0f);
        rot.transform(x);
        rot.transform(y);
        rot.transform(z);
        g.setColor(fg);
        if ((double)x.z < -0.001) {
            this.drawCoordLetter(g, 'x', x);
        }
        if ((double)y.z < -0.001) {
            this.drawCoordLetter(g, 'y', y);
        }
        if ((double)z.z < -0.001) {
            this.drawCoordLetter(g, 'z', z);
        }
        g.setColor(COORD_COLOR);
        this.drawCoordLine(g, x);
        this.drawCoordLine(g, y);
        this.drawCoordLine(g, z);
        g.setColor(fg);
        if ((double)x.z >= -0.001) {
            this.drawCoordLetter(g, 'x', x);
        }
        if ((double)y.z >= -0.001) {
            this.drawCoordLetter(g, 'y', y);
        }
        if ((double)z.z >= -0.001) {
            this.drawCoordLetter(g, 'z', z);
        }
    }

    private void drawCoordLetter(Graphics g, char letter, Vector3D vector) {
        int fontnr = (int)Math.floor((vector.z + 0.999f) / 1.998f * (float)COORD_FONT.length);
        if (fontnr >= 0 && fontnr < COORD_FONT.length) {
            g.setFont(COORD_FONT[fontnr]);
            int cx = (int)(vector.x * 170.0f / 2.0f * 80.0f / 2.0f) / 100;
            int cy = -((int)(vector.y * 170.0f / 2.0f * 80.0f / 2.0f)) / 100;
            FontMetrics fm = g.getFontMetrics();
            int len = fm.charWidth(letter);
            g.drawChars(new char[]{letter}, 0, 1, cx - len / 2, cy + fm.getHeight() / 2 - fm.getMaxDescent());
        }
    }

    private void drawCoordLine(Graphics g, Vector3D v) {
        int px = (int)(v.x * 70.0f * 80.0f / 2.0f) / 100;
        int py = -((int)(v.y * 70.0f * 80.0f / 2.0f)) / 100;
        if (px != 0 || py != 0) {
            g.drawLine(-px, -py, px, py);
        }
    }

    public boolean getShowCoord() {
        return this.showCoord;
    }

    public void setShowCoord(boolean onOff) {
        if (onOff != this.showCoord) {
            this.showCoord = onOff;
            this.updateView();
        }
    }

    public int getCoordPosition() {
        return this.coordPos;
    }

    public void setCoordPos(int pos) {
        switch (pos) {
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                if (this.coordPos == pos) break;
                this.coordPos = pos;
                if (!this.showCoord) break;
                this.updateView();
            }
        }
    }

    private void calcViewMat() {
        Dimension newSize = this.getSize();
        if (this.lastSize.width != newSize.width || this.lastSize.height != newSize.height) {
            float lastScale;
            if (newSize.width <= 0) {
                newSize.width = 10;
            }
            if (newSize.height <= 0) {
                newSize.height = 10;
            }
            if (this.scale != 0.0f) {
                lastScale = this.lastSize.width < this.lastSize.height ? this.lastSize.width : this.lastSize.height;
            } else {
                lastScale = 1.0f;
                this.scale = 1.0f;
            }
            this.lastSize = newSize;
            float newScale = this.lastSize.width < this.lastSize.height ? this.lastSize.width : this.lastSize.height;
            this.scale *= newScale / lastScale;
            this.offScreenImg = this.createImage(this.lastSize.width, this.lastSize.height);
        }
        this.view.identity();
        this.view.translate(this.lastSize.width / 2, this.lastSize.height / 2, 0.0f);
        this.view.multBy(new Matrix4D(this.scale, 0.0f, 0.0f, 0.0f, 0.0f, -this.scale, 0.0f, 0.0f, 0.0f, 0.0f, -32.0f, 0.0f, 0.0f, 0.0f, -1.0f, this.dist));
        this.view.translate(0.0f, 0.0f, -this.diameter / 2.0f);
    }

    private void createBBox() {
        DrawLines lines = new DrawLines(4);
        lines.addPoint(this.min.x, this.min.y, this.min.z);
        lines.addPoint(this.max.x, this.min.y, this.min.z);
        lines.addPoint(this.max.x, this.max.y, this.min.z);
        lines.addPoint(this.min.x, this.max.y, this.min.z);
        lines.close();
        this.bBox = lines.extrude(this.max.z - this.min.z);
    }

    private int getReduce() {
        switch (this.reduceChoice.getSelectedIndex()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public void print(PrintJob job, boolean monochrome, boolean rotated) {
        if (this.model != null) {
            Dimension pageSize = job.getPageDimension();
            Graphics pg = job.getGraphics();
            pg.setClip(new Rectangle(0, 0, pageSize.width, pageSize.height));
            this.paintTemporary(pg, pageSize, rotated, true, monochrome, 0);
            pg.dispose();
        }
    }

    public boolean paintTemporary(Graphics g, Dimension size, boolean rotate, boolean exchangeBW, boolean monochrome, int numberLines) {
        g.setClip(0, 0, size.width, size.height);
        if (this.model != null) {
            float lastscale;
            if (rotate) {
                size = new Dimension(size.height, size.width);
            }
            Matrix4D v = new Matrix4D();
            if (this.scale != 0.0f) {
                lastscale = this.lastSize.width < this.lastSize.height ? this.lastSize.width : this.lastSize.height;
            } else {
                lastscale = 1.0f;
                float f = 1.0f;
            }
            float newscale = size.width < size.height ? size.width : size.height;
            float myscale = this.scale * newscale / lastscale;
            v.translate(size.width / 2, size.height / 2, 0.0f);
            v.multBy(new Matrix4D(myscale, 0.0f, 0.0f, 0.0f, 0.0f, -myscale, 0.0f, 0.0f, 0.0f, 0.0f, -32.0f, 0.0f, 0.0f, 0.0f, -1.0f, this.dist));
            v.translate(0.0f, 0.0f, -this.diameter / 2.0f);
            Matrix4D tmat = v.mult(this.rotQuat.getMatrix().mult(this.trans));
            if (rotate) {
                tmat.zrot(-1.5707963267948966);
                tmat.translateLeft(0.0f, size.width, 0.0f);
            }
            if (numberLines <= 0 || numberLines > this.nrLines / 2) {
                this.model.draw(g, tmat, this.layer0, monochrome ? DxfColorModel.getMonochromeColors() : (exchangeBW ? DxfColorModel.getSwappedBWColors() : DxfColorModel.getNormalColors()), whiteColor, this.lineStyles, null);
            } else {
                this.model.draw(g, tmat, this.layer0, monochrome ? DxfColorModel.getMonochromeColors() : (exchangeBW ? DxfColorModel.getSwappedBWColors() : DxfColorModel.getNormalColors()), whiteColor, 0, this.nrLines / numberLines);
            }
            return true;
        }
        return false;
    }

    public synchronized void goBackward() {
        if (this.model != null && this.stackPos > 0) {
            TrafoChunk chunk = (TrafoChunk)this.trafoStack.elementAt(--this.stackPos);
            this.scale = chunk.scale;
            this.dist = chunk.dist;
            this.rotQuat = new Quaternion(chunk.rot);
            this.trans = new Matrix4D(chunk.trans);
            this.calcViewMat();
            this.forward.setEnabled(true);
            this.backward.setEnabled(this.stackPos > 0);
            this.setResetButtons();
            this.updateView();
        }
    }

    public synchronized void goForward() {
        if (this.model != null && this.stackPos < this.trafoStack.size() - 1) {
            TrafoChunk chunk = (TrafoChunk)this.trafoStack.elementAt(++this.stackPos);
            this.scale = chunk.scale;
            this.dist = chunk.dist;
            this.rotQuat = new Quaternion(chunk.rot);
            this.trans = new Matrix4D(chunk.trans);
            this.calcViewMat();
            this.forward.setEnabled(this.stackPos < this.trafoStack.size() - 1);
            this.backward.setEnabled(true);
            this.setResetButtons();
            this.updateView();
        }
    }

    public synchronized void resetViewStack(char axis) {
        if (this.model != null) {
            this.resetTrafos(axis);
            this.updateView();
        }
    }

    public Point3D getMinPoint() {
        return new Point3D(this.min);
    }

    public Point3D getMaxPoint() {
        return new Point3D(this.max);
    }

    public void setLocale(Locale l) {
        super.setLocale(l);
        this.modelCtrl.setLocale(l);
    }

    public int getNumberOfLayers() {
        return this.layerList.getItemCount();
    }

    public String getLayerName(int index) {
        if (index < this.getNumberOfLayers() && index >= 0) {
            return this.layerList.getItem(index);
        }
        return null;
    }

    public boolean isLayerVisible(String name) {
        int index = this.layerList.getIndex(name);
        return index >= 0 ? this.layerList.isIndexSelected(index) : false;
    }

    public void setLayerVisible(String name, boolean visible) {
        int index = this.layerList.getIndex(name);
        if (index >= 0) {
            this.layerList.setSelected(index, visible);
        }
    }

    public boolean isSwapBW() {
        return this.swapBW;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            ModelDrawArea.this.resetViewStack('z');
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            ModelDrawArea.this.resetViewStack('x');
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            ModelDrawArea.this.resetViewStack('y');
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            ModelDrawArea.this.goBackward();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            ModelDrawArea.this.goForward();
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            if (ModelDrawArea.this.model != null) {
                ModelDrawArea.this.layerList.invertSelections();
            }
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            if (ModelDrawArea.this.model != null) {
                ModelDrawArea.this.layerList.selectAll();
            }
        }

        /* synthetic */ 7() {
        }
    }

    static class TrafoChunk {
        float scale;
        float dist;
        Quaternion rot;
        Matrix4D trans;

        TrafoChunk(float sc, float d, Quaternion r, Matrix4D t) {
            this.scale = sc;
            this.dist = d;
            this.rot = new Quaternion(r);
            this.trans = new Matrix4D(t);
        }
    }
}

