/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.Minim;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.FloatControl;
import processing.core.PApplet;

public class Controller {
    public static FloatControl.Type VOLUME = FloatControl.Type.VOLUME;
    public static FloatControl.Type GAIN = FloatControl.Type.MASTER_GAIN;
    public static FloatControl.Type BALANCE = FloatControl.Type.BALANCE;
    public static FloatControl.Type PAN = FloatControl.Type.PAN;
    public static FloatControl.Type SAMPLE_RATE = FloatControl.Type.SAMPLE_RATE;
    public static BooleanControl.Type MUTE = BooleanControl.Type.MUTE;
    private Control[] controls;
    private ValueShifter vshifter;
    private ValueShifter gshifter;
    private ValueShifter bshifter;
    private ValueShifter pshifter;
    private boolean vshift;
    private boolean gshift;
    private boolean bshift;
    private boolean pshift;

    public Controller(Control[] cntrls) {
        this.controls = cntrls;
        this.pshift = false;
        this.bshift = false;
        this.gshift = false;
        this.vshift = false;
    }

    void update() {
        if (this.vshift) {
            this.setVolume(this.vshifter.value());
            if (this.vshifter.done()) {
                this.vshift = false;
            }
        }
        if (this.gshift) {
            this.setGain(this.gshifter.value());
            if (this.gshifter.done()) {
                this.gshift = false;
            }
        }
        if (this.bshift) {
            this.setBalance(this.bshifter.value());
            if (this.bshifter.done()) {
                this.bshift = false;
            }
        }
        if (this.pshift) {
            this.setPan(this.pshifter.value());
            if (this.pshifter.done()) {
                this.pshift = false;
            }
        }
    }

    public void printControls() {
        if (this.controls.length > 0) {
            PApplet.println((String)"Available controls are:");
            int i = 0;
            while (i < this.controls.length) {
                Control.Type type = this.controls[i].getType();
                PApplet.print((String)("  " + type.toString()));
                if (type == VOLUME || type == GAIN || type == BALANCE || type == PAN) {
                    FloatControl fc = (FloatControl)this.controls[i];
                    String shiftSupported = "does";
                    if (fc.getUpdatePeriod() == -1) {
                        shiftSupported = "doesn't";
                    }
                    PApplet.println((String)(", which has a range of " + fc.getMaximum() + " to " + fc.getMinimum() + " and " + shiftSupported + " support shifting."));
                } else {
                    PApplet.println((String)"");
                }
                ++i;
            }
        } else {
            PApplet.println((String)"There are no controls available for this line.");
        }
    }

    public boolean hasControl(Control.Type type) {
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i].getType().equals(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Control[] getControls() {
        return this.controls;
    }

    public Control getControl(Control.Type type) {
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i].getType().equals(type)) {
                return this.controls[i];
            }
            ++i;
        }
        return null;
    }

    public FloatControl volume() {
        return (FloatControl)this.getControl(VOLUME);
    }

    public FloatControl gain() {
        return (FloatControl)this.getControl(GAIN);
    }

    public FloatControl balance() {
        return (FloatControl)this.getControl(BALANCE);
    }

    public FloatControl pan() {
        return (FloatControl)this.getControl(PAN);
    }

    public void mute() {
        this.setValue(MUTE, true);
    }

    public void unmute() {
        this.setValue(MUTE, false);
    }

    public boolean isMuted() {
        return this.getValue(MUTE);
    }

    private boolean getValue(BooleanControl.Type type) {
        boolean v = false;
        if (this.hasControl(type)) {
            BooleanControl c = (BooleanControl)this.getControl(type);
            v = c.getValue();
        } else {
            Minim.error(String.valueOf(type.toString()) + " is not supported.");
        }
        return v;
    }

    private void setValue(BooleanControl.Type type, boolean v) {
        if (this.hasControl(type)) {
            BooleanControl c = (BooleanControl)this.getControl(type);
            c.setValue(v);
        } else {
            Minim.error(String.valueOf(type.toString()) + " is not supported.");
        }
    }

    private float getValue(FloatControl.Type type) {
        float v = 0.0f;
        if (this.hasControl(type)) {
            FloatControl c = (FloatControl)this.getControl(type);
            v = c.getValue();
        } else {
            Minim.error(String.valueOf(type.toString()) + " is not supported.");
        }
        return v;
    }

    private void setValue(FloatControl.Type type, float v) {
        if (this.hasControl(type)) {
            FloatControl c = (FloatControl)this.getControl(type);
            if (v > c.getMaximum()) {
                v = c.getMaximum();
            } else if (v < c.getMinimum()) {
                v = c.getMinimum();
            }
            c.setValue(v);
        } else {
            Minim.error(String.valueOf(type.toString()) + " is not supported.");
        }
    }

    public float getVolume() {
        return this.getValue(VOLUME);
    }

    public void setVolume(float v) {
        this.setValue(VOLUME, v);
    }

    public void shiftVolume(float from, float to, int millis) {
        if (this.hasControl(VOLUME)) {
            this.setVolume(from);
            this.vshifter = new ValueShifter(from, to, millis);
            this.vshift = true;
        }
    }

    public float getGain() {
        return this.getValue(GAIN);
    }

    public void setGain(float v) {
        this.setValue(GAIN, v);
    }

    public void shiftGain(float from, float to, int millis) {
        if (this.hasControl(GAIN)) {
            this.setGain(from);
            this.gshifter = new ValueShifter(from, to, millis);
            this.gshift = true;
        }
    }

    public float getBalance() {
        return this.getValue(BALANCE);
    }

    public void setBalance(float v) {
        this.setValue(BALANCE, v);
    }

    public void shiftBalance(float from, float to, int millis) {
        if (this.hasControl(BALANCE)) {
            this.setBalance(from);
            this.bshifter = new ValueShifter(from, to, millis);
            this.bshift = true;
        }
    }

    public float getPan() {
        return this.getValue(PAN);
    }

    public void setPan(float v) {
        this.setValue(PAN, v);
    }

    public void shiftPan(float from, float to, int millis) {
        if (this.hasControl(PAN)) {
            this.setPan(from);
            this.pshifter = new ValueShifter(from, to, millis);
            this.pshift = true;
        }
    }

    class ValueShifter {
        private float tstart = (int)System.currentTimeMillis();
        private float tend;
        private float vstart;
        private float vend;

        public ValueShifter(float vs, float ve, int t) {
            this.tend = this.tstart + (float)t;
            this.vstart = vs;
            this.vend = ve;
        }

        public float value() {
            int millis = (int)System.currentTimeMillis();
            return PApplet.map((float)millis, (float)this.tstart, (float)this.tend, (float)this.vstart, (float)this.vend);
        }

        public boolean done() {
            return (float)((int)System.currentTimeMillis()) > this.tend;
        }
    }
}

