/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.network;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SocksProxy {
    private static final Logger logger = LogManager.getLogger(SocksProxy.class);
    private final String host;
    private final int port;
    private final Version version;
    private final boolean useDns;

    public SocksProxy(String host, int port) {
        this(host, port, Version.SOCKS5, true);
    }

    public SocksProxy(String host, int port, Version version, boolean useDns) {
        Objects.requireNonNull(host, "The host must not be null.");
        Objects.requireNonNull(version, "The version must not be null.");
        if (host.isEmpty()) {
            throw new IllegalArgumentException("The host must not be empty.");
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("The port is not valid, must be between 0 and 65535.");
        }
        this.host = host;
        this.port = port;
        this.version = version;
        this.useDns = useDns;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isUseDns() {
        return this.useDns;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.useDns, this.version.number);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SocksProxy other = (SocksProxy)obj;
        return Objects.equals(this.host, other.host) && this.port == other.port && this.useDns == other.useDns && this.version == other.version;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder(75);
        strBuilder.append("[Host=").append(this.host);
        strBuilder.append(", Port=").append(this.port);
        strBuilder.append(", Version=").append(this.version.number);
        strBuilder.append(", UseDns=").append(this.useDns);
        strBuilder.append(']');
        return strBuilder.toString();
    }

    public static enum Version {
        SOCKS4a(4),
        SOCKS5(5);

        private final int number;

        private Version(int number) {
            this.number = number;
        }

        public int number() {
            return this.number;
        }

        public static Version from(String value) {
            int number;
            if (value == null || value.isEmpty()) {
                return SOCKS5;
            }
            try {
                number = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                logger.warn("Failed to parse the version: " + value, (Throwable)e);
                return SOCKS5;
            }
            if (number == Version.SOCKS4a.number) {
                return SOCKS4a;
            }
            if (number == Version.SOCKS5.number) {
                return SOCKS5;
            }
            logger.warn("Unknown version: " + value);
            return SOCKS5;
        }
    }
}

